/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataBaseOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DataBasePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private DataBaseOraclev10g database;
    private JComboBox cbControlFileReuse;
    private JIntegerField ifMaxLogFiles;
    private JIntegerField ifMaxLogMembers;
    private JIntegerField ifMaxLogHistory;
    private JIntegerField ifMaxDataFiles;
    private JIntegerField ifMaxInstances;
    private JComboBox cbArchiveLog;
    private JTextField tfCharSet;
    private JTextField tfNationalCharSet;
    private JComboBox cbForceLogging;
    private JComboBox cbExtentManagement;
    private JPasswordField passForSYS;
    private JPasswordField passForSYSTEM;
    private JTextField tfTimeZone;
    private JComboBox cbTempTablespace;
    private JComboBox cbUndoTablespace;
    private JPanel loggingAndTablespacesPanel;

    public DataBasePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.database = (DataBaseOraclev10g)object;
        this.setHeight(320);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 630;
    }

    @Override
    public String getCaption() {
        return Messages.getString("DatabasePropertyDialogOracle.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initControlFileReuse();
        this.initMaxDataFiles();
        this.initMaxInstances();
        this.initCharSet();
        this.initNationalCharSet();
        this.initPassForSYS();
        this.initPassForSYSTEM();
        this.initTimeZone();
    }

    private void initControlFileReuse() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.ControlFileReuse"));
        this.general.add(label);
        this.cbControlFileReuse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbControlFileReuse);
        this.cbControlFileReuse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbControlFileReuse);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbControlFileReuse, 50);
    }

    private void initMaxDataFiles() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.MaxDataFiles"));
        this.general.add(label);
        this.ifMaxDataFiles = new JIntegerField(0, 26);
        this.general.add(this.ifMaxDataFiles);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifMaxDataFiles, 80);
    }

    private void initMaxInstances() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.MaxInstances"));
        this.general.add(label);
        this.ifMaxInstances = new JIntegerField(0, 26);
        this.general.add(this.ifMaxInstances);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifMaxInstances, 110);
    }

    private void initCharSet() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.CharSet"));
        this.general.add(label);
        this.tfCharSet = new JTextField("", 26);
        this.general.add(this.tfCharSet);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfCharSet, 140);
    }

    private void initNationalCharSet() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.NationalCharSet"));
        this.general.add(label);
        this.tfNationalCharSet = new JTextField("", 26);
        this.general.add(this.tfNationalCharSet);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfNationalCharSet, 170);
    }

    private void initPassForSYS() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.PassForSYS"));
        this.general.add(label);
        this.passForSYS = new JPasswordField();
        this.setBG(this.passForSYS);
        this.passForSYS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passForSYS);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.passForSYS, 200);
    }

    private void initPassForSYSTEM() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.PassForSYSTEM"));
        this.general.add(label);
        this.passForSYSTEM = new JPasswordField();
        this.setBG(this.passForSYSTEM);
        this.passForSYSTEM.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passForSYSTEM);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.passForSYSTEM, 230);
    }

    private void initTimeZone() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.TimeZone"));
        this.general.add(label);
        this.tfTimeZone = new JTextField("", 26);
        this.general.add(this.tfTimeZone);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfTimeZone, 260);
    }

    @Override
    protected void addTabs() {
        this.initLoggingAndTablespacesView();
    }

    private void initLoggingAndTablespacesView() {
        this.loggingAndTablespacesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("DatabasePropertyDialogOracle.LoggingAndTablespaces"), this.loggingAndTablespacesPanel);
        this.initMaxLogFiles();
        this.initMaxLogMembers();
        this.initMaxLogHistory();
        this.initArchiveLog();
        this.initForceLogging();
        this.initExtentMangement();
        this.initTempTablespace();
        this.initUndoTablespace();
    }

    private void initMaxLogFiles() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.MaxLogFiles"));
        this.loggingAndTablespacesPanel.add(label);
        this.ifMaxLogFiles = new JIntegerField(0, 26);
        this.loggingAndTablespacesPanel.add(this.ifMaxLogFiles);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 20);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.ifMaxLogFiles, 20);
    }

    private void initMaxLogMembers() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.MaxLogMembers"));
        this.loggingAndTablespacesPanel.add(label);
        this.ifMaxLogMembers = new JIntegerField(0, 26);
        this.loggingAndTablespacesPanel.add(this.ifMaxLogMembers);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 50);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.ifMaxLogMembers, 50);
    }

    private void initMaxLogHistory() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.MaxLogHistory"));
        this.loggingAndTablespacesPanel.add(label);
        this.ifMaxLogHistory = new JIntegerField(0, 26);
        this.loggingAndTablespacesPanel.add(this.ifMaxLogHistory);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 80);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.ifMaxLogHistory, 80);
    }

    private void initArchiveLog() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.ArchiveLog"));
        this.loggingAndTablespacesPanel.add(label);
        this.cbArchiveLog = new JComboBox<String>(YES_NO);
        this.setBG(this.cbArchiveLog);
        this.cbArchiveLog.setPreferredSize(this.tfName.getPreferredSize());
        this.loggingAndTablespacesPanel.add(this.cbArchiveLog);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 110);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.cbArchiveLog, 110);
    }

    private void initForceLogging() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.ForceLogging"));
        this.loggingAndTablespacesPanel.add(label);
        this.cbForceLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForceLogging);
        this.cbForceLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.loggingAndTablespacesPanel.add(this.cbForceLogging);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 140);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.cbForceLogging, 140);
    }

    private void initExtentMangement() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.ExtentManagement"));
        this.loggingAndTablespacesPanel.add(label);
        this.cbExtentManagement = new JComboBox<String>(DataBaseOraclev9i.getExtentManagementTypes());
        this.setBG(this.cbExtentManagement);
        this.cbExtentManagement.setPreferredSize(this.tfName.getPreferredSize());
        this.loggingAndTablespacesPanel.add(this.cbExtentManagement);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 170);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.cbExtentManagement, 170);
    }

    private void initTempTablespace() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.TempTablespace"));
        this.loggingAndTablespacesPanel.add(label);
        this.cbTempTablespace = new JComboBox();
        this.setBG(this.cbTempTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTemporaryTablespaceSet().toArray(), this.cbTempTablespace);
        }
        this.cbTempTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.loggingAndTablespacesPanel.add(this.cbTempTablespace);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 200);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.cbTempTablespace, 200);
    }

    private void initUndoTablespace() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogOracle.UndoTablespace"));
        this.loggingAndTablespacesPanel.add(label);
        this.cbUndoTablespace = new JComboBox();
        this.setBG(this.cbUndoTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(((StorageDesignOraclev10g)this.getStorageDesign()).getUndoTablespaceSet().toArray(), this.cbUndoTablespace);
        }
        this.cbUndoTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.loggingAndTablespacesPanel.add(this.cbUndoTablespace);
        this.setLabelConstraints(this.getLoggingAndTablespacesLayout(), label, 230);
        this.setObjectConstraints(this.getLoggingAndTablespacesLayout(), this.cbUndoTablespace, 230);
    }

    protected SpringLayout getLoggingAndTablespacesLayout() {
        return (SpringLayout)this.loggingAndTablespacesPanel.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.cbControlFileReuse.setSelectedItem(DataBasePropertyDialogOraclev10g.translateYesNoForDisplay(this.database.getControlFileReuse()));
        this.ifMaxLogFiles.setValue((long)this.database.getMaxLogFiles());
        this.ifMaxLogMembers.setValue((long)this.database.getMaxLogMembers());
        this.ifMaxLogHistory.setValue((long)this.database.getMaxLogHistory());
        this.ifMaxDataFiles.setValue((long)this.database.getMaxDataFiles());
        this.ifMaxInstances.setValue((long)this.database.getMaxInstances());
        this.cbArchiveLog.setSelectedItem(DataBasePropertyDialogOraclev10g.translateYesNoForDisplay(this.database.getArchiveLog()));
        this.tfCharSet.setText(this.database.getCharacterSet());
        this.tfNationalCharSet.setText(this.database.getNationalCharacterSet());
        this.cbForceLogging.setSelectedItem(DataBasePropertyDialogOraclev10g.translateYesNoForDisplay(this.database.getForceLogging()));
        this.cbExtentManagement.setSelectedItem(this.database.getExtentManagement());
        this.passForSYS.setText(this.database.getPassForSYS());
        this.passForSYSTEM.setText(this.database.getPassForSYSTEM());
        this.tfTimeZone.setText(this.database.getTimeZone());
        this.cbTempTablespace.setSelectedItem(this.database.getTempTablespace());
        this.cbUndoTablespace.setSelectedItem(this.database.getUndoTablespace());
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setControlFileReuse(DataBasePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbControlFileReuse.getSelectedItem()));
            this.database.setMaxLogFiles(this.ifMaxLogFiles.getIntValue());
            this.database.setMaxLogMembers(this.ifMaxLogMembers.getIntValue());
            this.database.setMaxLogHistory(this.ifMaxLogHistory.getIntValue());
            this.database.setMaxDataFiles(this.ifMaxDataFiles.getIntValue());
            this.database.setMaxInstances(this.ifMaxInstances.getIntValue());
            this.database.setArchiveLog(DataBasePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbArchiveLog.getSelectedItem()));
            this.database.setCharacterSet(this.tfCharSet.getText());
            this.database.setNationalCharacterSet(this.tfNationalCharSet.getText());
            this.database.setForceLogging(DataBasePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbForceLogging.getSelectedItem()));
            this.database.setExtentManagement((String)this.cbExtentManagement.getSelectedItem());
            this.database.setPassForSYS(String.valueOf(this.passForSYS.getPassword()));
            this.database.setPassForSYSTEM(String.valueOf(this.passForSYSTEM.getPassword()));
            this.database.setTimeZone(this.tfTimeZone.getText());
            this.database.setTempTablespace((TemporaryTablespaceOraclev10g)this.cbTempTablespace.getSelectedItem());
            this.database.setUndoTablespace((UndoTablespaceOraclev10g)this.cbUndoTablespace.getSelectedItem());
            this.database.setComment(this.getCommentsList().getText());
        }
    }
}

