/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePropertyDialogDB2v80;

public class TableSpacePropertyDialogDB2v80
extends TableSpacePropertyDialogDB2 {
    private JComboBox cbPartTable;

    public TableSpacePropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tableSpace = (TableSpaceDB2v80)object;
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPartTable();
    }

    protected void initPartTable() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogDB2v80.PartitionTable"));
        this.general.add(label);
        this.cbPartTable = new JComboBox();
        this.setBG(this.cbPartTable);
        this.cbPartTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartTable.setEnabled(false);
        this.general.add(this.cbPartTable);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbPartTable, 260);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initUsePrivilegesView();
        this.initTablesView();
        this.initPartitionsOrderView();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2v80.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        btnUp.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.MoveUp"));
        btnUp.addActionListener(new MoveUpAction());
        JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        btnDown.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.MoveDown"));
        btnDown.addActionListener(new MoveDownAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnUp);
        toolBar.add(btnDown);
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add((Component)buttonGeneral, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        JScrollPane sp = new JScrollPane(this.partitionsList);
        sp.setPreferredSize(new Dimension(400, 510));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
    }

    @Override
    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2v80.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tablesList);
        spTS.setPreferredSize(new Dimension(395, 540));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbType.setSelectedItem(this.tableSpace.getType());
        this.cbClustered.setSelectedItem(TableSpacePropertyDialogDB2v80.translateYesNoForDisplay(this.tableSpace.getClustered()));
        this.selectObject(this.cbDB, this.tableSpace.getDataBase());
        this.selectObject(this.cbStorageTemplate, this.tableSpace.getStorageTemplate());
        this.cbLobLogging.setSelectedItem(this.tableSpace.isLobLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDSSize.setSelectedItem(this.tableSpace.getDsSize());
        this.cbSegSize.setSelectedItem(this.tableSpace.getSegSize());
        if (((TableSpaceDB2v80)this.tableSpace).getPartTable() != null) {
            this.cbPartTable.addItem(((TableSpaceDB2v80)this.tableSpace).getPartTable());
        }
        this.cbPartTable.setSelectedItem(((TableSpaceDB2v80)this.tableSpace).getPartTable());
        this.ifNumParts.setValue((long)this.tableSpace.getNumParts());
        this.selectObject(this.cbBufferPool, this.tableSpace.getBufferPool());
        this.cbLockSize.setSelectedItem(this.tableSpace.getLockSize());
        String lockMax = this.tableSpace.getLockMax() == -1 ? "SYSTEM" : String.valueOf(this.tableSpace.getLockMax());
        this.tfLockMax.setText(lockMax);
        this.cbClose.setSelectedItem(this.tableSpace.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbCompress.setSelectedItem(this.tableSpace.isCompress() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.tableSpace.getCcsid());
        this.cbLockPart.setSelectedItem(this.tableSpace.isLockPart() ? YES_NO[0] : YES_NO[1]);
        if (this.tableSpace.getMaxRows() != 0) {
            this.ifMaxRows.setValue((long)this.tableSpace.getMaxRows());
        } else {
            this.ifMaxRows.setText("");
        }
        this.ifOBID.setValue((long)this.tableSpace.getObid());
        this.ifPSID.setValue((long)this.tableSpace.getPsid());
        this.ifNactive.setValue((long)this.tableSpace.getNactive());
        this.tfCreatedBy.setText(this.tableSpace.getCreatedBy());
        this.ifSpace.setValue((long)this.tableSpace.getSpace());
        this.ifPageSave.setValue((long)this.tableSpace.getPageSave());
        this.ifMaintenanceInterval.setValue((long)this.tableSpace.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.tableSpace.getSpaceAllocationInterval());
        this.ifCompRatio.setValue((long)this.tableSpace.getCompressionRatio());
        this.ifPCTFragmentation.setValue((long)this.tableSpace.getFragmentationPCT());
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (user.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.tableSpace.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogDB2v80.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        this.tablesListModel.clear();
        Object[] tables = this.tableSpace.getTables().toArray();
        for (int i = 0; i < tables.length; ++i) {
            TableProxyDB2 table = (TableProxyDB2)tables[i];
            this.tablesListModel.addElement(table);
        }
        this.cbType.setEnabled(((TableSpaceDB2v80)this.tableSpace).getPartTable() == null);
        this.partitionsModel.clear();
        Iterator it = this.tableSpace.getTSPartitions().iterator();
        while (it.hasNext()) {
            try {
                PartitionDB2 part = (PartitionDB2)it.next();
                this.partitionsModel.addElement(part);
            }
            catch (ClassCastException classCastException) {}
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.cbType.setEnabled(((TableSpaceDB2v80)this.tableSpace).getPartTable() == null);
        this.initSpaceCalcs();
        this.enableMaxRows();
        this.enableLog();
        if (this.tableSpace.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbDB.setEnabled(false);
            this.cbStorageTemplate.setEnabled(false);
            this.cbLobLogging.setEnabled(false);
            this.cbDSSize.setEnabled(false);
            this.cbSegSize.setEnabled(false);
            this.cbPartTable.setEnabled(false);
            this.ifNumParts.setEditable(false);
            this.cbBufferPool.setEnabled(false);
            this.cbLockSize.setEnabled(false);
            this.tfLockMax.setEditable(false);
            this.cbClose.setEnabled(false);
            this.cbCompress.setEnabled(false);
            this.cbCCSID.setEnabled(false);
            this.cbLockPart.setEnabled(false);
            this.ifMaxRows.setEditable(false);
            this.ifOBID.setEditable(false);
            this.ifPSID.setEditable(false);
            this.ifNactive.setEditable(false);
            this.tfCreatedBy.setEditable(false);
            this.ifSpace.setEditable(false);
            this.ifPageSave.setEditable(false);
            this.ifMaintenanceInterval.setEditable(false);
            this.ifSpaceAllocInterval.setEditable(false);
            this.ifCompRatio.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            int lockMax;
            this.tableSpace.setName(this.tfName.getText());
            this.tableSpace.setType((String)this.cbType.getSelectedItem());
            this.tableSpace.setClustered(TableSpacePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            Object selected = this.cbDB.getSelectedItem();
            if (selected instanceof DataBaseDB2) {
                this.tableSpace.setDataBase((DataBaseDB2)selected);
            } else {
                this.tableSpace.setDataBase(null);
            }
            selected = this.cbStorageTemplate.getSelectedItem();
            if (selected instanceof StorageTemplateDB2) {
                this.tableSpace.setStorageTemplate((StorageTemplateDB2)selected);
            } else {
                this.tableSpace.setStorageTemplate(null);
            }
            selected = this.cbLobLogging.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLobLogging(result);
            this.tableSpace.setDsSize((String)this.cbDSSize.getSelectedItem());
            this.tableSpace.setSegSize((String)this.cbSegSize.getSelectedItem());
            if (((TableSpaceDB2v80)this.tableSpace).getPartTable() == null) {
                this.tableSpace.setNumParts(this.ifNumParts.getIntValue());
            }
            if ((selected = this.cbBufferPool.getSelectedItem()) instanceof BufferPoolDB2) {
                this.tableSpace.setBufferPool((BufferPoolDB2)selected);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setLockSize((String)this.cbLockSize.getSelectedItem());
            if ("SYSTEM".equalsIgnoreCase(this.tfLockMax.getText())) {
                lockMax = -1;
            } else {
                try {
                    lockMax = Integer.parseInt(this.tfLockMax.getText());
                }
                catch (NumberFormatException e) {
                    lockMax = 0;
                }
            }
            this.tableSpace.setLockMax(lockMax);
            selected = this.cbClose.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setClose(result);
            selected = this.cbCompress.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setCompress(result);
            this.tableSpace.setCcsid((String)this.cbCCSID.getSelectedItem());
            selected = this.cbLockPart.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLockPart(result);
            this.tableSpace.setMaxRows(this.ifMaxRows.getIntValue());
            this.tableSpace.setObid(this.ifOBID.getIntValue());
            this.tableSpace.setPsid(this.ifPSID.getIntValue());
            this.tableSpace.setNactive(this.ifNactive.getIntValue());
            this.tableSpace.setCreatedBy(this.tfCreatedBy.getText());
            this.tableSpace.setSpace(this.ifSpace.getIntValue());
            this.tableSpace.setPageSave(this.ifPageSave.getIntValue());
            this.tableSpace.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.tableSpace.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.tableSpace.setCompressionRatio(this.ifCompRatio.getIntValue());
            this.tableSpace.setFragmentationPCT(this.ifPCTFragmentation.getIntValue());
            Object[] userSet = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)ob).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            if (((String)this.cbType.getSelectedItem()).equalsIgnoreCase("PARTITIONED")) {
                int size = this.tableSpace.getTSPartitions().size();
                for (int i = 0; i < size; ++i) {
                    this.tableSpace.getTSPartitions().justRemove(this.tableSpace.getTSPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof PartitionDB2)) continue;
                    PartitionDB2 p = (PartitionDB2)this.partitionsModel.get(i);
                    p.addObjectListener(this.tableSpace);
                    p.setPartNumber(i + 1);
                    p.setParent(this.tableSpace.getTSPartitions());
                    this.tableSpace.getTSPartitions().add(p);
                }
            }
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.initSpaceCalcs();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionDB2 selected = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedValue();
            if (selected != null && !selected.isDialogVisible()) {
                IndexPartitionPropertyDialogDB2 dialog = new IndexPartitionPropertyDialogDB2(TableSpacePropertyDialogDB2v80.this.getAppView(), TableSpacePropertyDialogDB2v80.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < objectNumber.length; ++i) {
                if (objectNumber[i] == -1 || objectNumber[i] <= 0) continue;
                PartitionDB2 part = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i]);
                PartitionDB2 old = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i] - 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(part, objectNumber[i] - 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TableSpacePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = objectNumber.length - 1; i >= 0; --i) {
                if (objectNumber[i] == -1 || TableSpacePropertyDialogDB2v80.this.partitionsModel.size() - 1 <= objectNumber[i]) continue;
                PartitionDB2 part = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i]);
                PartitionDB2 old = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i] + 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(part, objectNumber[i] + 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TableSpacePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyDB2)TableSpacePropertyDialogDB2v80.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogDB2v80 dialog = new TablePropertyDialogDB2v80(TableSpacePropertyDialogDB2v80.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogDB2v80.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

