/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class PropertiesPropagationDialog
extends CustomDialogML {
    private JDialog dialog;
    private JPanel generalPanel;
    private JTable tbProps;
    private JTable tbObjects;
    private List propsList;
    private List objectsList;
    private PropertiesPropagator propagator;
    private JButton btnSelectAllProperties;
    private JButton btnDeselectAllProperties;
    private JSearchTextField propertiesfilter;
    private JButton btnSelectAllObjects;
    private JButton btnDeselectAllObjects;
    private JSearchTextField objectsfilter;
    private int dialogMinWidth = 450;
    private int dialogMinHeight = 550;

    public PropertiesPropagationDialog(ApplicationView appView, PropertiesPropagator propagator, List toObjects) {
        super(appView);
        this.propagator = propagator;
        this.generalPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0[grow]0[]0"));
        this.generalPanel.add((Component)this.getPropertiesPanel(), new CC().grow().wrap());
        this.generalPanel.add((Component)this.getObjectsPanel(), new CC().grow().wrap());
        this.generalPanel.add((Component)this.getButtonPanel(), new CC().spanX().alignX("right"));
        this.addObjects(toObjects);
        this.add((Component)this.generalPanel, new CC().grow());
    }

    private void addObjects(List toObjects) {
        for (ModelIDObject next : toObjects) {
            this.objectsList.add(new ObjectItem(next));
        }
        if (this.objectsList.size() > 0) {
            this.objectsfilter.setEnabled(true);
            this.btnSelectAllObjects.setEnabled(true);
            this.btnDeselectAllObjects.setEnabled(true);
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tbObjects.getModel());
            sorter.setSortsOnUpdates(true);
            this.tbObjects.setRowSorter(sorter);
            this.tbObjects.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tbObjects, 2);
        }
    }

    private JPanel getPropertiesPanel() {
        JPanel jpanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Properties")));
        this.propertiesfilter = new JSearchTextField(true, true, Messages.getString("PropertiesPropagationDialog.Name"));
        this.propertiesfilter.setToolTipText(Messages.getString("PropertiesPropagationDialog.FilteringColumn2"));
        this.propertiesfilter.setPreferredSize(new Dimension(200, 20));
        this.propertiesfilter.setMinimumSize(new Dimension(200, 20));
        this.propertiesfilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.btnSelectAllProperties = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllProperties.setToolTipText(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        this.btnSelectAllProperties.setEnabled(this.propagator.getPropertyWrapperList().size() > 0);
        this.btnSelectAllProperties.setMnemonic(83);
        this.btnSelectAllProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        this.btnDeselectAllProperties = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnDeselectAllProperties.setToolTipText(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        this.btnDeselectAllProperties.setEnabled(this.propagator.getPropertyWrapperList().size() > 0);
        this.btnDeselectAllProperties.setMnemonic(68);
        this.btnDeselectAllProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        toolBar.add(this.btnSelectAllProperties);
        toolBar.add(this.btnDeselectAllProperties);
        toolBar.addSeparator();
        toolBar.add(this.propertiesfilter);
        this.propsList = new ArrayList();
        this.propsList.addAll(this.propagator.getPropertyWrapperList());
        this.tbProps = new JTable(new PropertiesModel());
        this.tbProps.setSelectionMode(0);
        this.tbProps.setFont(this.tbProps.getFont().deriveFont(1));
        this.tbProps.setForeground(Color.BLUE);
        JScrollPane sp = new JScrollPane(this.tbProps);
        TableColumn col0 = this.tbProps.getColumnModel().getColumn(0);
        col0.setMinWidth(60);
        col0.setWidth(60);
        col0.setMaxWidth(60);
        TableColumn col1 = this.tbProps.getColumnModel().getColumn(1);
        col1.setWidth(200);
        TableColumn col2 = this.tbProps.getColumnModel().getColumn(2);
        col2.setWidth(200);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        popup.add(menuItem);
        this.tbProps.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        if (this.propagator.getPropertyWrapperList().size() > 0) {
            TableRowSorter<TableModel> threeCSorter = new TableRowSorter<TableModel>(this.tbProps.getModel());
            threeCSorter.setSortsOnUpdates(true);
            this.tbProps.setRowSorter(threeCSorter);
            this.tbProps.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tbProps, 1);
        }
        this.propertiesfilter.getDocument().addDocumentListener(new FilterObjectListener(this.propertiesfilter, this.tbProps, 1));
        jpanel.add((Component)toolBar, new CC().wrap());
        jpanel.add((Component)sp, new CC().grow());
        return jpanel;
    }

    private JPanel getObjectsPanel() {
        JPanel jpanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Objects")));
        this.objectsList = new ArrayList();
        this.objectsfilter = new JSearchTextField(true, true, Messages.getString("PropertiesPropagationDialog.Name"));
        this.objectsfilter.setEnabled(false);
        this.objectsfilter.setPreferredSize(new Dimension(200, 20));
        this.objectsfilter.setMinimumSize(new Dimension(200, 20));
        this.objectsfilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.btnSelectAllObjects = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllObjects.setToolTipText(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        this.btnSelectAllObjects.setEnabled(false);
        this.btnSelectAllObjects.setMnemonic(83);
        this.btnSelectAllObjects.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        this.btnDeselectAllObjects = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnDeselectAllObjects.setToolTipText(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        this.btnDeselectAllObjects.setEnabled(false);
        this.btnDeselectAllObjects.setMnemonic(68);
        this.btnDeselectAllObjects.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        toolBar.add(this.btnSelectAllObjects);
        toolBar.add(this.btnDeselectAllObjects);
        toolBar.addSeparator();
        toolBar.add(this.objectsfilter);
        this.tbObjects = new JTable(new ObjectModel());
        this.tbObjects.getTableHeader().setReorderingAllowed(false);
        this.tbObjects.setSelectionMode(0);
        this.tbObjects.setFont(this.tbObjects.getFont().deriveFont(1));
        JScrollPane sp = new JScrollPane(this.tbObjects);
        TableColumn col0 = this.tbObjects.getColumnModel().getColumn(0);
        col0.setMinWidth(60);
        col0.setWidth(60);
        col0.setMaxWidth(60);
        TableColumn col1 = this.tbObjects.getColumnModel().getColumn(1);
        col1.setWidth(100);
        TableColumn col2 = this.tbObjects.getColumnModel().getColumn(2);
        col2.setWidth(200);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        popup.add(menuItem);
        this.tbObjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.objectsfilter.getDocument().addDocumentListener(new FilterObjectListener(this.objectsfilter, this.tbObjects, 2));
        jpanel.add((Component)toolBar, new CC().grow().wrap());
        jpanel.add((Component)sp, new CC().grow());
        return jpanel;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("PropertiesPropagationDialog.PropertiesPropagation"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton ok = new JButton(Messages.getString("PropertiesPropagationDialog.OK"));
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesPropagationDialog.this.setProperties();
                PropertiesPropagationDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("PropertiesPropagationDialog.Cancel"));
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesPropagationDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    private void setProperties() {
        try {
            if (this.propagator instanceof StorageObject) {
                ((StorageObject)((Object)this.propagator)).getStorageDesign().setLoading(true);
            }
            for (PropertyWrapper pr : this.propsList) {
                if (!pr.isSelected()) continue;
                pr.init();
            }
            for (ObjectItem objItem : this.objectsList) {
                if (!objItem.isSelected()) continue;
                this.applyTo(objItem.getObject());
            }
        }
        finally {
            if (this.propagator instanceof StorageObject) {
                ((StorageObject)((Object)this.propagator)).getStorageDesign().setLoading(false);
            }
        }
    }

    private void applyTo(Object obj) {
        for (PropertyWrapper pr : this.propsList) {
            if (!pr.isSelected()) continue;
            pr.setValue(obj);
        }
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class ObjectItem {
        private ModelIDObject object;
        private boolean selected = false;

        public ObjectItem(ModelIDObject object) {
            this.object = object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getName() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }
    }

    public class PropertiesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.propsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            if (column == 2) {
                return Messages.getString("PropertiesPropagationDialog.Value");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropertyWrapper pw = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(row);
            if (col == 0) {
                return pw.isSelected();
            }
            if (col == 1) {
                return pw.getName();
            }
            if (col == 2) {
                return pw.getValueString();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            PropertyWrapper pw = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(row);
            if (col == 0) {
                pw.setSelected((Boolean)aValue);
            }
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JSearchTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JSearchTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PropertiesPropagationDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PropertiesPropagationDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PropertiesPropagationDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.objectsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("PropertiesPropagationDialog.Schema");
            }
            if (column == 2) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ObjectItem objItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(row);
            if (col == 0) {
                return objItem.isSelected();
            }
            if (col == 1) {
                StorageObject so = (StorageObject)objItem.getObject();
                return so.getSchemaObject() != null ? so.getSchemaObject().getName() : "";
            }
            if (col == 2) {
                return objItem.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            ObjectItem objItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(row);
            if (col == 0) {
                objItem.setSelected((Boolean)aValue);
            }
        }
    }
}

