/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class PhonePropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfNumber;
    private JTextField tfType;
    private BIPhone phone;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public PhonePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public PhonePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbNumber = new JLabel(LB_PHONE_NUMBER);
        lbNumber.setPreferredSize(this.getDefaultSize());
        this.tfNumber = new JTextField();
        this.tfNumber.setPreferredSize(this.getDefaultSize());
        this.tfNumber.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbNumber, this.tfNumber));
        JLabel lbType = new JLabel(LB_PHONE_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbType, this.tfType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("PhonePropertiesDialogEx.TelephoneProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIPhone) {
            this.phone = (BIPhone)object;
            this.tfName.setText(this.phone.getName());
            this.tfNumber.setText(this.phone.getPhoneNumber());
            this.tfType.setText(this.phone.getPhoneType());
            this.cList.addAll(this.phone.getContacts());
            this.taComments.setText(this.phone.getComment());
            this.tfObjectID.setText(this.phone.getObjectID());
            this.tfCreationTime.setText(this.phone.getCreationTime());
            this.tfCreator.setText(this.phone.getCreator().getName());
            this.tfDesign.setText(this.phone.getOwnerDesignName());
            if (this.phone.getGenerator() != null) {
                this.tfGeneratorName.setText(this.phone.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.phone.getChanger().getName());
            this.tfLastChangedTime.setText(this.phone.getChangeTime());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.phone.setName(this.tfName.getText());
        this.phone.setComment(this.taComments.getText());
        this.phone.setPhoneNumber(this.tfNumber.getText());
        this.phone.setPhoneType(this.tfType.getText());
        PhonePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.phone.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.phone.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getContactsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TELEPHONE_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("PhonePropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = PhonePropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && PhonePropertiesDialogEx.this.cList.size() > 0 && row < PhonePropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)PhonePropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("PhonePropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = PhonePropertiesDialogEx.this.cTable.getSelectedRow();
                    if (row != -1 && PhonePropertiesDialogEx.this.cList.size() > 0 && row < PhonePropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)PhonePropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnContacts.add(pPanel);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return PhonePropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PhonePropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)PhonePropertiesDialogEx.this.cList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

