/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class DocumentPropertiesDialogEx
extends AbstractPropertiesDialog {
    private BIDocument document;
    private JTextField tfReference;
    private JTextField tfType;
    private JComboBox cbParent;
    private List elmList;
    private JTable elmTable;
    private JPanel pnElements;
    private JTable refTable = null;

    public DocumentPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public DocumentPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, JTable refTable) {
        super(owner, view, object);
        this.refTable = refTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbRef = new JLabel(LB_REFERENCE);
        lbRef.setPreferredSize(this.getDefaultSize());
        this.tfReference = new JTextField();
        this.tfReference.setPreferredSize(this.getDefaultSize());
        this.tfReference.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbRef, this.tfReference));
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbType, this.tfType));
        JLabel lbParent = new JLabel(LB_PARENT_DOCUMENT);
        lbParent.setPreferredSize(this.getDefaultSize());
        this.cbParent = new JComboBox();
        this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
        this.cbParent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbParent, this.cbParent));
    }

    @Override
    public String getCaption() {
        return Messages.getString("DocumentPropertiesDialogEx.DocumentProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIDocument) {
            this.document = (BIDocument)object;
            this.tfName.setText(this.document.getName());
            this.taComments.setText(this.document.getComment());
            this.tfObjectID.setText(this.document.getObjectID());
            this.tfCreationTime.setText(this.document.getCreationTime());
            this.tfCreator.setText(this.document.getCreator().getName());
            this.tfDesign.setText(this.document.getOwnerDesignName());
            if (this.document.getGenerator() != null) {
                this.tfGeneratorName.setText(this.document.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.document.getChanger().getName());
            this.tfLastChangedTime.setText(this.document.getChangeTime());
            this.elmList.addAll(this.document.getElements());
            this.tfReference.setText(this.document.getReference());
            this.tfType.setText(this.document.getType());
            ArrayList<BIDocument> candidates = new ArrayList<BIDocument>();
            Iterator iter = this.document.getDesign().getBusinessInfoDesign().getDocumentSet().iterator();
            while (iter.hasNext()) {
                BIDocument doc = (BIDocument)iter.next();
                if (doc == this.document || this.hasThisDocumentAsAncestor(doc)) continue;
                candidates.add(doc);
            }
            this.fillComboItems(candidates.toArray(), this.cbParent, true);
            this.cbParent.setSelectedItem(this.document.getParentDocument());
            this.initDynamicProperties();
        }
    }

    private boolean hasThisDocumentAsAncestor(BIDocument doc) {
        BIDocument par = doc.getParentDocument();
        if (par == null) {
            return false;
        }
        if (par == this.document) {
            return true;
        }
        return this.hasThisDocumentAsAncestor(par);
    }

    @Override
    protected void setProperties() {
        this.document.setName(this.tfName.getText());
        this.document.setComment(this.taComments.getText());
        this.document.setReference(this.tfReference.getText());
        this.document.setType(this.tfType.getText());
        this.document.setParentDocument((BIDocument)this.cbParent.getSelectedItem());
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
        DocumentPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.document.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.document.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getElementsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DOCUMENT_PROPERTIES_DIALOG";
    }

    private JPanel getElementsPanel() {
        if (this.pnElements == null) {
            this.pnElements = this.createPage(Messages.getString("DocumentPropertiesDialogEx.Elements"));
            this.elmList = new ArrayList();
            this.elmTable = new JTable(new ElementTableModel());
            this.elmTable.setSelectionMode(0);
            this.elmTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = DocumentPropertiesDialogEx.this.elmTable.getSelectedRow()) != -1 && DocumentPropertiesDialogEx.this.elmList.size() > 0 && row < DocumentPropertiesDialogEx.this.elmList.size()) {
                        DesignObject object = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.elmTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("DocumentPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DocumentPropertiesDialogEx.this.elmTable.getSelectedRow();
                    if (row != -1 && DocumentPropertiesDialogEx.this.elmList.size() > 0 && row < DocumentPropertiesDialogEx.this.elmList.size()) {
                        DesignObject object = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnElements.add(pPanel);
        }
        return this.pnElements;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DocumentPropertiesDialogEx.this.elmList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DocumentPropertiesDialogEx.Elements");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)DocumentPropertiesDialogEx.this.elmList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

