/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.panels.ProvidesSearchTags;
import oracle.ide.panels.SavedTreeState;
import oracle.javatools.ui.search.SearchMatcher;

public final class SearchableTreeHelper {
    private SearchableTreeHelper() {
    }

    public static TreeModel applyTreeFilter(JTree tree, TreeModel _savedModel, DefaultMutableTreeNode root, String filterText) {
        if ((filterText == null || filterText.length() == 0) && _savedModel != null) {
            SavedTreeState state = new SavedTreeState(tree);
            tree.setModel(_savedModel);
            state.restore(tree);
            return _savedModel;
        }
        SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)filterText, (boolean)true, (boolean)false);
        DefaultMutableTreeNode rootNode = SearchableTreeHelper.cloneTree(root);
        SearchableTreeHelper.filter(rootNode, matcher);
        TreeModel tm = _savedModel == null ? tree.getModel() : _savedModel;
        tree.setModel(new DefaultTreeModel(rootNode));
        SearchableTreeHelper.expandAll(tree, true);
        SearchableTreeHelper.selectMatchingRow(tree, matcher, filterText);
        return tm;
    }

    private static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        SearchableTreeHelper.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                SearchableTreeHelper.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private static DefaultMutableTreeNode cloneTree(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
        newRoot.setUserObject(root.getUserObject());
        SearchableTreeHelper.cloneTreeChildren(root, newRoot);
        return newRoot;
    }

    private static void cloneTreeChildren(DefaultMutableTreeNode original, DefaultMutableTreeNode copy) {
        for (int i = 0; i < original.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)original.getChildAt(i);
            DefaultMutableTreeNode childCopy = new DefaultMutableTreeNode();
            childCopy.setUserObject(child.getUserObject());
            copy.add(childCopy);
            SearchableTreeHelper.cloneTreeChildren(child, childCopy);
        }
    }

    private static boolean filter(DefaultMutableTreeNode root, SearchMatcher matcher) {
        boolean matchingChildren = false;
        ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (SearchableTreeHelper.filter(child, matcher)) {
                matchingChildren = true;
                continue;
            }
            nodesToRemove.add(i);
        }
        int removedCount = 0;
        Iterator iterator = nodesToRemove.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            root.remove(i - removedCount++);
        }
        if (matchingChildren) {
            return true;
        }
        if (!(root.getUserObject() instanceof ProvidesSearchTags)) {
            return false;
        }
        return SearchableTreeHelper.matchesSearch(matcher, (ProvidesSearchTags)root.getUserObject());
    }

    private static boolean matchesSearch(SearchMatcher matcher, ProvidesSearchTags navigable) {
        boolean result = false;
        if (navigable != null) {
            for (String tag : navigable.searchTags()) {
                if (!matcher.matches((CharSequence)tag)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static void selectMatchingRow(JTree tree, SearchMatcher matcher, String filterText) {
        int selectRowIndex = -1;
        boolean foundPatternMatch = false;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
            String text = String.valueOf(last);
            if (text.toLowerCase().equals(filterText)) {
                selectRowIndex = i;
                break;
            }
            if (matcher.matches((CharSequence)text)) {
                if (foundPatternMatch) continue;
                selectRowIndex = i;
                foundPatternMatch = true;
                continue;
            }
            if (foundPatternMatch || selectRowIndex != -1 || !(last.getUserObject() instanceof ProvidesSearchTags)) continue;
            ProvidesSearchTags pstags = (ProvidesSearchTags)last.getUserObject();
            for (String tag : pstags.searchTags()) {
                if (!matcher.matches((CharSequence)tag)) continue;
                selectRowIndex = i;
            }
        }
        if (selectRowIndex != -1) {
            tree.setSelectionRow(selectRowIndex);
            return;
        }
        if (tree.getRowCount() > 0) {
            tree.setSelectionRow(0);
        }
    }
}

