/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.util.GUID;

public class DDLTransformationScriptSet
implements Cloneable {
    private String name;
    private String description;
    private boolean active;
    private List<DRCustomScript> scripts;
    private String setId;

    public DDLTransformationScriptSet(String setId, String name, String description, boolean active) {
        this.setId = setId == null || setId.trim().equals("") ? new GUID().toString() : setId;
        this.name = name;
        this.description = description;
        this.active = active;
        this.initDefaultScripts();
    }

    private DDLTransformationScriptSet(String setId, String name, String description, boolean active, List scripts) {
        this.setId = setId;
        this.name = name;
        this.description = description;
        this.active = active;
        this.scripts = scripts;
    }

    public String getSetId() {
        return this.setId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<DRCustomScript> getScripts() {
        if (this.scripts == null) {
            this.scripts = new ArrayList<DRCustomScript>();
        }
        return this.scripts;
    }

    private void initDefaultScripts() {
        DRCustomScript scrBeforeCreate = new DRCustomScript("Before Create", null, "ddl_transformation");
        DRCustomScript scrAfterCreate = new DRCustomScript("After Create", null, "ddl_transformation");
        DRCustomScript scrEndOfScript = new DRCustomScript("End Of Script", null, "ddl_transformation");
        DRCustomScript scrInsteadOfCreate = new DRCustomScript("Instead Of Create", null, "ddl_transformation");
        scrBeforeCreate.setVariable("model");
        scrAfterCreate.setVariable("model");
        scrEndOfScript.setVariable("model");
        scrInsteadOfCreate.setVariable("model");
        scrBeforeCreate.setEngineName("Oracle Nashorn");
        scrAfterCreate.setEngineName("Oracle Nashorn");
        scrEndOfScript.setEngineName("Oracle Nashorn");
        scrInsteadOfCreate.setEngineName("Oracle Nashorn");
        this.getScripts().add(scrBeforeCreate);
        this.getScripts().add(scrInsteadOfCreate);
        this.getScripts().add(scrAfterCreate);
        this.getScripts().add(scrEndOfScript);
    }

    public DDLTransformationScriptSet copy() {
        return new DDLTransformationScriptSet(this.setId, this.name, this.description, this.active, this.scripts);
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() throws CloneNotSupportedException {
        DDLTransformationScriptSet s = (DDLTransformationScriptSet)super.clone();
        s.setName(this.name);
        s.setDescription(this.description);
        s.setActive(this.active);
        ArrayList<DRCustomScript> lScripts = new ArrayList<DRCustomScript>();
        for (DRCustomScript script : this.getScripts()) {
            lScripts.add((DRCustomScript)script.clone());
        }
        s.scripts = lScripts;
        return s;
    }
}

