/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareModelsController;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;

public class ModelChooserDialog
extends JDialog
implements AbstractEditorConstants {
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private static final Logger LOGGER = new Logger(ModelChooserDialog.class);
    private static final String EMPTY_STRING = "";
    private CompareModelsController controller;
    private Object[] relationals;
    private Object importFile;
    private ApplicationView view;
    private JPanel generalPanel;
    private JComboBox cbTargetModel;
    private JComboBox cbSourceModel;
    private JComboBox cbSourceDBType;
    private String targetModelName = "";
    public static boolean isSelectedDatabase = true;
    private Design targetDesign;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelChooserDialog.this.dispose();
            ModelChooserDialog.this.getController().removeTempDesign();
        }
    };
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelChooserDialog.this.showHelp();
        }
    };
    URLFileChooser.URLFileChooserPanel pan;
    private static final int FIELD_WIDTH = 250;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(330, 20);

    public ModelChooserDialog(ApplicationView view, File importFile) {
        super(view.getFrame());
        this.view = view;
        this.targetModelName = view.getDesignName();
        this.importFile = importFile;
        this.targetDesign = view.getCurrentDesign();
        this.relationals = this.targetDesign.getRelationalDesigns().toArray();
        this.getController().initTempDesign();
        this.setTitle(Messages.getString("ModelChooserDialog.RelationalModelsDialog"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.initMainPanel(), "Center");
        this.getContentPane().add(this.initBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    protected String getHelpIndex() {
        return "COMPARE_RELATIONAL_MODELS";
    }

    private Component initBottomPanel() {
        JPanel jpanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("ModelChooserDialog.OK"));
        bnOK.setMnemonic(79);
        bnOK.addActionListener(new OKAction());
        JButton bnCancel = new JButton(Messages.getString("ModelChooserDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(Messages.getString("ModelChooserDialog.Help"));
        bnHelp.setMnemonic(72);
        bnHelp.addActionListener(new HelpAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add(bnOK);
        jpanel.add(bnCancel);
        jpanel.add(bnHelp);
        return jpanel;
    }

    private Component initMainPanel() {
        this.generalPanel = new JPanel(new GridLayout(5, 0));
        this.generalPanel.setPreferredSize(new Dimension(480, 300));
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(EMPTY_STRING);
        choices.addAll(this.getApplicationView().getCurrentDesign().getRDBMSSiteSet().getValueSet());
        this.pan = URLFileChooser.createURLFileChooserPanel((int)0, (String)EMPTY_STRING, (boolean)true, (boolean)false);
        JLabel lbfFileName2 = new JLabel(Messages.getString("ModelChooserDialog.DesignToCompare"));
        lbfFileName2.setPreferredSize(this.prefDimension);
        this.pan.setPreferredSize(this.prefDimension);
        this.pan.setEnabled(true);
        this.pan.setCheckIfFileExists(false);
        this.pan.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return ApplicationView.DESIGN_URL_FILTER_DESC;
            }
        });
        JPanel fcpanel = new JPanel();
        fcpanel.setLayout(new SpringLayout());
        fcpanel.add(lbfFileName2);
        fcpanel.add((Component)this.pan);
        this.setLabelConstraints(fcpanel, lbfFileName2, 20);
        this.setObjectConstraints(fcpanel, (Component)this.pan, 20);
        this.pan.setPathContext("dataModeler_OpenDesign");
        this.pan.setSelectionScope(0);
        int count = 0;
        Iterator it = this.getApplicationView().getSettings().getRecentDesigns().iterator();
        while (count < 4 && it.hasNext()) {
            ControllerApplication.Recent r = (ControllerApplication.Recent)it.next();
            File file = new File(r.getDesignPath(), r.getDesignName() + ".dmd");
            if (!file.exists()) continue;
            this.pan.setSelectedURL(URLFactory.newFileURL((File)file));
            ++count;
        }
        this.pan.setSelectedURL(null);
        this.pan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                if (URLFileChooser.URL_SELECTED == e.getActionCommand() && (file = ModelChooserDialog.this.pan.getSelectedFile()) != null && !file.isDirectory() && file.exists()) {
                    ModelChooserDialog.this.importFile = file;
                    try {
                        ModelChooserDialog.this.loadTempDesign();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    ModelChooserDialog.this.cbSourceModel.setModel(new DefaultComboBoxModel<Object>(ModelChooserDialog.this.getTempRelationDesigns().toArray()));
                }
            }
        });
        JPanel jpFrom = new JPanel();
        jpFrom.setLayout(new SpringLayout());
        jpFrom.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("ModelChooserDialog.From"), this.getSourceModelName())));
        jpFrom.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelChooserDialog.SourceModel")));
        JLabel sourceLabel = new JLabel(Messages.getString("ModelChooserDialog.RelationalModel"));
        jpFrom.add(sourceLabel);
        this.setLabelConstraints(jpFrom, sourceLabel, 20);
        this.cbSourceModel = new JComboBox<Object>(this.getTempRelationDesigns().toArray());
        this.cbSourceModel.setPreferredSize(new Dimension(280, 20));
        this.cbSourceModel.setBackground(Color.WHITE);
        jpFrom.add(this.cbSourceModel);
        this.setObjectConstraints(jpFrom, this.cbSourceModel, 20);
        JPanel jpDBTypes = new JPanel();
        jpDBTypes.setLayout(new SpringLayout());
        jpDBTypes.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelChooserDialog.DatabaseTypes")));
        JLabel databaseLabel = new JLabel(Messages.getString("ModelChooserDialog.DatabaseType"));
        jpDBTypes.add(databaseLabel);
        this.setLabelConstraints(jpDBTypes, databaseLabel, 20);
        this.cbSourceDBType = new JComboBox<Object>(choices.toArray());
        this.cbSourceDBType.setPreferredSize(this.cbSourceModel.getPreferredSize());
        this.cbSourceDBType.setBackground(Color.WHITE);
        this.cbSourceDBType.setMaximumRowCount(choices.size() + 1);
        jpDBTypes.add(this.cbSourceDBType);
        this.setObjectConstraints(jpDBTypes, this.cbSourceDBType, 20);
        JPanel jpTo = new JPanel();
        jpTo.setLayout(new SpringLayout());
        jpTo.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("ModelChooserDialog.To"), this.getTargetModelName())));
        JLabel targetLabel = new JLabel(Messages.getString("ModelChooserDialog.ToLabel"));
        jpTo.add(targetLabel);
        this.setLabelConstraints(jpTo, targetLabel, 20);
        this.cbTargetModel = new JComboBox<Object>(this.relationals);
        this.cbTargetModel.setPreferredSize(this.cbSourceModel.getPreferredSize());
        this.cbTargetModel.setBackground(Color.WHITE);
        jpTo.add(this.cbTargetModel);
        this.setObjectConstraints(jpTo, this.cbTargetModel, 20);
        JPanel jpMapping = new JPanel();
        jpMapping.setLayout(new SpringLayout());
        jpMapping.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelChooserDialog.CompareMapping")));
        JButton bnMapping = new JButton(Messages.getString("ModelChooserDialog.ViewCompareMapping"));
        bnMapping.setPreferredSize(new Dimension(240, 20));
        jpMapping.add(bnMapping);
        this.setObjectConstraints(jpMapping, bnMapping, 60, 10);
        bnMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareMappingDialog dialog = new CompareMappingDialog(ModelChooserDialog.this.getApplicationView(), ModelChooserDialog.this.targetDesign);
                dialog.show();
            }
        });
        this.generalPanel.add(fcpanel);
        this.generalPanel.add(jpFrom);
        this.generalPanel.add(jpTo);
        this.generalPanel.add(jpDBTypes);
        this.generalPanel.add(jpMapping);
        return this.generalPanel;
    }

    private String getTargetModelName() {
        return this.targetModelName;
    }

    private String getSourceModelName() {
        return this.getController().getApplicationView().getDesignName();
    }

    private void setObjectConstraints(JPanel panel, Component c, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(c);
        labelCons.setX(Spring.constant(150));
        labelCons.setY(Spring.constant(y));
    }

    private void setObjectConstraints(JPanel panel, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setLabelConstraints(JPanel panel, JLabel label, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    private List getTempRelationDesigns() {
        return this.getController().getDPObject();
    }

    private void loadTempDesign() {
        try {
            this.getController().loadTempDesign((File)this.getImportFile());
        }
        catch (Exception e) {
            LOGGER.error(e);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ModelChooserDialog.UnableGenerateDesign"), Messages.getString("ModelChooserDialog.ErrorGenerateDesign"), 0);
            this.doClose();
        }
    }

    private void doClose() {
        this.dispose();
        this.getController().removeTempDesign();
    }

    public CompareModelsController getController() {
        if (this.controller == null) {
            this.controller = new CompareModelsController(this.view);
        }
        return this.controller;
    }

    public Object getImportFile() {
        return this.importFile;
    }

    public void setImportFile(Object importFile) {
        this.importFile = importFile;
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public void setApplicationView(ApplicationView view) {
        this.view = view;
    }

    private boolean disableDDLPreview() {
        RelationalDesign targetPhysical = (RelationalDesign)this.cbTargetModel.getSelectedItem();
        return this.cbSourceDBType.getSelectedItem().equals(EMPTY_STRING) && !(targetPhysical.getStorageDesign() instanceof StorageDesignOracle);
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelChooserDialog.this.dispose();
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ModelChooserDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ProgressDialog monitor = new ProgressDialog(ModelChooserDialog.this.getApplicationView(), ModelChooserDialog.EMPTY_STRING, 0, 100);
                    monitor.setParentComponent(ModelChooserDialog.this.getContentPane());
                    try {
                        ApplicationView.loading = true;
                        ApplicationView.canLogging = false;
                        RelationalDesign sourcePhysical = (RelationalDesign)ModelChooserDialog.this.cbSourceModel.getSelectedItem();
                        monitor.setNote(Messages.getString("ModelChooserDialog.Loading"));
                        monitor.setProgress(10);
                        if (sourcePhysical.getDesign().isOldRepositoryType()) {
                            sourcePhysical.getDesign().getDataTypesDesign().load();
                        } else {
                            ModelChooserDialog.this.getApplicationView().getXMLTransformationManager().openDesignPart(sourcePhysical.getDesign().getDataTypesDesign());
                        }
                        ModelChooserDialog.this.getController().loadRelationalDesign(sourcePhysical);
                        monitor.setProgress(40);
                        RelationalDesign targetPhysical = (RelationalDesign)ModelChooserDialog.this.cbTargetModel.getSelectedItem();
                        isSelectedDatabase = !ModelChooserDialog.this.cbSourceDBType.getSelectedItem().equals(ModelChooserDialog.EMPTY_STRING);
                        if (ModelChooserDialog.this.cbSourceDBType.getSelectedItem() instanceof RDBMSSite) {
                            sourcePhysical.setSelectedRDBMSSite((RDBMSSite)ModelChooserDialog.this.cbSourceDBType.getSelectedItem());
                            targetPhysical.setSelectedRDBMSSite((RDBMSSite)ModelChooserDialog.this.cbSourceDBType.getSelectedItem());
                        } else {
                            sourcePhysical.setSelectedRDBMSSite(targetPhysical.getSelectedRDBMSSite());
                        }
                        boolean noDDLPreview = ModelChooserDialog.this.disableDDLPreview();
                        monitor.setProgress(50);
                        if (isSelectedDatabase) {
                            StorageDesign sourceStorageDesign = sourcePhysical.getStorageDesign(sourcePhysical.getSelectedRDBMSSite());
                            if (sourcePhysical.getDesign().isOldRepositoryType()) {
                                sourceStorageDesign.load();
                            } else {
                                ModelChooserDialog.this.getApplicationView().getXMLTransformationManager().openPhysicalModel(sourceStorageDesign);
                            }
                            ApplicationView.loading = false;
                            monitor.setProgress(60);
                            sourceStorageDesign.setOpen(true);
                            ModelChooserDialog.this.getController().removeTempDesign();
                            monitor.setProgress(70);
                            StorageDesign targetStorageDesign = targetPhysical.getStorageDesign(targetPhysical.getSelectedRDBMSSite());
                            targetStorageDesign.openStorageDesign();
                            targetStorageDesign.setTempModel(false);
                            ModelChooserDialog.this.getApplicationView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(targetStorageDesign);
                            monitor.setProgress(80);
                            ApplicationView.loading = true;
                        } else {
                            ModelChooserDialog.this.getController().removeTempDesign();
                            monitor.setProgress(80);
                        }
                        try {
                            monitor.setProgress(90);
                            CompareModelsDialog cmDial = new CompareModelsDialog(ModelChooserDialog.this.getApplicationView(), sourcePhysical, targetPhysical, noDDLPreview);
                            monitor.setProgress(100);
                            monitor.close();
                            ModelChooserDialog.this.view.setMerging(false);
                            cmDial.show();
                        }
                        catch (Exception error) {
                            monitor.close();
                            LOGGER.error("Error in Compare status", error);
                        }
                        finally {
                            ModelChooserDialog.this.view.setMerging(false);
                            FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
                        }
                    }
                    catch (Exception error) {
                        monitor.close();
                        LOGGER.error("Error in Compare status", error);
                    }
                    finally {
                        ApplicationView.loading = false;
                        ApplicationView.canLogging = true;
                        ModelChooserDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            thread.start();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelChooserDialog.this.dispose();
            ModelChooserDialog.this.getController().removeTempDesign();
        }
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelChooserDialog.this.showHelp();
        }
    }
}

