/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class VisibleTablesCollectionv2k5
extends StorageObjectCollection
implements RelationalObjectProxySetListener,
StorageObjectListener,
ObjectListener {
    StorageDesignSqlServerv2k5 storageDesign = null;

    public VisibleTablesCollectionv2k5(StorageDesignSqlServerv2k5 design) {
        this.storageDesign = design;
        this.registerToTableProxyFromDesign(design.getTableProxySet());
        design.getTableProxySet().addSetListener(this);
        this.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
    }

    public StorageObject[] getElements() {
        Object[] arr = this.getElementsList().toArray();
        StorageObject[] stoArray = new StorageObject[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            stoArray[i] = (StorageObject)arr[i];
        }
        return stoArray;
    }

    private void registerToTableProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableProxySqlServer tp = (TableProxySqlServer)it.next();
            tp.addObjectListener(this);
            Table table = (Table)tp.getObject();
            table.addObjectListener(this);
            if (table.getTypeSubstitution() != null) continue;
            tp.setParent(this);
            this.add(tp);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        TableProxySqlServer tp;
        Table table;
        if (event.isType(1)) {
            TableProxySqlServer tp2;
            Table table2;
            if (event.getAffected() instanceof TableProxy && (table2 = (Table)(tp2 = (TableProxySqlServer)event.getAffected()).getObject()).getTypeSubstitution() == null) {
                tp2.addObjectListener(this);
                tp2.setParent(this);
                this.add(tp2);
            }
        } else if (event.isType(0) && event.getAffected() instanceof TableProxy && (table = (Table)(tp = (TableProxySqlServer)event.getAffected()).getObject()).getTypeSubstitution() == null) {
            tp.removeObjectListener(this);
            this.remove(tp);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        TableProxySqlServer tp;
        Table table;
        if (event.getAffected() instanceof TableProxy && (table = (Table)(tp = (TableProxySqlServer)event.getAffected()).getObject()).getTypeSubstitution() == null) {
            tp.setParent(this);
            this.add(tp);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.ROOT_CHANGED) && object instanceof Table && this.storageDesign.getProxy(object) != null) {
            TableProxySqlServer tp = (TableProxySqlServer)this.storageDesign.getProxy(object);
            if (((Table)object).getTypeSubstitution() == null) {
                tp.addObjectListener(this);
                tp.setParent(this);
                this.add(tp);
            } else {
                tp.removeObjectListener(this);
                this.remove(tp);
            }
        }
    }
}

