/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderSet;
import oracle.dbtools.crest.model.design.multidimensional.MeasureSet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SliceSet;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.placeholder.MeasurePlaceHolder;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasureFolderPropertiesDialogEx;

public class MeasureFolder
extends AbstractMDObject
implements SetListener {
    public static final String MEASURE_ID = "measure_id";
    private static String OWNER_ID = "owner_id";
    private static String IS_MEASURE_WRAPPER = "isMW";
    public static final String AGGR_FUNCTION_ID = "aggrFunctionID";
    private static String TRUE = "true";
    private MeasureFolder parentFolder = null;
    private List measures = new ArrayList();
    private List availableMeasures = new ArrayList();
    private List subfolders = new ArrayList();
    private DesignObjectCollection folders = new DesignObjectCollection();
    private DesignObjectCollection usedMeasures;
    private String parentFolderID;
    public static final String TYPE_NAME = "MeasureFolder";

    public MeasureFolder(DesignPart designPart) {
        super(designPart);
        this.folders.setName(Messages.getString("MeasureFolder.Subfolders"));
        this.folders.setParent(this);
        this.folders.setDesign(designPart.getDesign());
        this.usedMeasures = new DesignObjectCollection();
        this.usedMeasures.setName(Messages.getString("MeasureFolder.Measures"));
        this.usedMeasures.setParent(this);
        this.usedMeasures.setDesign(designPart.getDesign());
        this.usedMeasures.setElementDescriptor(Measure.class);
        ((MultidimensionalDesign)designPart).getMeasureFolderSet().addSetListener(this);
        ((MultidimensionalDesign)designPart).getMeasureSet().addSetListener(this);
        ((MultidimensionalDesign)designPart).getSliceSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public List getMeasures() {
        return this.measures;
    }

    public void setMeasures(List measures) {
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            this.addMeasure((MFElement)it.next());
        }
    }

    public MeasureFolder getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(MeasureFolder parentFolder) {
        if (this.parentFolder != parentFolder) {
            this.parentFolder = parentFolder;
            this.fireChange(ObjectChangeEvent.PARENTFOLDER_CHANGED);
        }
    }

    public List getSubfolders() {
        return this.subfolders;
    }

    public void setSubfolders(List subfolders) {
        this.subfolders = subfolders;
    }

    public void addSubfolders(MeasureFolder subfolders) {
        if (!this.folders.contains(subfolders)) {
            subfolders.setParentFolder(this);
            subfolders.setParent(this.folders);
            this.folders.add(subfolders);
        }
    }

    public void addMeasure(MFElement object) {
        if (!this.measures.contains(object)) {
            this.measures.add(object);
            MeasurePlaceHolder mp = new MeasurePlaceHolder(this.getDesignPart());
            mp.setObject(object);
            mp.setParent(this.usedMeasures);
            this.usedMeasures.add(mp);
        }
    }

    public void removeFromMeasures(MFElement object) {
        int index = this.measures.indexOf(object);
        if (index > -1) {
            this.usedMeasures.remove(this.usedMeasures.getElement(index));
            this.measures.remove(object);
        }
    }

    public void removeMeasures() {
        this.measures.clear();
        this.usedMeasures.removeAll();
    }

    public List getOnlyMeasures() {
        if (this.measures.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<MFElement> measureList = new ArrayList<MFElement>();
        for (MFElement mfelement : this.measures) {
            if (mfelement.isMeasureWrapper) continue;
            measureList.add(mfelement);
        }
        return measureList;
    }

    public List getOnlyMeasureWrapper() {
        if (this.measures.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MFElement> measureList = new ArrayList<MFElement>();
        for (MFElement mfelement : this.measures) {
            if (!mfelement.isMeasureWrapper) continue;
            measureList.add(mfelement);
        }
        return measureList;
    }

    public List getMeasureWrapperMaps() {
        if (this.measures.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList measureList = new ArrayList();
        for (MFElement mfelement : this.measures) {
            if (mfelement.parent == null) continue;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put(OWNER_ID, mfelement.parent.getObjectID());
            if (mfelement.isMeasureWrapper) {
                map.put(IS_MEASURE_WRAPPER, TRUE);
                Slice.MeasureWrapper mw = (Slice.MeasureWrapper)mfelement.measure;
                map.put(MEASURE_ID, mw.getMeasure().getObjectID());
                map.put(AGGR_FUNCTION_ID, mw.getAggrFuncId());
            } else {
                map.put(MEASURE_ID, ((DesignObject)mfelement.measure).getObjectID());
            }
            measureList.add(map);
        }
        return measureList;
    }

    public void applyMeasureWrapperMaps(List maps) {
        this.measures.clear();
        this.usedMeasures.removeAll();
        for (Object obj : maps) {
            String mid;
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            String pid = (String)map.get(OWNER_ID);
            DesignObject owner = null;
            if (pid != null) {
                owner = this.getDesign().getDesignObject(pid);
            }
            if (owner == null) continue;
            String ismw = (String)map.get(IS_MEASURE_WRAPPER);
            boolean isMW = false;
            if (ismw != null && TRUE.equals(ismw)) {
                isMW = true;
            }
            if ((mid = (String)map.get(MEASURE_ID)) == null) continue;
            ID_ObjectPropertyTranslator measure = null;
            if (isMW) {
                String fid = (String)map.get(AGGR_FUNCTION_ID);
                if (owner instanceof Slice) {
                    measure = ((Slice)owner).getMeasureWrapper(mid, fid);
                }
            } else {
                measure = this.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID(mid);
            }
            if (measure == null) continue;
            MFElement me = new MFElement(owner, measure);
            this.addMeasure(me);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MeasureFolderPropertiesDialogEx dialog = new MeasureFolderPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.usedMeasures;
            }
            case 1: {
                return this.folders;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.usedMeasures) {
            return 0;
        }
        if (child == this.folders) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.usedMeasures) {
            return 0;
        }
        if (child == this.folders) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof MeasureFolderSet && event.isAdded()) {
            MeasureFolder mf = (MeasureFolder)event.getAffected();
            if (mf.parentFolder == this) {
                mf.setParent(this.folders);
                this.folders.add(mf);
            }
        } else if (event == SetEvent.OBJECT_REMOVED) {
            if (set instanceof MeasureFolderSet) {
                MeasureFolder mf = (MeasureFolder)event.getAffected();
                this.folders.remove(mf);
            }
            if (set instanceof MeasureSet) {
                Measure measure = (Measure)event.getAffected();
                this.removeMeasureFromMeasureFolder(measure);
            }
            if (set instanceof SliceSet) {
                Slice slice = (Slice)event.getAffected();
                this.removeMFEParentFromMeasureFolder(slice);
            }
        }
    }

    private void removeMeasureFromMeasureFolder(Measure measure) {
        List mfearray = this.getMFElementByMeasure(measure);
        this.removeFromMeasures(mfearray);
    }

    private void removeMFEParentFromMeasureFolder(Object parent) {
        List mfearray = this.getMFElementByParent(parent);
        this.removeFromMeasures(mfearray);
    }

    private void removeFromMeasures(List mfearray) {
        Iterator it = mfearray.iterator();
        while (it.hasNext()) {
            this.removeFromMeasures((MFElement)it.next());
        }
    }

    private List getMFElementByParent(Object parent) {
        ArrayList<MFElement> mfearray = new ArrayList<MFElement>();
        for (MFElement mfe : this.measures) {
            if (mfe.getParent() != parent) continue;
            mfearray.add(mfe);
        }
        return mfearray;
    }

    private List getMFElementByMeasure(Measure object) {
        ArrayList<MFElement> mfearray = new ArrayList<MFElement>();
        for (MFElement mfe : this.measures) {
            if (mfe.getMeasureObject() != object) continue;
            mfearray.add(mfe);
        }
        return mfearray;
    }

    public List getAvailableMeasures() {
        return this.availableMeasures;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "measurefolder" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getParentFolderID() {
        if (this.parentFolder != null) {
            return this.parentFolder.getObjectID();
        }
        return this.parentFolderID;
    }

    public void setParentFolderID(String parentFolderID) {
        this.parentFolderID = parentFolderID;
        if (parentFolderID != null && this.parentFolder == null) {
            MeasureFolder mf = (MeasureFolder)this.getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(parentFolderID);
            if (mf == null) {
                this.getMultidimensionalDesign().addTask(new AddParentFolderTask(this));
            } else {
                mf.addSubfolders(this);
            }
        }
    }

    public class MFElement {
        private DesignObject parent = null;
        private Object measure = null;
        private boolean isMeasureWrapper;

        public MFElement(DesignObject parent, Object measure) {
            this.measure = measure;
            this.parent = parent;
            this.isMeasureWrapper = measure instanceof Slice.MeasureWrapper;
        }

        public String toString() {
            if (this.measure instanceof Measure) {
                return this.parent.getName() + "." + ((Measure)this.measure).getName();
            }
            if (this.measure instanceof Slice.MeasureWrapper) {
                return this.parent.getName() + "." + ((Slice.MeasureWrapper)this.measure).getMeasureAlias();
            }
            return super.toString();
        }

        public String getAgregateFunctionName() {
            if (this.measure instanceof Measure) {
                return ((Measure)this.measure).getDefaultAggregationFunction().toString();
            }
            if (this.measure instanceof Slice.MeasureWrapper) {
                return ((Slice.MeasureWrapper)this.measure).getAggrFunction().toString();
            }
            return super.toString();
        }

        public Object getMeasure() {
            return this.measure;
        }

        public void setMeasure(Object measure) {
            this.measure = measure;
        }

        public DesignObject getParent() {
            return this.parent;
        }

        public void setParent(DesignObject parent) {
            this.parent = parent;
        }

        public boolean isMeasureWrapper() {
            return this.isMeasureWrapper;
        }

        public String getMeasureObjectID() {
            if (this.measure instanceof Measure) {
                return ((Measure)this.measure).getObjectID();
            }
            return ((Slice.MeasureWrapper)this.measure).getMeasure().getObjectID();
        }

        public Measure getMeasureObject() {
            if (this.isMeasureWrapper()) {
                return ((Slice.MeasureWrapper)this.measure).getMeasure();
            }
            return (Measure)this.measure;
        }
    }

    public class AddParentFolderTask
    implements Task {
        private static final String TASK_NAME = "add parent folder task";
        MeasureFolder mf;

        AddParentFolderTask(MeasureFolder folder) {
            this.mf = folder;
        }

        @Override
        public boolean execute() {
            MeasureFolder pmf = (MeasureFolder)MeasureFolder.this.getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(this.mf.parentFolderID);
            if (pmf != null) {
                pmf.addSubfolders(this.mf);
            }
            return pmf != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

