/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDFixedSized;

public class MDVarCharSqlServer
extends MDFixedSized {
    private boolean allowVarcharMax = false;

    @Override
    public String getMaxSize() {
        return "8000";
    }

    @Override
    public String getName() {
        return "VARCHAR";
    }

    @Override
    public MDDataType deepCopy() {
        MDVarCharSqlServer copy = new MDVarCharSqlServer();
        copy.setSize(this.getSize());
        copy.setAllowVarcharMax(this.isAllowVarcharMax());
        return copy;
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize());
    }

    @Override
    public String getSize() {
        String s = super.getSize();
        if (!this.allowVarcharMax) {
            s = s.replaceFirst("max", this.getMaxSize());
            s = s.replaceFirst("MAX", this.getMaxSize());
        }
        return s;
    }

    public boolean isAllowVarcharMax() {
        return this.allowVarcharMax;
    }

    public void setAllowVarcharMax(boolean allowVarcharMax) {
        this.allowVarcharMax = allowVarcharMax;
    }
}

