/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDFixedSized;

public class MDNCharOracle
extends MDFixedSized {
    private String name = "NCHAR";

    public MDNCharOracle() {
        this.size = "1";
    }

    @Override
    public String getMaxSize() {
        return "2000";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setNationalCharacterSynonym() {
        this.name = "NATIONAL CHARACTER";
    }

    public void setNationalCharSynonym() {
        this.name = "NATIONAL CHAR";
    }

    public void setNationalCharacterVaryingSynonym() {
        this.name = "NATIONAL CHARACTER VARYING";
    }

    public void setNationalCharVaryingSynonym() {
        this.name = "NATIONAL CHAR VARYING";
    }

    public void setNCharVaryingSynonym() {
        this.name = "NCHAR VARYING";
    }

    @Override
    public MDDataType deepCopy() {
        MDNCharOracle copy = new MDNCharOracle();
        copy.setSize(this.getSize());
        return copy;
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        String numeric = this.size;
        if (numeric == null || "".equalsIgnoreCase(numeric) || "0".equalsIgnoreCase(numeric)) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.getName());
            buffer.append(" (");
            String s = this.getSize();
            s = s.replaceFirst("max", this.getMaxSize());
            s = s.replaceFirst("MAX", this.getMaxSize());
            buffer.append(s);
            buffer.append(')');
        }
    }
}

