/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public class AggrObject {
    String type;
    DesignObject designObject;
    ModelIDObject physicalObject;

    public AggrObject(DesignObject designObject, ModelIDObject physicalObject) {
        this.designObject = designObject;
        this.physicalObject = physicalObject;
        if (designObject != null) {
            this.type = designObject.getObjectTypeName();
        } else if (physicalObject != null) {
            this.type = physicalObject.getObjectTypeName();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DesignObject getDesignObject() {
        return this.designObject;
    }

    public void setDesignObject(DesignObject designObject) {
        this.designObject = designObject;
    }

    public ModelIDObject getPhysicalObject() {
        return this.physicalObject;
    }

    public void setPhysicalObject(ModelIDObject physicalObject) {
        this.physicalObject = physicalObject;
    }

    public static List<AggrObject> getAggrObjects(List<DesignObject> list, StorageDesign sd) {
        if (list.size() > 0) {
            ArrayList<AggrObject> res = new ArrayList<AggrObject>();
            for (DesignObject dob : list) {
                StorageObject so = sd.getStorageObject(dob.getObjectID());
                AggrObject aggr = new AggrObject(dob, so);
                res.add(aggr);
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }
}

