/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.oracle.MOHClusterOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDatafileOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDimensionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHFunctionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHMViewLog;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSensitiveTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTSDPPolicyOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTempTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHUndoTableSpaceOraclev10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHContextOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHExternalTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHRoleOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHUndoTableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.util.Closeables;

public class DBMExtractionHandlerOracle
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static DBMExtractionHandlerOracle dbmExtractionHandler;
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private boolean dbaUser = false;
    private MOHDirectoryOracle directoryHandler;
    private MOHTableOracle tableHandler;
    int release = 0;
    int version = 11;
    double dbVersion = 11.0;

    public DBMExtractionHandlerOracle(StorageDesign sd) {
        super(sd);
    }

    public static AbstractDBMExtractionHandler getInstance() {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerOracle(null);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public void init(Connection connection) {
        super.init(connection);
        this.setDBAUser(connection);
        this.initVersion(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void initVersion(Connection conn) {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            String sql = "with\nfunction ver return number is\nbegin\n return dbms_db_version.version;\nend;\nfunction rel return number is\nbegin \n return dbms_db_version.release;\nend;\nselect ver version , rel release from dual";
            statement = null;
            rs = null;
            try {
                String rel;
                String[] parts;
                String ver;
                int ind;
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) break block5;
                this.version = rs.getInt(1);
                this.release = rs.getInt(2);
                this.dbVersion = (double)this.version + (double)this.release / 10.0;
                if (this.release == 0 && (ind = (ver = conn.getMetaData().getDatabaseProductVersion()).indexOf("Version " + this.version + ".")) > 0 && (parts = (rel = ver.substring(ind + 8)).split("\\.")).length > 1) {
                    this.dbVersion += (double)Integer.valueOf(parts[1]).intValue() / 10.0;
                }
                rs.close();
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                catch (Throwable throwable2) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable2;
                }
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
    }

    public int getRelease() {
        return this.release;
    }

    public int getVersion() {
        return this.version;
    }

    public double getDBVersion() {
        return this.dbVersion;
    }

    public void setDBAUser(Connection conn) {
        this.dbaUser = DBMExtractionHandlerOracle.isDBAUser(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDBAUser(Connection conn) {
        boolean dbaUser;
        block7: {
            dbaUser = false;
            if (conn != null) {
                PreparedStatement statement = null;
                ResultSet rs = null;
                try {
                    try {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                        buffer.append(' ').append("FROM").append(' ').append("dba_users");
                        statement = conn.prepareStatement(buffer.toString());
                        rs = statement.executeQuery();
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                        buffer.append(' ').append("FROM").append(' ').append("dba_all_tables");
                        statement = conn.prepareStatement(buffer.toString());
                        rs = statement.executeQuery();
                        dbaUser = true;
                    }
                    catch (SQLException se) {
                        try {
                            dbaUser = false;
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            throw throwable;
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        break block7;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
                catch (Exception ex) {
                    dbaUser = false;
                }
            }
        }
        return dbaUser;
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        List list = super.getSchemas(conn);
        this.setDBAUser(conn);
        return list;
    }

    @Override
    public List getMOHObjects(Connection conn) {
        if (conn != null) {
            this.init(conn);
        }
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
        }
        return this.getMOHObjectsv10g();
    }

    private List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new MOHTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTempTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUndoTableSpaceOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDatafileOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHRoleOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeIncompleteOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.dbaUser));
            this.directoryHandler = new MOHDirectoryOracle(this, this.dbaUser);
            this.mohObjectsv9i.add(this.directoryHandler);
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHContextOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHClusterOracle(this, this.dbaUser));
            MOHViewOracle viewHandler = new MOHViewOracle(this, this.dbaUser);
            this.tableHandler = new MOHTableOraclev9i(this, this.dbaUser);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv9i.add(viewHandler);
            this.mohObjectsv9i.add(this.tableHandler);
            MOHBitmapIndexesv10g bitmapJoinIndexeHandler = new MOHBitmapIndexesv10g(this, this.dbaUser);
            this.tableHandler.setBitmapJoinIndexHandler(bitmapJoinIndexeHandler);
            this.mohObjectsv9i.add(new MOHExternalTableOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(bitmapJoinIndexeHandler);
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHMViewLog(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDimensionOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHPackageOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHFunctionOracle(this, this.dbaUser));
        }
        return this.mohObjectsv9i;
    }

    private List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new MOHTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTempTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUndoTableSpaceOraclev10g(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDatafileOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHRoleOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeIncompleteOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.dbaUser));
            this.directoryHandler = new MOHDirectoryOracle(this, this.dbaUser);
            this.mohObjectsv10g.add(this.directoryHandler);
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHContextOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHClusterOracle(this, this.dbaUser));
            MOHViewOracle viewHandler = new MOHViewOracle(this, this.dbaUser);
            this.tableHandler = new MOHTableOraclev9i(this, this.dbaUser);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv10g.add(viewHandler);
            this.mohObjectsv10g.add(this.tableHandler);
            MOHBitmapIndexesv10g bitmapJoinIndexeHandler = new MOHBitmapIndexesv10g(this, this.dbaUser);
            this.tableHandler.setBitmapJoinIndexHandler(bitmapJoinIndexeHandler);
            this.mohObjectsv10g.add(new MOHExternalTableOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(bitmapJoinIndexeHandler);
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHMViewLog(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDimensionOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHPackageOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHFunctionOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSensitiveTypeOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTSDPPolicyOracle(this, this.dbaUser));
        }
        return this.mohObjectsv10g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        RDBMSSiteSet rdbmsSiteSet = this.getDesign().getRDBMSSiteSet();
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
            case 20: 
            case 21: 
            case 23: {
                return rdbmsSiteSet.get(StorageDesignOraclev20c.RDBMS_TYPE);
            }
            case 12: {
                if (this.dbMinorVersion < 2) {
                    return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
                }
                return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        if (!this.isNullStorageDesign(this.getStorageDesign())) {
            this.setDBAUser(conn);
            super.generateDesign(conn, selectedObjects, importLog, monitor);
        }
    }

    public MOHDirectoryOracle getDirectoryHandler() {
        return this.directoryHandler;
    }

    @Override
    public AbstractMOHandler getTableHandler() {
        return this.tableHandler;
    }

    public boolean isDBAUser() {
        return this.dbaUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testConnection(Connection conn) {
        String res = "";
        try {
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                rs = st.executeQuery("select 1 from dual");
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                res = e.getMessage();
            }
            finally {
                Closeables.close((Object)rs);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static int getOracleVersionInt(Connection conn) {
        int ver = 11;
        String version = DBMExtractionHandlerOracle.getOracleVersion(conn);
        if (version.startsWith("12")) {
            ver = 12;
            if (version.startsWith("12.2")) {
                ver = 13;
            }
        } else {
            try {
                int tv = Integer.valueOf(version.substring(0, 2));
                if (tv > 12) {
                    ver = tv;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOracleVersion(Connection conn) {
        int dbMajorVersion = -1;
        int dbMinorVersion = -1;
        String res = "";
        if (conn == null) return res;
        boolean mvSet = false;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                rs = st.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                if (rs != null) {
                    String mv;
                    if (rs.next() && (mv = rs.getString(2)) != null && mv.length() > 0) {
                        String string = mv;
                        return string;
                    }
                    rs.close();
                }
            }
            catch (Exception mv) {
            }
            finally {
                Closeables.close((Object)rs);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (mvSet) return res;
            DatabaseMetaData dbmd = conn.getMetaData();
            dbMajorVersion = dbmd.getDatabaseMajorVersion();
            dbMinorVersion = dbmd.getDatabaseMinorVersion();
            return dbMajorVersion + "." + dbMinorVersion;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }
}

