/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateFunctionUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateFunctionUDB.class);

    public SHCreateFunctionUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateFunctionUDB.clearCR(line);
        if (Token.startsWithString(statement, "create function")) {
            try {
                this.parseFunction(statement, line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateFunctionUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseFunction(String statement, String line) {
        FunctionUDB func;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (storageDesign != null && (func = storageDesign.getFunctionSet().createFunction()) != null) {
            this.initFunctionName(storageDesign, func, statement);
            this.initSpecificName(func, line, statement);
            this.initBody(func, line, statement);
            this.design.getRelationalDesign().stampModelObjectDDL(func);
        }
    }

    private void initFunctionName(StorageDesignUDB storageDesign, FunctionUDB func, String statement) {
        String name = Token.getQuotedNameAfterToken(statement, "FUNCTION").trim();
        if (name.indexOf(46) > -1) {
            String schemaName = name.substring(0, name.indexOf(46)).trim();
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(schemaName);
            if (schema == null) {
                schema = storageDesign.getSchemaSet().createSchema();
                schema.setName(schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            func.setSchema(schema);
            func.setOwner(schema.getOwner());
            name = name.substring(name.indexOf(46) + 1);
        }
        func.setName(name);
    }

    private void initSpecificName(FunctionUDB func, String line, String statement) {
        String name;
        if (Token.hasToken(statement, "SPECIFIC") && !"".equals(name = Token.getQuotedNameAfterToken(statement, "SPECIFIC"))) {
            func.setSpecificName(name);
        }
    }

    private void initBody(FunctionUDB func, String line, String statement) {
        String funcName;
        int endNameIndex;
        String body;
        String afterFunc = Token.getStringAfter(line, "FUNCTION");
        int startIndex = 0;
        if (func.getSchema() != null) {
            String schemaName = func.getSchema().getName();
            startIndex = afterFunc.indexOf(schemaName) + schemaName.length();
        }
        if ((body = afterFunc.substring(endNameIndex = afterFunc.indexOf(funcName = func.getName(), startIndex) + funcName.length()).trim()).startsWith("\"")) {
            body = body.substring(1).trim();
        }
        if (body.endsWith(";")) {
            body = body.substring(0, body.length() - 1);
        }
        func.setBody(body);
    }
}

