/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElements
implements StatementsConstants {
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private static final String ZERO = "0";
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElements.class);
    private String tstatement = "";
    private String pstatement = "";

    public void parseColumns(String columnStatement) {
        this.statement = columnStatement;
        this.mapElementsColumn = new HashMap();
        this.tstatement = this.statement.toUpperCase();
        if (this.initColumnName()) {
            this.initDatatype();
            this.initNotNull();
            this.initIdentity();
            this.initFor();
            this.initWithDefault();
            this.initPrimaryKeyOrUnique();
            this.initReferences();
            this.initConstraintCheck();
            this.initFieldProc();
        } else {
            this.initConstraints();
        }
    }

    private boolean initColumnName() {
        String value = Token.getFirstToken(this.statement);
        if (this.constraints.contains(value.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", value);
        this.statement = Token.cutTokenFromFront(this.statement, value);
        return true;
    }

    private void initDatatype() {
        if (!this.statement.startsWith("FOREIGN")) {
            int index;
            String dtype = this.searchWhichDatatype(this.statement);
            Object type = null;
            String afterType = null;
            if (dtype != null) {
                type = dtype;
                afterType = Token.getStringAfter(this.statement, dtype).trim();
                if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                    type = dtype + afterType.substring(0, index + 1);
                }
            }
            if (dtype == null && (dtype = this.searchNotStandartDatatypes(this.statement)) != null) {
                type = dtype;
                afterType = Token.getStringAfter(this.statement, dtype).trim();
                if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                    type = dtype + afterType.substring(0, index + 1);
                }
                this.mapElementsColumn.put("typename", type);
            }
            if (dtype != null) {
                String datatype = StandardDatatypeNames.getUsedDatatypeName(dtype);
                if (Token.hasCloseAndOpenBrackets(datatype)) {
                    type = datatype;
                    dtype = datatype = Token.getValBeforeBrackets(datatype).trim();
                }
                if (datatype != null) {
                    type = Token.cutTokenFromFront((String)type, dtype);
                    this.mapElementsColumn.put("datatype", datatype);
                    if (!((String)type).equalsIgnoreCase("")) {
                        boolean hasBrackets = Token.hasCloseAndOpenBrackets((String)type);
                        if (hasBrackets) {
                            String parameters = Token.getValBetweenBrackets((String)type, 1);
                            int positionKomma = parameters.indexOf(",");
                            if (positionKomma != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                            } else if (datatype.equals("DECIMAL")) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", parameters.trim());
                            } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                                if (positionKomma != -1) {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                    this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                                } else {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.trim());
                                    this.mapElementsColumn.put("scale", ZERO);
                                }
                            } else {
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", ZERO);
                                this.mapElementsColumn.put("size", parameters.trim());
                            }
                            this.statement = Token.cutFirstToken(this.statement);
                        }
                    } else {
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    StringBuffer message = new StringBuffer("datatype is unknown in SHColumnElements.initDatatype: ");
                    LOGGER.error(message.toString());
                }
            } else {
                this.statement = Token.cutFirstToken(this.statement);
            }
        }
    }

    protected String searchWhichDatatype(String statement) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("DB2/390 7");
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = statement.toUpperCase().startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = statement.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private void initNotNull() {
        String notNull;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValAfterBrackets(this.statement.trim(), 1);
        }
        if ((notNull = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("NOT")) {
            if ("NULL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "NOT"))) {
                this.mapElementsColumn.put("NOT NULL", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "NOT NULL");
            } else {
                this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
        }
    }

    private void initIdentity() {
        int ind = this.tstatement.indexOf("GENERATED");
        if (ind > -1) {
            this.pstatement = this.tstatement.substring(ind);
            String gen = Token.getFirstToken(this.pstatement).trim();
            if (gen.equalsIgnoreCase("GENERATED")) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "GENERATED");
                String generate = Token.getFirstToken(this.pstatement).trim();
                if (generate.equalsIgnoreCase("ALWAYS")) {
                    this.mapElementsColumn.put("GENERATED", "ALWAYS");
                } else if (generate.equalsIgnoreCase("BY")) {
                    this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
                }
                if (Token.hasCloseAndOpenBrackets(this.pstatement)) {
                    int pos = this.pstatement.indexOf(40);
                    this.pstatement = this.pstatement.substring(pos).trim();
                    String elements = Token.getValBetweenBrackets(this.pstatement);
                    StringTokenizer st = new StringTokenizer(elements, ",");
                    while (st.hasMoreTokens()) {
                        String element = st.nextToken().trim();
                        if (Token.hasToken(element, "START")) {
                            element = Token.cutTokenFromFront(element, "START");
                            element = Token.cutTokenFromFront(element, "WITH");
                            this.mapElementsColumn.put("START", element);
                            continue;
                        }
                        if (Token.hasToken(element, "INCREMENT")) {
                            element = Token.cutTokenFromFront(element, "INCREMENT");
                            element = Token.cutTokenFromFront(element, "BY");
                            this.mapElementsColumn.put("INCREMENT", element);
                            continue;
                        }
                        if (Token.hasToken(element, "CACHE")) {
                            if (Token.hasToken(element, "NO")) {
                                this.mapElementsColumn.put("CACHE", ZERO);
                                continue;
                            }
                            element = Token.cutTokenFromFront(element, "CACHE");
                            this.mapElementsColumn.put("CACHE", element);
                            continue;
                        }
                        if (Token.hasToken(element, "CYCLE")) {
                            if (Token.hasToken(element, "NO")) {
                                this.mapElementsColumn.put("CYCLE", Boolean.FALSE);
                                continue;
                            }
                            this.mapElementsColumn.put("CYCLE", Boolean.TRUE);
                            continue;
                        }
                        if (Token.hasToken(element, "MAXVALUE")) {
                            element = Token.cutTokenFromFront(element, "MAXVALUE");
                            this.mapElementsColumn.put("MAXVALUE", element);
                            continue;
                        }
                        if (!Token.hasToken(element, "MINVALUE")) continue;
                        element = Token.cutTokenFromFront(element, "MINVALUE");
                        this.mapElementsColumn.put("MINVALUE", element);
                    }
                    pos = this.pstatement.indexOf(41);
                }
            }
        }
    }

    private void initPrimaryKeyOrUnique() {
        int ind = this.tstatement.indexOf("PRIMARY");
        if (ind > -1) {
            this.pstatement = this.tstatement.substring(ind);
            boolean isPrimary = Token.isTokenEqualTo(this.pstatement, 1, "PRIMARY");
            boolean isKey = Token.isTokenEqualTo(this.pstatement, 2, "KEY");
            if (!isKey) {
                isKey = Token.isTokenEqualTo(this.pstatement, 2, "KEY(");
            }
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            if (isPrimary && isKey) {
                this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "PRIMARY KEY");
            } else {
                this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            ind = this.tstatement.indexOf("UNIQUE");
            if (ind > -1) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initFor() {
        int ind = this.tstatement.indexOf("FOR");
        if (ind > -1) {
            this.pstatement = this.tstatement.substring(ind);
            boolean isFor = Token.isTokenEqualTo(this.statement, 1, "FOR");
            if (isFor) {
                this.statement = Token.cutTokenFromFront(this.statement, "FOR");
                String forElement = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("FOR", forElement);
                this.statement = Token.cutTokenFromFront(this.statement, forElement);
            }
        }
    }

    private void initWithDefault() {
        int ind = this.tstatement.indexOf("WITH");
        if (ind > -1) {
            boolean isDefault;
            this.pstatement = this.tstatement.substring(ind);
            boolean isWith = Token.isTokenEqualTo(this.pstatement, 1, "WITH");
            if (isWith) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "WITH");
            }
            if (isDefault = Token.isTokenEqualTo(this.pstatement, 1, "DEFAULT")) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "DEFAULT");
                String withDefault = Token.getValBetweenQuotationMarks2(this.pstatement).trim();
                if ("".equalsIgnoreCase(withDefault)) {
                    withDefault = this.getDefaultPartOnly(this.pstatement).trim();
                }
                this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
                this.mapElementsColumn.put("DEFAULT", withDefault);
            } else {
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            }
        }
    }

    private String getDefaultPartOnly(String str) {
        int ind = str.indexOf("CONSTRAINT");
        if (ind > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("CHECK")) > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("PRIMARY")) > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("UNIQUE")) > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("REFERENCES")) > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("FIELDPROC")) > -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf("GENERATED")) > -1) {
            str = str.substring(0, ind);
        }
        return str;
    }

    private void initReferences() {
        int indx = this.tstatement.indexOf("REFERENCES");
        if (indx > -1) {
            this.pstatement = this.tstatement.substring(indx);
            boolean isReferences = Token.isTokenEqualTo(this.pstatement, 1, "REFERENCES");
            if (isReferences) {
                boolean isOn;
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "REFERENCES");
                String references = Token.getFirstToken(this.pstatement);
                int ind = references.indexOf("(");
                if (ind > 0) {
                    references = references.substring(0, ind);
                }
                this.mapElementsColumn.put("REFERENCES", references);
                this.pstatement = Token.cutTokenFromFront(this.pstatement, references);
                boolean hasBrackets = Token.hasString(this.pstatement, "(");
                if (hasBrackets) {
                    String columnReferenced = Token.getValBetweenBrackets(this.pstatement);
                    this.mapElementsColumn.put("REFERENCED_COLUMN", columnReferenced);
                }
                if (isOn = Token.isTokenEqualTo(this.pstatement, 1, "ON")) {
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, "ON DELETE");
                    String onDelete = Token.getFirstToken(this.pstatement).trim();
                    this.mapElementsColumn.put("ON DELETE", onDelete);
                }
            }
        }
    }

    private void initConstraintCheck() {
        int ind = this.tstatement.indexOf("CONSTRAINT");
        if (ind > -1) {
            boolean isCheck;
            this.pstatement = this.tstatement.substring(ind);
            boolean isConstraint = Token.isTokenEqualTo(this.pstatement, 1, "CONSTRAINT");
            String constraint = "";
            if (isConstraint) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "CONSTRAINT");
                constraint = Token.getFirstToken(this.pstatement).trim();
                this.pstatement = Token.cutTokenFromFront(this.pstatement, constraint);
            }
            if (isCheck = Token.isTokenEqualTo(this.pstatement, 1, "CHECK")) {
                this.mapElementsColumn.put("CONSTRAINT", constraint);
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "CHECK");
                String check = Token.getFirstToken(this.pstatement).trim();
                this.pstatement = Token.cutTokenFromFront(this.pstatement, check);
                if (Token.hasOpenBracketNoClose(check)) {
                    String check2;
                    StringBuffer checkSB = new StringBuffer(check);
                    while (!Token.hasCloseBracket(Token.getFirstToken(this.pstatement)) && !(check2 = Token.getFirstToken(this.pstatement)).equals("")) {
                        checkSB.append(" ").append(check2);
                        this.pstatement = Token.cutTokenFromFront(this.pstatement, check2);
                    }
                    checkSB.append(" )");
                    checkSB.append(" )");
                    check = checkSB.toString();
                }
                check = Token.getValBetweenBrackets(check);
                this.mapElementsColumn.put("CHECK", check);
            }
        } else {
            ind = this.tstatement.indexOf("CHECK");
            if (ind > -1) {
                this.pstatement = this.tstatement.substring(ind);
                boolean isCheck = Token.isTokenEqualTo(this.pstatement, 1, "CHECK");
                if (isCheck) {
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, "CHECK");
                    String check = Token.getFirstToken(this.pstatement).trim();
                    this.pstatement = Token.cutTokenFromFront(this.pstatement, check);
                    if (Token.hasOpenBracketNoClose(check)) {
                        String check2;
                        StringBuffer checkSB = new StringBuffer(check);
                        while (!Token.hasCloseBracket(Token.getFirstToken(this.pstatement)) && !(check2 = Token.getFirstToken(this.pstatement)).equals("")) {
                            checkSB.append(" ").append(check2);
                            this.pstatement = Token.cutTokenFromFront(this.pstatement, check2);
                        }
                        checkSB.append(" )");
                        checkSB.append(" )");
                        check = checkSB.toString();
                    }
                    check = Token.getValBetweenBrackets(check);
                    this.mapElementsColumn.put("CHECK", check);
                }
            }
        }
    }

    private String searchNotStandartDatatypes(String string) {
        String[] names = NotStandartDataTypeNames.getAllNewTypes();
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = string.equalsIgnoreCase(name);
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private void initFieldProc() {
        int ind = this.tstatement.indexOf("FIELDPROC");
        if (ind > -1) {
            this.pstatement = this.tstatement.substring(ind);
            boolean isFieldProc = Token.isTokenEqualTo(this.pstatement, 1, "FIELDPROC");
            if (isFieldProc) {
                this.pstatement = Token.cutTokenFromFront(this.pstatement, "FIELDPROC");
                this.mapElementsColumn.put("FIELDPROC", this.pstatement);
            }
        }
    }

    public Map getElementsColumn(String statement) {
        this.parseColumns(statement.replaceAll("\"", ""));
        return this.mapElementsColumn;
    }

    private void initConstraints() {
        String value = Token.getFirstToken(this.statement);
        if (value.equalsIgnoreCase("CONSTRAINT")) {
            String name = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.statement = Token.getStringAfterToken(this.statement, name);
            this.mapElementsColumn.put("CONSTRAINT_NAME", name);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initTableConstraints() {
        boolean isCheck = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (isCheck) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String value = Token.getValBetweenBrackets(this.statement);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", value);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }
}

