/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDLogicalDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "Logical Model";

    public CWDLogicalDesign(CWDExtractionHandler handler, ApplicationView view) {
        super(handler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(List selectedObjects, ImportLogger importLog) throws Exception {
        for (CWDDesignObj object : selectedObjects) {
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (object.isSelected()) {
                LogicalDesign logical = (LogicalDesign)object.getModel();
                logical.setShouldBeOpen(true);
            }
            importLog.incrementImportedStatements();
        }
    }

    @Override
    public List extract(List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        for (CWDDesignObj object : appSystems) {
            LogicalDesign logical;
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (object.isSelected()) {
                logical = (LogicalDesign)object.getModel();
                if (!logical.isLoaded()) {
                    logical.setShouldBeOpen(true);
                    if (logical.getDesign().isOldRepositoryType()) {
                        logical.load();
                    } else {
                        logical.getAppView().getXMLTransformationManager().openDesignPart(logical);
                    }
                }
                if (!logical.getDesign().isOldRepositoryType()) continue;
                logical.getDesign().getExtendedMap().load();
                continue;
            }
            logical = (LogicalDesign)object.getModel();
            logical.setShouldBeOpen(false);
        }
        return list;
    }
}

