/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DMDiagramNode;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.DMGitCellRenderer;
import oracle.dbtools.crest.swingui.DMGitStringCellRenderer;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.git.GITRemUsers;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCommit;
import oracle.jdevimpl.vcs.git.cmd.custom.GITCommitCustomizer;
import oracle.jdevimpl.vcs.git.res.Resource;

public class DMGITOperationCommit
extends GITOperationCommit {
    Design design;

    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        JEWTDialog dialog = super.createOperationDialogImpl(nodes, customizer, commandState);
        this.getGITVersionOperationPanel().setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DMGitCellRenderer()));
        this.getGITVersionOperationPanel().setDefaultRenderer(String.class, (TableCellRenderer)new DMGitStringCellRenderer());
        return dialog;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection<Locatable> nodes) {
        URL[] urls = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs(nodes));
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.git", (VCSOptionsCustomizer)new GITCommitCustomizer(!this.isCommitConflict()));
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(GITOperationCommit.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get((String)"VCS_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        customizer.setContextURLs(urls);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("commit-not-staged", Boolean.TRUE);
        URL root = null;
        root = urls.length > 0 ? GITUtil.getRootContaining((URL)urls[0]) : GITUtil.getClientRoot();
        if (root != null) {
            List authorList = GITUtil.getUserList((URL)root);
            options.put("user-details", authorList);
        }
        options.put("remember-authors", GITRemUsers.getAuthors());
        options.put("remember-commiters", GITRemUsers.getCommiters());
        customizer.setOptions(options);
        return customizer;
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        URL[] urls = VCSContextUtils.getVersionEditorUrls((VCSProfile)profile);
        Node[] nodes = this.getNodes(urls);
        URLFilter filter = this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
        Collection ns = VCSCommandUtils.getDirtyNodesFrom((URLFilter)filter, (Locatable[])nodes);
        for (Node n : ns) {
            String s;
            if (!(n instanceof Workspace) || (s = ((Workspace)n).getProperty(GitClientHelper.MODELER_PATHS)) == null || s.isEmpty()) continue;
            n.markDirty(false);
        }
        return VCSCommandUtils.saveDirtyNodes((Locatable[])nodes);
    }

    protected boolean isAvailableImpl() throws Exception {
        Node node = this.getContext().getNode();
        if (node instanceof DMDiagramNode) {
            Design design = ((DMDiagramNode)node).getDesign();
            return design.isGitVersioned();
        }
        return super.isAvailableImpl();
    }
}

