/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.util.Hashtable;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class XMLADataTypesMapping
implements MDDataTypeNames {
    private static final Hashtable DATATYPE_MAP = new Hashtable();
    private static final Hashtable COLUMN_DATATYPE_MAP = new Hashtable();
    private static final Logger LOGGER = new Logger(XMLADataTypesMapping.class);

    public static String getAppropriateDatatype(String datatype) {
        if (datatype != null) {
            String name;
            if (datatype.indexOf(40) > -1) {
                datatype = datatype.substring(0, datatype.indexOf(40));
            }
            if ((name = (String)DATATYPE_MAP.get(datatype.toUpperCase().trim())) == null) {
                StringBuffer message = new StringBuffer("There is no mapping for datatype ");
                message.append(datatype);
                message.append(" in XMLADataTypesMapping.getAppropriateDatatype");
                LOGGER.error(message.toString());
                return datatype;
            }
            return name;
        }
        StringBuffer message = new StringBuffer("NULL passed as parameter ");
        message.append(" in XMLADataTypesMapping.getAppropriateDatatype");
        LOGGER.error(message.toString());
        return "UNKNOWN";
    }

    public static String getAppropriateColumnDatatype(String datatype) {
        if (datatype != null) {
            String name;
            if (datatype.indexOf(40) > -1) {
                datatype = datatype.substring(0, datatype.indexOf(40));
            }
            if ((name = (String)COLUMN_DATATYPE_MAP.get(datatype.toUpperCase().trim())) == null) {
                StringBuffer message = new StringBuffer("There is no mapping for datatype ");
                message.append(datatype);
                message.append(" in XMLADataTypesMapping.getAppropriateColumnDatatype");
                LOGGER.error(message.toString());
                return datatype;
            }
            return name;
        }
        StringBuffer message = new StringBuffer("NULL passed as parameter ");
        message.append(" in XMLADataTypesMapping.getAppropriateColumnDatatype");
        LOGGER.error(message.toString());
        return "UNKNOWN";
    }

    static {
        DATATYPE_MAP.put("INTEGER", "Integer");
        DATATYPE_MAP.put("DOUBLE", "Double");
        DATATYPE_MAP.put("DECIMAL", "Decimal");
        DATATYPE_MAP.put("SMALLINT", "SmallInt");
        DATATYPE_MAP.put("DATETIME", "Date");
        DATATYPE_MAP.put("DATE", "Date");
        DATATYPE_MAP.put("UNIQUEIDENTIFIER", "WChar");
        DATATYPE_MAP.put("BIGINT", "Integer");
        DATATYPE_MAP.put("BIT", "Boolean");
        DATATYPE_MAP.put("NUMERIC", "Currency");
        DATATYPE_MAP.put("BINARY", "WChar");
        DATATYPE_MAP.put("BOOLEAN", "Boolean");
        COLUMN_DATATYPE_MAP.put("INTEGER", "integer");
        COLUMN_DATATYPE_MAP.put("DOUBLE", "double");
        COLUMN_DATATYPE_MAP.put("DECIMAL", "double");
        COLUMN_DATATYPE_MAP.put("SMALLINT", "int");
        COLUMN_DATATYPE_MAP.put("DATETIME", "date");
        COLUMN_DATATYPE_MAP.put("DATE", "date");
        COLUMN_DATATYPE_MAP.put("UNIQUEIDENTIFIER", "string");
        COLUMN_DATATYPE_MAP.put("BIGINT", "integer");
        COLUMN_DATATYPE_MAP.put("BIT", "boolean");
        COLUMN_DATATYPE_MAP.put("NUMERIC", "double");
        COLUMN_DATATYPE_MAP.put("BINARY", "string");
        COLUMN_DATATYPE_MAP.put("WCHAR", "string");
        COLUMN_DATATYPE_MAP.put("CURRENCY", "double");
        COLUMN_DATATYPE_MAP.put("BOOLEAN", "boolean");
    }
}

