/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSSourceTargetMappings;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformations
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationTask transformTask) throws Exception {
        ArrayList<Transformation> list = new ArrayList<Transformation>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TRANSFORMATIONS (Transformation_ID, Transformation_OVID, Transformation_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Filter_Condition, Join_Condition, Primary, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = transformTask.getTransformationSet().iterator();
        while (it.hasNext()) {
            Transformation transform2 = (Transformation)it.next();
            String transformOVID = RSTransformations.getOrCreateOVID(map, transform2.getObjectID());
            stmt.setString(1, transform2.getObjectID());
            stmt.setString(2, transformOVID);
            stmt.setString(3, transform2.getName());
            stmt.setString(4, transformTask.getObjectID());
            stmt.setString(5, (String)map.get(transformTask.getObjectID()));
            stmt.setString(6, transformTask.getName());
            stmt.setString(7, transform2.getFilterCondition());
            stmt.setString(8, transform2.getJoinCondition());
            stmt.setString(9, transform2.isPrimary() ? "Y" : "N");
            stmt.setString(10, (String)map.get(transformTask.getDesign().getObjectID()));
            stmt.addBatch();
            list.add(transform2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Transformation transform2 : list) {
                RSObjectNotes.export(map, connection, transform2);
                RSComments.export(map, connection, transform2);
                RSSourceTargetMappings.export(map, connection, transform2);
                RSDynamicProperties.export(transformTask.getDesign(), map, connection, transform2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Transformation transform : list) {
                RSObjectNotes.export(map, connection, transform);
                RSComments.export(map, connection, transform);
                RSSourceTargetMappings.export(map, connection, transform);
                RSDynamicProperties.export(transformTask.getDesign(), map, connection, transform);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

