/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSPKOidColumns
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_PK_OID_COLUMNS (Column_ID, Column_OVID, Table_ID, Table_OVID, Table_Name, Column_Name,Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (ContainedObject column : table.getOidPKColumns()) {
            String columnOVID = RSPKOidColumns.getOrCreateOVID(map, column.getObjectID());
            stmt.setString(1, column.getObjectID());
            stmt.setString(2, columnOVID);
            stmt.setString(3, table.getObjectID());
            stmt.setString(4, (String)map.get(table.getObjectID()));
            stmt.setString(5, table.getName());
            stmt.setString(6, column.getName());
            stmt.setString(7, (String)map.get(table.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

