/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSynonymDB2v70
extends SQLStatementBuilder {
    private static final String SET_CURRENT_SQLID = "SET CURRENT SQLID";
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SynonymDB2 && ((SynonymDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SynonymDB2 synonym;
        if (object instanceof SynonymDB2 && (synonym = (SynonymDB2)object) != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(synonym);
            this.appendComment(buffer, synonym);
            if (synonym.getOwner() != null) {
                if (!synonym.getOwner().isNullInstance()) {
                    SSBSynonymDB2v70.appendStringWithSpace(buffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v70.appendStringWithSpace(buffer, "=");
                    buffer.append(" '");
                    SSBSynonymDB2v70.appendString(buffer, this.storageDesign.getFormatedName(synonym.getOwner().getName()));
                    buffer.append("'");
                    SSBSynonymDB2v70.appendLineFinisher(buffer, prettyPrint);
                } else {
                    SSBSynonymDB2v70.appendStringWithSpace(buffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v70.appendStringWithSpace(buffer, "= USER");
                    SSBSynonymDB2v70.appendLineFinisher(buffer, prettyPrint);
                }
            }
            this.appendCreate(buffer);
            SSBSynonymDB2v70.appendStringWithSpace(buffer, "SYNONYM");
            SSBSynonymDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(synonym.getName()));
            SSBSynonymDB2v70.appendNewLine(buffer, prettyPrint, 1);
            if (synonym.getTable() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(buffer, "FOR");
                SSBSynonymDB2v70.appendString(buffer, this.storageDesign.getFormatedName(synonym.getTable().getLongNameDDL()));
            } else if (synonym.getView() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(buffer, "FOR");
                SSBSynonymDB2v70.appendString(buffer, this.storageDesign.getFormatedName(synonym.getView().getLongNameDDL()));
            } else if (synonym.getAlias() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(buffer, "FOR");
                SSBSynonymDB2v70.appendString(buffer, this.storageDesign.getFormatedName(synonym.getAlias().getLongNameDDL()));
            }
            SSBSynonymDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBSynonymDB2v70.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateSynomym();
        }
    }
}

