/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHModel
extends ExportHandler {
    public EHModel(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Model_Name").append(",");
        sb.append("Model_Type").append(",");
        sb.append("RDBMS_Type");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            sb = new StringBuffer();
            sb.append(logDesign.getObjectID()).append(",");
            sb.append(logDesign.getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(logDesign.getName())).append(",");
            sb.append("Logical").append(",");
            sb.append("").append(",");
            lines.add(sb.toString());
            this.getCsvExporter().addNote(logDesign.getObjectID(), logDesign.getNumID(), "Model", logDesign.getNotes());
            this.getCsvExporter().addComment(logDesign.getObjectID(), logDesign.getNumID(), "Model", logDesign.getNotes());
            this.getCsvExporter().addCommentRDBMS(logDesign.getObjectID(), logDesign.getNumID(), "Model", logDesign.getNotes());
        }
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            sb = new StringBuffer();
            sb.append(phDesign.getObjectID()).append(",");
            sb.append(phDesign.getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(phDesign.getName())).append(",");
            sb.append("Relational").append(",");
            sb.append(phDesign.getSelectedRDBMSType().getTypeName()).append(",");
            lines.add(sb.toString());
            this.getCsvExporter().addNote(phDesign.getObjectID(), phDesign.getNumID(), "Model", phDesign.getNotes());
            this.getCsvExporter().addComment(phDesign.getObjectID(), phDesign.getNumID(), "Model", phDesign.getNotes());
            this.getCsvExporter().addCommentRDBMS(phDesign.getObjectID(), phDesign.getNumID(), "Model", phDesign.getNotes());
        }
        DataTypesDesign dtDesign = this.getDesign().getDataTypesDesign();
        if (this.getCsvExporter().isModelSelected(dtDesign)) {
            sb = new StringBuffer();
            sb.append(dtDesign.getObjectID()).append(",");
            sb.append(dtDesign.getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(dtDesign.getName())).append(",");
            sb.append("Data Types").append(",");
            sb.append("").append(",");
            lines.add(sb.toString());
            this.getCsvExporter().addNote(dtDesign.getObjectID(), dtDesign.getNumID(), "Model", dtDesign.getNotes());
            this.getCsvExporter().addComment(dtDesign.getObjectID(), dtDesign.getNumID(), "Model", dtDesign.getComment());
            this.getCsvExporter().addCommentRDBMS(dtDesign.getObjectID(), dtDesign.getNumID(), "Model", dtDesign.getCommentInRDBMS());
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Models.csv";
    }
}

