/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.Utilities;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.list.LabelListCellRenderer;
import oracle.javatools.ui.list.SimpleListModel;
import oracle.javatools.ui.list.SingleListSelectionModel;

public final class MultiCodePeek<O>
extends Peek {
    private final BasicEditorPane ep = new BasicEditorPane();
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private final JList list = new JList();
    private SimpleListModel<PeekItem> items;

    public MultiCodePeek(JComponent comp, List<PeekItem> items) {
        this(comp, HoverFlavor.getFlavor((String)"source"), items);
    }

    public MultiCodePeek(JComponent comp, HoverFlavor hoverFlavor, List<PeekItem> items) {
        super(comp, new JPanel(new BorderLayout(0, 4)), hoverFlavor);
        this.ep.setOpaque(true);
        this.ep.putClientProperty((Object)UIConstants.VETO_CONVERSION, (Object)Boolean.TRUE);
        this.list.setFocusable(false);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultiCodePeek.this.updateSelection();
            }
        });
        this.list.setCellRenderer(new LabelListCellRenderer<PeekItem>(){

            public void formatLabel(JLabel label, JList list, PeekItem value, int index, boolean isSelected, boolean cellHasFocus) {
                label.setText(value.itemLabel);
                if (!isSelected) {
                    this.setBackground(super.getBackground().brighter());
                    this.setForeground(ColorUtils.shadeColor((Color)super.getForeground(), (int)95));
                }
            }
        });
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int i = MultiCodePeek.this.list.locationToIndex(e.getPoint());
                if (i >= 0) {
                    MultiCodePeek.this.list.setSelectedIndex(i);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                ActionEvent ae = new ActionEvent(MultiCodePeek.this, -1, "Item Selected");
                for (ActionListener l : MultiCodePeek.this.listeners) {
                    l.actionPerformed(ae);
                }
            }
        });
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("no items provided");
        }
        JComponent content = this.getContentComponent();
        content.add((Component)this.list, "North");
        content.add((Component)this.ep, "Center");
        this.items = new SimpleListModel(items);
        this.list.setModel(this.items);
        this.list.setSelectionModel((ListSelectionModel)new SingleListSelectionModel());
        this.updateSelection();
    }

    private void updateSelection() {
        PeekItem item = (PeekItem)this.list.getSelectedValue();
        if (item == null) {
            return;
        }
        String text = item.text == null ? "" : Utilities.trimCommonWhitespace((String)item.text);
        this.ep.setPreferredSize(null);
        this.ep.getParent().setPreferredSize(null);
        this.ep.setEditable(true);
        this.ep.setText(text == null ? "" : text);
        this.ep.setCaretPosition(0);
        this.ep.setEditable(false);
        if (item.filename != null) {
            this.ep.setLanguageSupport(item.filename);
        }
        this.setLabelText(item.detailLabel);
        GhostPointingPalette gp = this.getGhostPointingPalette();
        Rectangle r = gp.getBounds();
        gp.pack();
        gp.repaint(r);
        gp.repaint(gp.getBounds());
    }

    @Override
    public void hidePeek() {
        super.hidePeek();
        this.ep.dispose();
    }

    @Override
    protected boolean isContentTransparent() {
        return false;
    }

    public void setSelectedItem(PeekItem<O> item) {
        this.list.setSelectedValue(item, true);
    }

    public PeekItem<O> getSelectedItem() {
        return (PeekItem)this.list.getSelectedValue();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    public static final class PeekItem<O> {
        private final String text;
        private final String itemLabel;
        private final String detailLabel;
        private final O userObject;
        private final String filename;

        public PeekItem(String text, String itemLabel, String detailLabel, O userObject, String fileName) {
            this.text = text;
            this.itemLabel = itemLabel;
            this.detailLabel = detailLabel;
            this.userObject = userObject;
            this.filename = fileName;
            if (text == null) {
                throw new IllegalArgumentException("text cannot be null");
            }
            if (itemLabel == null) {
                throw new IllegalArgumentException("itemLabel cannot be null");
            }
        }

        public O getUserObject() {
            return this.userObject;
        }
    }
}

