/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.IPopupSupplier;
import oracle.dbtools.raptor.sqltrace.SqlTraceEditorNode;
import oracle.dbtools.raptor.sqltrace.TableColumnChooser;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextCellEditor;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlTraceTimeRenderer;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SqlTraceListStatisticsEditor
extends Editor
implements IPopupSupplier {
    protected static final Object SORT_COL_IDX = "COL_SORT_IDX";
    protected static final Object SORT_DIRECTION = "COL_SORT_DIRECTION";
    private JComponent _ui;
    private Toolbar _toolBar;
    private DefaultTableModel _model;
    private JComboBox _filter;
    private JScrollPane _sp;
    private JCheckBox _includeSys;
    protected String _filterText;
    private JTable _table;
    private SqlTraceEditorNode _node;
    private SqlTraceTimeRenderer _renderer;
    private int _sortCol;
    private String _sortDir;

    public void open() {
    }

    private void init() {
        if (this._ui == null) {
            this.setToolbarVisible(true);
            this._table = new JTable();
            TableColumnChooser.install(this._table);
            this._node = (SqlTraceEditorNode)this.getContext().getNode();
            this._model = (DefaultTableModel)this._table.getModel();
            this._table.setAutoResizeMode(4);
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.2"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.3"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.4"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.5"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.6"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.7"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.8"));
            this._model.addColumn(TuningResources.getString("SqlTraceListStatisticsEditor.9"));
            this._table.setRowHeight(50);
            this._table.getColumnModel().getColumn(0).setMinWidth(100);
            this._table.getColumnModel().getColumn(0).setPreferredWidth(200);
            this._table.getColumnModel().getColumn(0).setResizable(true);
            this._table.setShowGrid(true);
            this._renderer = new SqlTraceTimeRenderer();
            this._renderer.setTimeFactor(1000000L);
            for (int i = 1; i < 8; ++i) {
                this._table.getColumnModel().getColumn(i).setCellRenderer(this._renderer);
                this._table.getColumnModel().getColumn(i).setResizable(false);
                this._table.getColumnModel().getColumn(i).setPreferredWidth(65);
                this._table.getColumnModel().getColumn(i).setMaxWidth(65);
            }
            this._table.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (jTable.getClientProperty(SORT_COL_IDX) == null || (Integer)jTable.getClientProperty(SORT_COL_IDX) != n2 || jTable.getClientProperty(SORT_DIRECTION).toString().equals("A") || jTable.getClientProperty(SORT_DIRECTION).toString().equals("D")) {
                        // empty if block
                    }
                    ((JLabel)component).setBackground(SqlTraceListStatisticsEditor.this._table.getParent().getBackground());
                    ((JLabel)component).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return component;
                }
            });
            this._table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = SqlTraceListStatisticsEditor.this._table.getTableHeader().getTable().columnAtPoint(mouseEvent.getPoint());
                        SqlTraceListStatisticsEditor.this.sort(n);
                    }
                }
            });
            this._table.getColumnModel().getColumn(0).setCellRenderer(new MultiLineTextRenderer());
            this._table.setDefaultEditor(Object.class, new MultiLineTextCellEditor());
            this.initToolbar();
            this.loadCursors();
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this._table);
            this._ui = jScrollPane;
        }
    }

    private void sort(int n) {
        String string = "A";
        if (this._table.getClientProperty(SORT_COL_IDX) != null) {
            int n2 = (Integer)this._table.getClientProperty(SORT_COL_IDX);
            String string2 = (String)this._table.getClientProperty(SORT_DIRECTION);
            if (n2 == n) {
                if (string2 == null || string2.equals("")) {
                    string2 = "A";
                } else if (string2.equals("A")) {
                    string = "D";
                } else if (string2.equals("D")) {
                    string = "";
                }
            }
        }
        this._table.putClientProperty(SORT_COL_IDX, n);
        this._table.putClientProperty(SORT_DIRECTION, string);
        this._sortCol = n;
        this._sortDir = string;
        this.loadCursors();
    }

    private void initToolbar() {
        if (this._toolBar == null) {
            this._toolBar = new Toolbar();
            final JComboBox jComboBox = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            defaultComboBoxModel.addElement("s");
            char c = '\u0173';
            defaultComboBoxModel.addElement(c + "s");
            jComboBox.setSize(20, jComboBox.getHeight());
            jComboBox.setMaximumSize(new Dimension(100, 30));
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (jComboBox.getSelectedIndex() == 0) {
                            SqlTraceListStatisticsEditor.this._renderer.setTimeFactor(1000000L);
                        } else if (jComboBox.getSelectedIndex() == 1) {
                            SqlTraceListStatisticsEditor.this._renderer.setTimeFactor(0L);
                        }
                        SqlTraceListStatisticsEditor.this.getGUI().repaint();
                    }
                }
            });
            this._filter = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel2 = (DefaultComboBoxModel)this._filter.getModel();
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.6"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.7"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.8"));
            this._filter.setSelectedIndex(1);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SqlTraceListStatisticsEditor.this.loadCursors();
                }
            };
            this._filter.addItemListener(itemListener);
            this._filter.setMaximumSize(this._filter.getMinimumSize());
            this._includeSys = new JCheckBox(TuningResources.getString("SqlTraceListCursorsEditor.9"));
            this._includeSys.setSelected(false);
            this._includeSys.addItemListener(itemListener);
            final SearchField searchField = new SearchField();
            Dimension dimension = searchField.getPreferredSize();
            dimension.setSize(150, dimension.height);
            searchField.setMinimumSize(dimension);
            searchField.setPreferredSize(dimension);
            searchField.setMaximumSize(dimension);
            searchField.addSearchListener(new SearchListener(){

                public void searchCategoryChanged(SearchEvent searchEvent) {
                }

                public void searchPerformed(SearchEvent searchEvent) {
                    SqlTraceListStatisticsEditor.this._filterText = searchField.getText();
                    SqlTraceListStatisticsEditor.this.loadCursors();
                }
            });
            int n = 0;
            this._toolBar.addComponent((Component)searchField, n++);
            this._toolBar.addComponent((Component)new JLabel(TuningResources.getString("SqlTraceListCursorsEditor.20")), n++);
            this._toolBar.addComponent(jComboBox, n++);
            this._toolBar.addComponent((Component)new JLabel(TuningResources.getString("SqlTraceListCursorsEditor.21")), n++);
            this._toolBar.addComponent((Component)this._filter, n++);
            this._toolBar.addComponent((Component)this._includeSys, n++);
            this._toolBar.addComponent(Box.createHorizontalGlue(), n++);
        }
    }

    public Component getPopup(Object object) {
        JComponent jComponent = null;
        if (object instanceof SqlCursor) {
            jComponent = new JLabel(object.toString());
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof Stat) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            String string = "%8d-%s<br>";
            JLabel jLabel = new JLabel();
            jLabel.setBackground(Color.WHITE);
            jLabel.setText(stringBuilder.toString());
            Dimension dimension = jLabel.getPreferredSize();
            jLabel.setMinimumSize(new Dimension(250, 100));
            jComponent = jLabel;
        } else if (object instanceof String) {
            MultiLineLabel multiLineLabel = new MultiLineLabel();
            multiLineLabel.setText(object.toString());
            multiLineLabel.setBackground(Color.WHITE);
            multiLineLabel.setForceWrapping(true);
            String[] stringArray = object.toString().split("\n");
            if (stringArray.length < 20) {
                multiLineLabel.setMinimumRows(stringArray.length + 2);
            } else {
                multiLineLabel.setMinimumRows(21);
            }
            multiLineLabel.setOpaque(true);
            for (int i = 0; i < 20; ++i) {
                if (stringArray.length <= i || multiLineLabel.getMinimumColumns() >= stringArray[i].length()) continue;
                multiLineLabel.setMinimumColumns(stringArray[i].length() + 10);
            }
            jComponent = multiLineLabel;
        } else {
            jComponent = null;
        }
        if (jComponent != null && jComponent instanceof JTable) {
            if (this._sp == null) {
                this._sp = new JScrollPane(jComponent);
                this._sp.setVerticalScrollBarPolicy(21);
            }
            this._sp.setViewportView(jComponent);
            if (this._sp.getPreferredSize() != ((Component)jComponent).getPreferredSize()) {
                this._sp.setPreferredSize(((JTable)jComponent).getPreferredSize());
                this._sp.setMinimumSize(((JTable)jComponent).getPreferredSize());
            }
            jComponent = this._sp;
        }
        return jComponent;
    }

    public Component getGUI() {
        this.init();
        return this._ui;
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.init();
    }

    public Component getFixedTopMargin() {
        this.initToolbar();
        this.init();
        return this._toolBar;
    }

    public void loadCursors() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>(TuningResources.getString("SqlTraceListCursorsEditor.29"), true, IRaptorTaskRunMode.TASKVIEWER){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws TaskException {
                SqlTraceListStatisticsEditor.this._node.getTraceFile();
                Vector<Vector> vector = SqlTraceListStatisticsEditor.this._model.getDataVector();
                synchronized (vector) {
                    Vector<Vector> vector2 = SqlTraceListStatisticsEditor.this._model.getDataVector();
                    vector2.removeAllElements();
                    for (SqlCursor sqlCursor : SqlTraceListStatisticsEditor.this._node.getTraceFile().getCursors()) {
                        Object object;
                        int n = SqlTraceListStatisticsEditor.this._filter.getSelectedIndex();
                        boolean bl = false;
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1 && sqlCursor.getDepLevel() == 0) {
                            bl = true;
                        } else if (n == 2 && sqlCursor.getDepLevel() > 0) {
                            bl = true;
                        }
                        if (sqlCursor.getUid() == 0 && SqlTraceListStatisticsEditor.this._includeSys.isSelected()) {
                            bl = true;
                        } else if (sqlCursor.getUid() == 0 && !SqlTraceListStatisticsEditor.this._includeSys.isSelected()) {
                            bl = false;
                        }
                        if (bl && SqlTraceListStatisticsEditor.this._filterText != null && SqlTraceListStatisticsEditor.this._filterText.trim().length() > 0) {
                            if (SqlTraceListStatisticsEditor.this._filterText.charAt(0) == '/' && SqlTraceListStatisticsEditor.this._filterText.charAt(SqlTraceListStatisticsEditor.this._filterText.length() - 1) == '/') {
                                boolean bl2;
                                object = SqlTraceListStatisticsEditor.this._filterText.substring(1, SqlTraceListStatisticsEditor.this._filterText.length() - 1);
                                String string = sqlCursor.getSQL();
                                Pattern pattern = Pattern.compile((String)object, 10);
                                Matcher matcher = pattern.matcher(string.replaceAll("\n", " "));
                                bl = bl2 = matcher.find();
                            } else if (sqlCursor.getSQL().toLowerCase().indexOf(SqlTraceListStatisticsEditor.this._filterText.toLowerCase()) == -1) {
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        object = new Vector<Object>();
                        ((Vector)object).add(sqlCursor.getSQL());
                        ((Vector)object).add(sqlCursor.getExecuteCount());
                        ((Vector)object).add(sqlCursor.getMinTime());
                        ((Vector)object).add(sqlCursor.getMaxTime());
                        ((Vector)object).add(sqlCursor.getMean());
                        ((Vector)object).add(sqlCursor.getMedian());
                        ((Vector)object).add(sqlCursor.getStdDev());
                        ((Vector)object).add(sqlCursor.getTotalTime());
                        vector2.add((Vector)object);
                    }
                    if (SqlTraceListStatisticsEditor.this._sortDir != null && !SqlTraceListStatisticsEditor.this._sortDir.equals("")) {
                        SqlTraceListStatisticsEditor.this.sortCursors(SqlTraceListStatisticsEditor.this._table, SqlTraceListStatisticsEditor.this._model, SqlTraceListStatisticsEditor.this._sortCol, SqlTraceListStatisticsEditor.this._sortDir);
                    }
                    SqlTraceListStatisticsEditor.this._model.fireTableDataChanged();
                }
                return null;
            }
        };
        raptorTask.setCancellable(true);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public Component getComponentAt(Point point) {
        return this.getGUI().getComponentAt(point);
    }

    public void sortCursors(JTable jTable, DefaultTableModel defaultTableModel, final int n, final String string) {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                Object e = ((Vector)object).get(n);
                Object e2 = ((Vector)object2).get(n);
                int n2 = 0;
                if (e instanceof Comparable) {
                    n2 = ((Comparable)e).compareTo(e2);
                }
                return n2 == 0 || string.equals("D") ? n2 : n2 * -1;
            }
        });
    }
}

