/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree.util;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.util.Iterator;
import java.util.Map;

abstract class JrsValueCursor
extends JsonStreamContext {
    protected final JrsValueCursor _parent;
    protected String _currentName;
    protected Object _currentValue;

    public JrsValueCursor(int n, JrsValueCursor jrsValueCursor) {
        this._type = n;
        this._index = -1;
        this._parent = jrsValueCursor;
    }

    public final JrsValueCursor getParent() {
        return this._parent;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }

    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public abstract JsonToken endToken();

    public abstract JrsValue currentNode();

    public abstract boolean currentHasChildren();

    public final JrsValueCursor iterateChildren() {
        JrsValue jrsValue = this.currentNode();
        if (jrsValue == null) {
            throw new IllegalStateException("No current node");
        }
        if (jrsValue.isArray()) {
            return new ArrayCursor((JrsArray)jrsValue, this);
        }
        if (jrsValue.isObject()) {
            return new ObjectCursor((JrsObject)jrsValue, this);
        }
        throw new IllegalStateException("Current node of type " + jrsValue.getClass().getName());
    }

    protected static final class ArrayCursor
    extends JrsValueCursor {
        protected Iterator<JrsValue> _contents;
        protected JrsValue _currentNode;

        public ArrayCursor(JrsArray jrsArray, JrsValueCursor jrsValueCursor) {
            super(1, jrsValueCursor);
            this._contents = jrsArray.elements();
        }

        @Override
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return this._currentNode.asToken();
        }

        @Override
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public JrsValue currentNode() {
            return this._currentNode;
        }

        @Override
        public boolean currentHasChildren() {
            return this.currentNode().size() > 0;
        }
    }

    protected static final class ObjectCursor
    extends JrsValueCursor {
        protected Iterator<Map.Entry<String, JrsValue>> _contents;
        protected Map.Entry<String, JrsValue> _current;
        protected boolean _needEntry;

        public ObjectCursor(JrsValue jrsValue, JrsValueCursor jrsValueCursor) {
            super(2, jrsValueCursor);
            this._contents = ((JrsObject)jrsValue).fields();
            this._needEntry = true;
        }

        @Override
        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._currentName = null;
                    this._current = null;
                    return null;
                }
                this._needEntry = false;
                this._current = this._contents.next();
                this._currentName = this._current == null ? null : this._current.getKey();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return this._current.getValue().asToken();
        }

        @Override
        public JsonToken nextValue() {
            JsonToken jsonToken = this.nextToken();
            if (jsonToken == JsonToken.FIELD_NAME) {
                jsonToken = this.nextToken();
            }
            return jsonToken;
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        @Override
        public JrsValue currentNode() {
            return this._current == null ? null : this._current.getValue();
        }

        @Override
        public boolean currentHasChildren() {
            return this.currentNode().size() > 0;
        }
    }

    protected static final class RootCursor
    extends JrsValueCursor {
        protected JrsValue _node;
        protected boolean _done = false;

        public RootCursor(JrsValue jrsValue, JrsValueCursor jrsValueCursor) {
            super(0, jrsValueCursor);
            this._node = jrsValue;
        }

        @Override
        public void overrideCurrentName(String string) {
        }

        @Override
        public JsonToken nextToken() {
            if (!this._done) {
                this._done = true;
                return this._node.asToken();
            }
            this._node = null;
            return null;
        }

        @Override
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        public JsonToken endToken() {
            return null;
        }

        @Override
        public JrsValue currentNode() {
            return this._node;
        }

        @Override
        public boolean currentHasChildren() {
            return false;
        }
    }
}

