/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.DiscoveredDependable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.jdeveloper.resource.JProjectArb;

class SelectDependenciesPanel
extends DefaultTraversablePanel {
    static final String DEPENDENCIES_KEY = SelectDependenciesPanel.class.getName() + ".dependencies.key";
    static final String DEPENDENCIES_INSERTION_POINT = SelectDependenciesPanel.class.getName() + ".dependencies.insertion.point";
    static final String PROJECT_URL_KEY = SelectDependenciesPanel.class.getName() + ".project.url";
    static final String DEPENDABLE_UNDER_EDIT_KEY = SelectDependenciesPanel.class.getName() + ".active.dependable";
    static final String WORKSPACE_KEY = "Application";
    private static final String HELP_TOPIC_ID = "f1_idededitdependencies_html";
    private final JWrappedLabel _headerText = new JWrappedLabel();
    private final JMutableTreeNode _rootNode = new JMutableTreeNode();
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
    private final CustomJTree _depsTree = new CustomJTree((TreeModel)this._treeModel);
    private final JLabel _treeLabel = new JLabel();
    private final SearchField _searchField = new SearchField();
    private final EventAdapter _eventAdapter = new EventAdapter();
    private final List<DependableCellData> _expanded = new ArrayList<DependableCellData>();
    private transient Workspace _curWorkspace;
    private transient URL _curProjectURL;
    private transient Node _curProject;
    private transient List<Dependable> _deps;
    private transient int _depsInsertionPoint;
    private transient Dependable _dependableUnderEdit;
    private JEWTDialog _dialog;

    public SelectDependenciesPanel() {
        try {
            this.jbInit();
            this.setHelpID(HELP_TOPIC_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setInstructionText(String text) {
        this._headerText.setText(text);
    }

    void setDialog(JEWTDialog dialog) {
        this._dialog = dialog;
    }

    private void jbInit() throws Exception {
        this.setDefaultTitle(JProjectArb.getString((int)178));
        this._headerText.setForeground(Colors.HINT_TEXT);
        this._headerText.setText(JProjectArb.getString((int)188));
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._depsTree, (String)JProjectArb.getString((int)189));
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.setPrompt(JProjectArb.getString((int)190));
        this._searchField.addSearchListener((SearchListener)this._eventAdapter);
        this._depsTree.getSelectionModel().setSelectionMode(1);
        this._depsTree.setRootVisible(false);
        this._depsTree.setShowsRootHandles(true);
        this._depsTree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this._depsTree.setScrollsOnExpand(true);
        this._depsTree.setPropagateCheckState(false);
        this._depsTree.addTreeExpansionListener((TreeExpansionListener)this._eventAdapter);
        this._depsTree.addTreeCellCheckedListener((TreeCellCheckedListener)this._eventAdapter);
        JScrollPane treeScroller = new JScrollPane((Component)this._depsTree);
        ComponentWithTitlebar titledTree = new ComponentWithTitlebar((JComponent)treeScroller, this._treeLabel, null);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._headerText, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this._searchField, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 150, 0));
        this.add((Component)titledTree, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        this._curProjectURL = (URL)dataContext.get(PROJECT_URL_KEY);
        Assert.check((this._curProjectURL != null ? 1 : 0) != 0, (String)"The URL of the active project must be stored in the namespace");
        this._curProject = NodeFactory.find((URL)this._curProjectURL);
        this._curWorkspace = (Workspace)dataContext.get(WORKSPACE_KEY);
        Assert.check((this._curWorkspace != null ? 1 : 0) != 0, (String)"The active workspacemust be stored in the namespace");
        this._deps = (List)dataContext.get(DEPENDENCIES_KEY);
        Assert.check((this._deps != null ? 1 : 0) != 0, (String)"The List of Dependable objects must be stored in the namespace");
        this._depsInsertionPoint = dataContext.contains(DEPENDENCIES_INSERTION_POINT) ? (Integer)dataContext.get(DEPENDENCIES_INSERTION_POINT) : this._deps.size() - 1;
        if (dataContext.contains(DEPENDABLE_UNDER_EDIT_KEY)) {
            this._dependableUnderEdit = (Dependable)dataContext.get(DEPENDABLE_UNDER_EDIT_KEY);
        }
        this.initTree(this._curWorkspace);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.put(DEPENDENCIES_KEY, this._deps);
        dataContext.put(DEPENDENCIES_INSERTION_POINT, (Object)this._depsInsertionPoint);
    }

    private void initTree(Workspace workspace) {
        Enumeration descendents = this.getExpandedProjects();
        this._rootNode.removeAllChildren();
        this._rootNode.setUserObject((Object)workspace);
        this.addChildren((Element)workspace, this._rootNode);
        this._treeModel.setRoot((TreeNode)this._rootNode);
        this._searchField.clear();
        this.restoreOrInitExpandedTreeNodes(this._rootNode, descendents != null, this._expanded);
    }

    private Enumeration getExpandedProjects() {
        Enumeration descendents = this._depsTree.getExpandedDescendants(new TreePath(this._rootNode));
        if (descendents != null) {
            while (descendents.hasMoreElements()) {
                JMutableTreeNode node;
                DependableCellData cellData;
                TreePath tp = (TreePath)descendents.nextElement();
                if (tp.getPathCount() == 1 || this._expanded.contains((Object)(cellData = (DependableCellData)((Object)(node = (JMutableTreeNode)tp.getLastPathComponent()).getUserObject())))) continue;
                this._expanded.add(cellData);
            }
        }
        return descendents;
    }

    private void restoreOrInitExpandedTreeNodes(JMutableTreeNode parent, boolean restore, List<DependableCellData> expandedElems) {
        Enumeration iter = parent.children();
        while (iter.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)iter.nextElement();
            DependableCellData cellData = (DependableCellData)((Object)node.getUserObject());
            Element elem = cellData.getElement();
            if (elem != null) {
                boolean shouldExpand = false;
                if (restore && expandedElems.contains((Object)cellData)) {
                    shouldExpand = true;
                } else if (!restore && this.maybeSelected(elem)) {
                    shouldExpand = true;
                    if (!expandedElems.contains((Object)cellData)) {
                        expandedElems.add(cellData);
                    }
                }
                if (shouldExpand) {
                    TreePath path = new TreePath(node.getPath());
                    this._depsTree.expandPath(path);
                }
            }
            if (node.isLeaf()) continue;
            this.restoreOrInitExpandedTreeNodes(node, restore, expandedElems);
        }
    }

    private boolean depsListContains(Dependable dependable) {
        return SelectDependenciesPanel.listContainsDependable(dependable, this._deps);
    }

    private static boolean listContainsDependable(Dependable dependable, List<Dependable> list) {
        if (list != null && list.size() > 0) {
            for (Dependable d : list) {
                if (!d.equals(dependable)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean maybeSelected(Element elem) {
        if (this._deps != null && !this._deps.isEmpty()) {
            for (Dependable next : this._deps) {
                if (next == null || elem != next.getSource() && elem != next.getSourceOwner()) continue;
                return true;
            }
        }
        return false;
    }

    protected void addChildren(Element parentElement, JMutableTreeNode parentTreeNode) {
        DependableFactory.Params params = new DependableFactory.Params(Context.newIdeContext());
        params.setElement(parentElement);
        params.getContext().setWorkspace(this._curWorkspace);
        params.setOrigin((Element)this._curProject);
        Iterable dds = DependableFactory.getInstance().discover(params.getContext());
        DependableCellData first = null;
        HashSet<DependableCellData> dcds = new HashSet<DependableCellData>();
        for (DiscoveredDependable dd : dds) {
            boolean isDep = this.depsListContains(dd.getDependable());
            DependableCellData dcd = DependableCellData.create(dd, isDep);
            if (first == null && parentElement instanceof Project) {
                dcd.setPriority(true);
                first = dcd;
                continue;
            }
            dcds.add(dcd);
        }
        ArrayList<DependableCellData> ldcds = new ArrayList<DependableCellData>(dcds);
        Collections.sort(ldcds, DependableCellData.SORT_COMPARTOR);
        if (first != null) {
            ldcds.add(0, first);
        }
        for (DependableCellData dcd : ldcds) {
            JMutableTreeNode depNode = this.createNode(dcd);
            parentTreeNode.add((MutableTreeNode)depNode);
        }
    }

    private JMutableTreeNode createNode(DependableCellData dcd) {
        return new DepNode(dcd){

            public boolean isLeaf() {
                if (!this.allowsChildren) {
                    return true;
                }
                return SelectDependenciesPanel.getDependableForNode(this) != null;
            }
        };
    }

    private void setDialogOkButtonEnabled(boolean enabled) {
        if (this._dialog != null) {
            this._dialog.setOKButtonEnabled(enabled);
        }
    }

    private static Dependable getDependableForNode(JMutableTreeNode node) {
        return ((DependableCellData)((Object)node.getUserObject())).dd.getDependable();
    }

    private class EventAdapter
    implements SearchListener,
    TreeCellCheckedListener,
    TreeExpansionListener {
        private EventAdapter() {
        }

        public void searchPerformed(SearchEvent se) {
            String text = se.isFromClear() ? "" : se.getSearchText();
            this.applyTreeFilter(text);
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private void applyTreeFilter(String filterText) {
            if ((filterText == null || filterText.length() == 0) && SelectDependenciesPanel.this._treeModel != null) {
                SelectDependenciesPanel.this._depsTree.setModel((TreeModel)SelectDependenciesPanel.this._treeModel);
                SelectDependenciesPanel.this.restoreOrInitExpandedTreeNodes(SelectDependenciesPanel.this._rootNode, true, SelectDependenciesPanel.this._expanded);
            } else {
                JMutableTreeNode newRoot = this.cloneTree(SelectDependenciesPanel.this._rootNode);
                SearchMatcher matcher = SearchMatcher.getSubstringMatcher((CharSequence)filterText, (boolean)true);
                this.filter(newRoot, matcher);
                SelectDependenciesPanel.this._depsTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)newRoot));
                SelectDependenciesPanel.this.restoreOrInitExpandedTreeNodes(newRoot, true, SelectDependenciesPanel.this._expanded);
                for (int i = 0; i < SelectDependenciesPanel.this._depsTree.getRowCount(); ++i) {
                    TreePath path = SelectDependenciesPanel.this._depsTree.getPathForRow(i);
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!matcher.matches((CharSequence)String.valueOf(last))) continue;
                    SelectDependenciesPanel.this._depsTree.setSelectionRow(i);
                    SelectDependenciesPanel.this._depsTree.scrollPathToVisible(path);
                    return;
                }
                if (SelectDependenciesPanel.this._depsTree.getRowCount() > 0) {
                    SelectDependenciesPanel.this._depsTree.setSelectionRow(0);
                }
            }
        }

        private JMutableTreeNode cloneTree(JMutableTreeNode root) {
            if (root == null) {
                return null;
            }
            Object userObject = root.getUserObject();
            DepNode newRoot = null;
            if (userObject instanceof Workspace) {
                newRoot = new DepNode(root.getModel(), root.getAllowsChildren());
                newRoot.setUserObject(root.getUserObject());
            } else if (userObject instanceof DependableCellData) {
                newRoot = SelectDependenciesPanel.this.createNode((DependableCellData)((Object)root.getUserObject()));
            } else {
                return null;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                JMutableTreeNode newChild = this.cloneTree(child);
                if (newChild == null) continue;
                newRoot.add((MutableTreeNode)newChild);
            }
            if (root instanceof DepNode) {
                newRoot.setChildrenLoaded(((DepNode)root).isChildrenLoaded());
            }
            return newRoot;
        }

        private void filter(JMutableTreeNode root, SearchMatcher matcher) {
            ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                if (matcher.matches((CharSequence)String.valueOf(child.getModel().getText()))) continue;
                nodesToRemove.add(i);
            }
            int removedCount = 0;
            Iterator iterator = nodesToRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                root.remove(i - removedCount++);
            }
        }

        public void cellChecked(TreeCellCheckedEvent e) {
            JMutableTreeNode node = (JMutableTreeNode)e.getSource();
            try {
                Dependable dep = SelectDependenciesPanel.getDependableForNode(node);
                this.handleCellChecked(node, dep);
                SelectDependenciesPanel.this.setDialogOkButtonEnabled(true);
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }

        public void cellUnchecked(TreeCellCheckedEvent e) {
            if (SelectDependenciesPanel.this._deps != null) {
                JMutableTreeNode node = (JMutableTreeNode)e.getSource();
                this.removeDependency(node);
                SelectDependenciesPanel.this.setDialogOkButtonEnabled(true);
            }
        }

        private void removeDependency(JMutableTreeNode node) {
            Dependable d = SelectDependenciesPanel.getDependableForNode(node);
            for (int i = 0; i < SelectDependenciesPanel.this._deps.size(); ++i) {
                Dependable dep = SelectDependenciesPanel.this._deps.get(i);
                if (!dep.equals(d)) continue;
                SelectDependenciesPanel.this._deps.remove(i);
                if (i > SelectDependenciesPanel.this._depsInsertionPoint) break;
                --SelectDependenciesPanel.this._depsInsertionPoint;
                break;
            }
        }

        private void handleCellChecked(JMutableTreeNode node, Dependable dep) {
            if (SelectDependenciesPanel.this._deps == null) {
                SelectDependenciesPanel.this._deps = new ArrayList<Dependable>();
                SelectDependenciesPanel.this._deps.add(dep);
                SelectDependenciesPanel.this._depsInsertionPoint = 0;
            } else if (!SelectDependenciesPanel.this.depsListContains(dep)) {
                boolean removed = false;
                if (this.isPriorityNode(node)) {
                    removed = this.unselectOthers((JMutableTreeNode)node.getParent());
                } else {
                    JMutableTreeNode pn = this.findPriorityNode(node);
                    if (pn != null && pn.getModel().getCheckBoxState().booleanValue()) {
                        pn.getModel().setCheckBoxState(false);
                        this.removeDependency(pn);
                        removed = true;
                    }
                }
                if (removed) {
                    this.maybeConfirm();
                }
                ++SelectDependenciesPanel.this._depsInsertionPoint;
                if (SelectDependenciesPanel.this._depsInsertionPoint == SelectDependenciesPanel.this._deps.size()) {
                    SelectDependenciesPanel.this._deps.add(dep);
                } else {
                    SelectDependenciesPanel.this._deps.add(SelectDependenciesPanel.this._depsInsertionPoint, dep);
                }
            }
        }

        private boolean isPriorityNode(JMutableTreeNode node) {
            return ((DependableCellData)((Object)node.getUserObject())).isPriority();
        }

        private boolean unselectOthers(JMutableTreeNode node) {
            boolean ret = false;
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                JMutableTreeNode c = (JMutableTreeNode)e.nextElement();
                if (this.isPriorityNode(c)) continue;
                if (c.getModel().getCheckBoxState().booleanValue()) {
                    c.getModel().setCheckBoxState(false);
                    this.removeDependency(c);
                    ret = true;
                }
                if (!this.unselectOthers(c)) continue;
                ret = true;
            }
            return ret;
        }

        private JMutableTreeNode findPriorityNode(JMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            JMutableTreeNode parent = (JMutableTreeNode)node.getParent();
            if (parent == null) {
                return null;
            }
            Enumeration e = parent.children();
            while (e.hasMoreElements()) {
                JMutableTreeNode c = (JMutableTreeNode)e.nextElement();
                if (!this.isPriorityNode(c)) continue;
                return c;
            }
            return this.findPriorityNode(parent);
        }

        private void maybeConfirm() {
            MessageDialog.optionalInformation((String)"confirm-mutually-exclusive-dependencies", (Component)((Object)SelectDependenciesPanel.this), (Object)JProjectArb.getString((int)193), (String)JProjectArb.getString((int)192), null);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            final JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
            if (path.getPathCount() > 1 && !node.isLeaf()) {
                if (!SelectDependenciesPanel.this._expanded.contains(node.getUserObject())) {
                    SelectDependenciesPanel.this._expanded.add((DependableCellData)((Object)node.getUserObject()));
                }
                final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                waitCursor.show();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DepNode dn;
                        if (node.getChildCount() <= 1 && !(dn = (DepNode)node).isChildrenLoaded()) {
                            SelectDependenciesPanel.this.addChildren(((DependableCellData)((Object)node.getUserObject())).getElement(), node);
                            dn.setChildrenLoaded(true);
                            ((DefaultTreeModel)SelectDependenciesPanel.this._depsTree.getModel()).reload((TreeNode)node);
                        }
                        waitCursor.hide();
                    }
                });
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
            if (SelectDependenciesPanel.this._expanded.contains(node.getUserObject())) {
                SelectDependenciesPanel.this._expanded.remove(node.getUserObject());
            }
        }
    }

    private static class DependableCellData
    extends JTreeCellData {
        private static final Collator COLLATOR = Collator.getInstance();
        public static final Comparator<DependableCellData> SORT_COMPARTOR = new Comparator<DependableCellData>(){

            @Override
            public int compare(DependableCellData o1, DependableCellData o2) {
                return COLLATOR.compare(o1.getText(), o2.getText());
            }
        };
        private final DiscoveredDependable dd;
        private boolean priority = false;

        DependableCellData(DiscoveredDependable dd, Icon icon, String text, boolean hasCheckBox) {
            super(icon, text, hasCheckBox);
            this.dd = dd;
        }

        DependableCellData(DiscoveredDependable dd, Icon icon, String text, boolean hasCheckBox, TriStateBoolean checkBoxState) {
            super(icon, text, hasCheckBox, checkBoxState);
            this.dd = dd;
        }

        void setPriority(boolean priority) {
            this.priority = priority;
        }

        boolean isPriority() {
            return this.priority;
        }

        Element getElement() {
            return DependableCellData.getNotNull(this.dd.getElement(), this.dd.getDependable() != null ? this.dd.getDependable().getSource() : null);
        }

        static DependableCellData create(DiscoveredDependable dd, boolean isSelected) {
            Element e = dd.getElement();
            Element ed = dd.getDependable() != null ? dd.getDependable().getSource() : null;
            e = DependableCellData.getNotNull(e, ed);
            ed = DependableCellData.getNotNull(ed, e);
            Dependable d = dd.getDependable();
            if (d == null) {
                return new DependableCellData(dd, DependableCellData.computeIcon(e, ed), DependableCellData.computeText(e, ed), false);
            }
            TriStateBoolean state = TriStateBoolean.getState((boolean)isSelected);
            return new DependableCellData(dd, DependableCellData.computeIcon(e, ed), DependableCellData.computeText(e, ed), true, state);
        }

        private static String computeText(Element e1, Element e2) {
            return DependableCellData.getNotNull(e1, e2) == null ? "Invalid" : DependableCellData.getNotNull(e1.getShortLabel(), e2.getShortLabel());
        }

        private static Icon computeIcon(Element e1, Element e2) {
            return DependableCellData.getNotNull(e1, e2) == null ? null : DependableCellData.getNotNull(e1.getIcon(), e2.getIcon());
        }

        private static <T> T getNotNull(T o1, T o2) {
            return o1 == null ? o2 : o1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DependableCellData other = (DependableCellData)((Object)obj);
            Dependable tDep = this.dd.getDependable();
            Dependable oDep = other.dd.getDependable();
            if (tDep == null ? oDep != null : !tDep.equals(oDep)) {
                return false;
            }
            Element tEl = this.getElement();
            Element oEl = other.getElement();
            return !(tEl == null ? oEl != null : !tEl.equals(oEl));
        }

        public int hashCode() {
            Dependable d = this.dd.getDependable();
            Element e = this.getElement();
            int hash = 7;
            hash = 19 * hash + (d != null ? d.hashCode() : 0);
            hash = 19 * hash + (e != null ? e.hashCode() : 0);
            return hash;
        }
    }

    private static class DepNode
    extends JMutableTreeNode {
        private boolean _childrenLoaded = false;

        DepNode(JTreeCellData treeCellData, boolean allowsChildren) {
            super(treeCellData, allowsChildren);
        }

        DepNode(JTreeCellData treeCellData) {
            super(treeCellData);
        }

        void setChildrenLoaded(boolean loaded) {
            this._childrenLoaded = loaded;
        }

        boolean isChildrenLoaded() {
            return this._childrenLoaded;
        }
    }
}

