/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class QueryOptionHintProvider
extends HintProvider {
    private static final Map<HintProvider.HintToken, Enum> TOKENS;
    private static final HintProvider.HintToken USE_NL_TOKEN;
    private static final HintProvider.HintToken USE_HASH_TOKEN;
    private static final HintProvider.HintToken NO_INDEX_TOKEN;
    private static final QueryOptionHintProvider instance;

    private QueryOptionHintProvider() {
    }

    public static QueryOptionHintProvider getInstance() {
        return instance;
    }

    @Override
    protected Map<HintProvider.HintToken, Enum> getParsableTokens() {
        return TOKENS;
    }

    @Override
    protected void parseToken(HintProvider.HintContext hintContext, HintProvider.HintToken hintToken, Enum enum_) throws ParseException {
        Hint.QueryOption queryOption = Hint.QueryOption.valueOf(enum_.name());
        assert (queryOption != null) : "Invalid type, '" + enum_ + "' for token '" + hintToken.getValue() + "'";
        String string = hintToken.getValue();
        List<HintProvider.HintToken> list = hintToken.getChildren();
        if (list.isEmpty()) {
            hintContext.getHintBuilder().addQueryOption(queryOption);
        } else {
            hintContext.getHintBuilder().addQueryOption(queryOption, list.get(0).getValue());
        }
        QueryOptionHintProvider.postProcess(hintContext, queryOption);
    }

    private static void postProcess(HintProvider.HintContext hintContext, Hint.QueryOption queryOption) {
        Hint.SQLHint sQLHint = null;
        switch (queryOption) {
            case NO_LINK_INDEX: {
                int n = hintContext.getSPARQLBGP().getNumTriples();
                if (n < 1) break;
                for (int i = 0; i < n; ++i) {
                    hintContext.getHintBuilder().addSQLHint(Hint.SQLHint.createSingleArgHint(NO_INDEX_TOKEN.getValue(), Hint.SQLHint.Arg.createStaticArgument("T" + i), false));
                }
                break;
            }
            case NO_VALUE_INDEX: {
                Set<String> set = QueryOptionHintProvider.getValueJoinVariables(hintContext);
                if (set.isEmpty()) break;
                LinkedList linkedList = new LinkedList();
                for (String string : set) {
                    hintContext.getHintBuilder().addSQLHint(Hint.SQLHint.createSingleArgHint(NO_INDEX_TOKEN.getValue(), Hint.SQLHint.Arg.createVariableArgument(string), false));
                }
                break;
            }
            case ALL_LINK_NL: 
            case ALL_LINK_HASH: {
                int n = hintContext.getSPARQLBGP().getNumTriples();
                boolean bl = QueryOptionHintProvider.searchForLinkJoin(hintContext.getTokenTree(), new HashSet<String>());
                if (bl || n <= 1) break;
                LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
                for (int i = 0; i < n; ++i) {
                    linkedList.add(Hint.SQLHint.Arg.createStaticArgument("T" + i));
                }
                switch (queryOption) {
                    case ALL_LINK_NL: {
                        sQLHint = Hint.SQLHint.createMultiArgHint(USE_NL_TOKEN.getValue(), linkedList);
                        break;
                    }
                    case ALL_LINK_HASH: {
                        sQLHint = Hint.SQLHint.createMultiArgHint(USE_HASH_TOKEN.getValue(), linkedList);
                    }
                }
                hintContext.getHintBuilder().addSQLHint(sQLHint);
                break;
            }
            case ALL_LOCAL_VALUE_NL: 
            case ALL_LOCAL_VALUE_HASH: {
                Set<String> set = QueryOptionHintProvider.getValueJoinVariables(hintContext);
                boolean bl = QueryOptionHintProvider.searchForValueJoin(hintContext.getTokenTree(), set);
                if (bl || set.isEmpty()) break;
                LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
                for (String string : set) {
                    linkedList.add(Hint.SQLHint.Arg.createVariableArgument(string));
                }
                switch (queryOption) {
                    case ALL_LOCAL_VALUE_NL: {
                        sQLHint = Hint.SQLHint.createMultiArgHint(USE_NL_TOKEN.getValue(), linkedList);
                        break;
                    }
                    case ALL_LOCAL_VALUE_HASH: {
                        sQLHint = Hint.SQLHint.createMultiArgHint(USE_HASH_TOKEN.getValue(), linkedList);
                    }
                }
                hintContext.getHintBuilder().addSQLHint(sQLHint);
                break;
            }
        }
    }

    private static boolean searchForLinkJoin(List<HintProvider.HintToken> list, Set<String> set) {
        RegexTokenComparator regexTokenComparator = new RegexTokenComparator(RegexTokenComparator.T_ALIAS_PATTERN, set);
        return QueryOptionHintProvider.searchTree(USE_NL_TOKEN, list, regexTokenComparator) || QueryOptionHintProvider.searchTree(USE_HASH_TOKEN, list, regexTokenComparator);
    }

    private static boolean searchForValueJoin(List<HintProvider.HintToken> list, Set<String> set) {
        RegexTokenComparator regexTokenComparator = new RegexTokenComparator(RegexTokenComparator.V_ALIAS_PATTERN, set);
        return QueryOptionHintProvider.searchTree(USE_NL_TOKEN, list, regexTokenComparator) || QueryOptionHintProvider.searchTree(USE_HASH_TOKEN, list, regexTokenComparator);
    }

    private static Set<String> getValueJoinVariables(HintProvider.HintContext hintContext) {
        SPARQLBGP sPARQLBGP = hintContext.getSPARQLBGP();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(sPARQLBGP.getProjectVars());
        for (Filter object : sPARQLBGP.getFilters()) {
            hashSet2.addAll(object.getfJoinVars());
        }
        for (String string : sPARQLBGP.getBGPVars()) {
            if (!hashSet2.contains(string.toUpperCase())) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    static {
        USE_NL_TOKEN = HintProvider.HintToken.createToken("USE_NL");
        USE_HASH_TOKEN = HintProvider.HintToken.createToken("USE_HASH");
        NO_INDEX_TOKEN = HintProvider.HintToken.createToken("NO_INDEX");
        HashMap<HintProvider.HintToken, Hint.QueryOption> hashMap = new HashMap<HintProvider.HintToken, Hint.QueryOption>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MAX_PP_DEPTH");
        for (Hint.QueryOption queryOption : Hint.QueryOption.values()) {
            HintProvider.HintToken hintToken = hashSet.contains(queryOption.getName()) ? HintProvider.HintToken.createToken(queryOption.getName()) : HintProvider.HintToken.createNoArgToken(queryOption.getName());
            hashMap.put(hintToken, queryOption);
        }
        TOKENS = Collections.unmodifiableMap(hashMap);
        instance = new QueryOptionHintProvider();
    }

    private static final class RegexTokenComparator
    implements Comparator<HintProvider.HintToken> {
        public static final Pattern T_ALIAS_PATTERN = Pattern.compile("^t-?[0-9]+$", 2);
        public static final Pattern V_ALIAS_PATTERN = Pattern.compile("^v-?[0-9]+$", 2);
        private static final Pattern VAR_PATTERN = Pattern.compile("^\\?(\\S+)$");
        private final Pattern regex;
        private final Set<String> vars;

        public RegexTokenComparator(Pattern pattern, Set<String> set) {
            this.regex = pattern;
            this.vars = set;
        }

        @Override
        public int compare(HintProvider.HintToken hintToken, HintProvider.HintToken hintToken2) {
            if (hintToken.getValue().equalsIgnoreCase(hintToken2.getValue())) {
                if (hintToken.getChildren().isEmpty() && hintToken2.getChildren().isEmpty()) {
                    return -1;
                }
                if (!hintToken.getChildren().isEmpty() && !hintToken2.getChildren().isEmpty()) {
                    return -1;
                }
                List<HintProvider.HintToken> list = hintToken.getChildren();
                if (list.isEmpty()) {
                    list = hintToken2.getChildren();
                }
                for (HintProvider.HintToken hintToken3 : list) {
                    if (hintToken3.getType() != HintProvider.HintToken.Type.NO_ARG) continue;
                    if (this.regex.matcher(hintToken3.getValue()).matches()) {
                        return 0;
                    }
                    Matcher matcher = VAR_PATTERN.matcher(hintToken3.getValue());
                    if (!matcher.matches() || !this.vars.contains(matcher.group(1).toUpperCase())) continue;
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }
}

