/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.IDResolver;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.GUIDConverter;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

@Concealed
public class Utility {
    @Concealed
    public static final int START_UNDERLINE = 2;
    @Concealed
    public static final int SPACE_UNDERLINE = 2;
    public static final char SC_TRUE = '1';
    public static final char SC_FALSE = '0';

    public static Vector cloneVector(Vector v) throws CloneNotSupportedException {
        Vector<Object> newV = new Vector<Object>();
        Enumeration vlist = v.elements();
        while (vlist.hasMoreElements()) {
            Object element = vlist.nextElement();
            if (element != null) {
                if (!(element instanceof VectorClone)) continue;
                newV.addElement(((VectorClone)element).clone());
                continue;
            }
            newV.addElement(element);
        }
        return newV;
    }

    public static Hashtable cloneHashtable(Hashtable t) throws CloneNotSupportedException {
        Hashtable newtable = new Hashtable();
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            VectorClone value = (VectorClone)t.get(key);
            newtable.put(key, value.clone());
        }
        return newtable;
    }

    public static boolean compareLists(List list1, List list2) {
        Object[] objArray1 = list1 == null ? null : list1.toArray(new Object[0]);
        Object[] objArray2 = list2 == null ? null : list2.toArray(new Object[0]);
        return Utility.compareArrays(objArray1, objArray2);
    }

    public static boolean compareArrays(Object[] list1, Object[] list2) {
        return Arrays.equals(list1, list2);
    }

    public static boolean compareHashtables(Hashtable table1, Hashtable table2) {
        if (table1 == null && table2 == null) {
            return true;
        }
        if (table1 == null || table2 == null) {
            return false;
        }
        if (table1.size() != table2.size()) {
            return false;
        }
        Enumeration keys1 = table1.keys();
        Enumeration keys2 = table2.keys();
        while (keys1.hasMoreElements()) {
            Object obj2;
            Object key2;
            Object key1 = keys1.nextElement();
            if (!Utility.compareObj(key1, key2 = keys2.nextElement())) {
                return false;
            }
            Object obj1 = table1.get(key1);
            if (Utility.compareObj(obj1, obj2 = table2.get(key2))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareHashMap(HashMap table1, HashMap table2) {
        if (table1 == null && table2 == null) {
            return true;
        }
        if (table1 == null || table2 == null) {
            return false;
        }
        if (table1.size() != table2.size()) {
            return false;
        }
        Set keySet1 = table1.keySet();
        Set keySet2 = table2.keySet();
        Iterator keys1 = keySet1.iterator();
        Iterator keys2 = keySet2.iterator();
        while (keys1.hasNext()) {
            Object obj2;
            Object key2;
            Object key1 = keys1.next();
            if (!Utility.compareObj(key1, key2 = keys2.next())) {
                return false;
            }
            Object obj1 = table1.get(key1);
            if (Utility.compareObj(obj1, obj2 = table2.get(key2))) continue;
            return false;
        }
        return true;
    }

    public static Object[][] arraycopy(Object[][] src) {
        if (src == null) {
            return null;
        }
        int[] dims = new int[]{src.length, 5};
        Object[][] dest = (Object[][])Array.newInstance(src.getClass().getComponentType().getComponentType(), dims);
        Object temp = null;
        for (int i = 0; i < src.length; ++i) {
            dest[i] = Utility.arraycopy(src[i]);
        }
        return dest;
    }

    public static Object[] arraycopy(Object[] src) {
        if (src == null) {
            return null;
        }
        Object[] dest = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length);
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    @Concealed
    public static Object[] copyVectorToArray(Vector vector) {
        return Utility.copyVectorToArray(vector, null);
    }

    @Concealed
    public static Object[] copyVectorToArray(Vector vObjects, Class classBase) {
        if (vObjects == null || vObjects.size() == 0) {
            return null;
        }
        Enumeration enumeration = vObjects.elements();
        Object object = null;
        while (enumeration.hasMoreElements() && object == null) {
            object = enumeration.nextElement();
        }
        if (object == null) {
            return null;
        }
        if (classBase == null) {
            classBase = object.getClass();
        }
        Object[] objectArray = (Object[])Array.newInstance(classBase, vObjects.size());
        vObjects.copyInto(objectArray);
        return objectArray;
    }

    public static Vector copyArrayToVector(Object[] array) {
        if (array == null) {
            return new Vector();
        }
        Vector<Object> ret = new Vector<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            ret.addElement(array[i]);
        }
        return ret;
    }

    public static boolean compareVectors(Vector v1, Vector v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        Object element1 = null;
        Object element2 = null;
        for (int element = 0; element < v1.size(); ++element) {
            element1 = v1.elementAt(element);
            element2 = v2.elementAt(element);
            if (element1 == null) {
                if (element2 == null) continue;
                return false;
            }
            if (element1.equals(element2)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareLists(String[] list1, String[] list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < list1.length; ++i) {
            for (int j = 0; j < list2.length; ++j) {
                if (!list2[j].equals(list1[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            found = false;
        }
        return true;
    }

    public static boolean compareListsExact(String[] list1, String[] list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        for (int i = 0; i < list1.length; ++i) {
            if (!(list1[i] == null ? list2[i] != null : !list1[i].equals(list2[i]))) continue;
            return false;
        }
        return true;
    }

    public static String[] combineArrays(String[] one, String[] two) {
        int i;
        if (one == null && two == null) {
            return null;
        }
        int oneCount = one != null ? one.length : 0;
        int twoCount = two != null ? two.length : 0;
        String[] combined = new String[oneCount + twoCount];
        int pos = 0;
        for (i = 0; i < oneCount; ++i) {
            combined[pos++] = one[i];
        }
        for (i = 0; i < twoCount; ++i) {
            combined[pos++] = two[i];
        }
        return combined;
    }

    public static String[] flattenArray(String[][] twod) {
        int i;
        if (twod == null) {
            return null;
        }
        int count = 0;
        for (i = 0; i < twod.length; ++i) {
            count += twod[i].length;
        }
        String[] ret = new String[count];
        count = 0;
        for (i = 0; i < twod.length; ++i) {
            for (int j = 0; j < twod[i].length; ++j) {
                ret[count++] = twod[i][j];
            }
        }
        return ret;
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return null;
        }
        Object obj = null;
        if (array.getClass().isArray()) {
            Object tmp = "{";
            int length = Array.getLength(array);
            for (int i = 0; i < length - 1; ++i) {
                obj = Array.get(array, i);
                tmp = obj.getClass().isArray() ? (String)tmp + Utility.arrayToString(obj) + "," : (String)tmp + obj + ",";
            }
            if (length > 0) {
                obj = Array.get(array, length - 1);
                tmp = obj.getClass().isArray() ? (String)tmp + Utility.arrayToString(obj) : (String)tmp + obj;
            }
            tmp = (String)tmp + "}";
            return tmp;
        }
        return array.toString();
    }

    public static String ObjectToString(Object object) {
        int nValue = 0;
        Object string = new String();
        byte[] buffer = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            buffer = byteArrayOutputStream.toByteArray();
            for (int nIndex = 0; nIndex < buffer.length; ++nIndex) {
                nValue = buffer[nIndex];
                if (nValue < 0) {
                    nValue += 256;
                } else if (nValue >= 0 && nValue < 16) {
                    string = (String)string + "0";
                }
                string = (String)string + Integer.toHexString(nValue);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return string;
    }

    public static Object StringToObject(String string) {
        int nBufferIndex = 0;
        byte[] buffer = new byte[string.length() / 2];
        Object object = null;
        int nIndex = 0;
        while (nIndex < string.length()) {
            int nValue = Integer.parseInt(string.substring(nIndex, nIndex + 2), 16);
            Integer Int = nValue;
            buffer[nBufferIndex] = Int.byteValue();
            nIndex += 2;
            ++nBufferIndex;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return object;
    }

    @Concealed
    public static Object instantiateClass(String strClassName, Class[] classConstructorArgs, Object[] objectArgs, ErrorHandler eh) {
        Object objectOutput;
        block11: {
            objectOutput = null;
            Class classOutput = null;
            if (strClassName != null) {
                block9: {
                    try {
                        classOutput = Utility.loadClass(strClassName);
                    }
                    catch (ClassNotFoundException e) {
                        if (eh == null) break block9;
                        eh.error(e, "Utility", "instantiateClass");
                    }
                }
                if (classOutput != null && classConstructorArgs != null) {
                    Constructor constructor;
                    block10: {
                        constructor = null;
                        try {
                            constructor = classOutput.getConstructor(classConstructorArgs);
                        }
                        catch (NoSuchMethodException e) {
                            if (eh == null) break block10;
                            eh.error(e, "Utility", "instantiateClass");
                        }
                    }
                    if (constructor != null && objectArgs != null) {
                        try {
                            objectOutput = constructor.newInstance(objectArgs);
                        }
                        catch (Exception e) {
                            if (eh == null) break block11;
                            eh.error(e, "Utility", "instantiateClass");
                        }
                    }
                }
            }
        }
        return objectOutput;
    }

    @Concealed
    public static boolean contains(Vector vector1, Vector vector2) {
        if (vector1.size() < vector2.size()) {
            return false;
        }
        Enumeration e = vector2.elements();
        while (e.hasMoreElements()) {
            if (vector1.contains(e.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static boolean compareObj(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        if (obj2 != null) {
            return obj2.equals(obj1);
        }
        return true;
    }

    public static int compareAsNumbers(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return Utility.compareAsNumbers(obj2, 0) >= 0 ? 1 : -1;
        }
        if (obj2 == null) {
            return Utility.compareAsNumbers(obj1, 0) >= 0 ? 1 : -1;
        }
        if (obj1.getClass().isAssignableFrom(obj2.getClass()) && obj1 instanceof Comparable) {
            return ((Comparable)obj1).compareTo(obj2);
        }
        if (obj1 instanceof Number && obj2 instanceof Number) {
            Number n1 = (Number)obj1;
            Number n2 = (Number)obj2;
            if (n1 instanceof Long || n2 instanceof Long || n1 instanceof BigInteger || n2 instanceof BigInteger || n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
                return new BigDecimal(n1.toString()).compareTo(new BigDecimal(n2.toString()));
            }
            return Double.compare(n1.doubleValue(), n2.doubleValue());
        }
        return 0;
    }

    @Concealed
    public static int compareXMLVersions(String ver1, String ver2) {
        int[] version1 = Utility._convertXMLVersionToIntArray(ver1);
        int[] version2 = Utility._convertXMLVersionToIntArray(ver2);
        for (int i = 0; i < version1.length; ++i) {
            if (version2.length < i + 1) {
                return 1;
            }
            if (version1[i] < version2[i]) {
                return -1;
            }
            if (version1[i] <= version2[i]) continue;
            return 1;
        }
        if (version1.length == version2.length) {
            return 0;
        }
        return -1;
    }

    private static int[] _convertXMLVersionToIntArray(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        String token = null;
        int tokenCount = st.countTokens();
        int[] versionArray = new int[tokenCount];
        int i = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            Integer n = null;
            try {
                n = Integer.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                n = 0;
            }
            versionArray[i++] = n;
        }
        return versionArray;
    }

    @Concealed
    public static String escapeStateString(String str, char[] escapeChars, char[] replaceChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        int escapeCount = escapeChars.length;
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            boolean charProcessed = false;
            if (ch == escapeChar) {
                buffer.append(escapeChar);
                buffer.append(0);
                charProcessed = true;
            } else {
                for (int j = 0; j < escapeCount; ++j) {
                    if (ch == escapeChars[j]) {
                        buffer.append(escapeChar);
                        buffer.append(j + 1);
                        charProcessed = true;
                        break;
                    }
                    if (replaceChars == null || ch != replaceChars[j]) continue;
                    buffer.append(escapeChars[j]);
                    charProcessed = true;
                    break;
                }
            }
            if (charProcessed) continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    @Concealed
    public static String unescapeStateString(String str, char[] escapeChars, char[] replaceChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        int escapeCharsCount = escapeChars.length;
        StringBuffer buffer = new StringBuffer(length);
        for (int count = 0; count < length; ++count) {
            char ch = str.charAt(count);
            if (ch == escapeChar && ++count < length) {
                char nextCh = str.charAt(count);
                if (!Character.isDigit(nextCh)) continue;
                int index = Character.digit(nextCh, 10);
                if (index == 0) {
                    buffer.append(escapeChar);
                    continue;
                }
                if (index > escapeCharsCount) continue;
                buffer.append(escapeChars[index - 1]);
                continue;
            }
            boolean charProcessed = false;
            if (replaceChars != null) {
                for (int j = 0; j < escapeCharsCount; ++j) {
                    if (ch != escapeChars[j]) continue;
                    buffer.append(replaceChars[j]);
                    charProcessed = true;
                    break;
                }
            }
            if (charProcessed) continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    @Concealed
    public static void setDependentID(XMLContext context, Vector ids, boolean onlyIfMeasureDim, String dim) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        IDResolver resolver = null;
        String measDimName = Utility.getMeasureDimName(context);
        if (onlyIfMeasureDim && dim != null && !dim.equals(measDimName)) {
            return;
        }
        resolver = Utility.getIDResolver(context);
        if (resolver == null) {
            return;
        }
        String id = null;
        Enumeration idsEnum = ids.elements();
        while (idsEnum.hasMoreElements()) {
            id = (String)idsEnum.nextElement();
            if (id == null) continue;
            resolver.setDependentID(id);
        }
    }

    @Concealed
    public static Vector getDependentID(XMLContext context, Vector ids, boolean onlyIfMeasureDim, String dim) {
        IDResolver resolver = null;
        String measDimName = Utility.getMeasureDimName(context);
        if (onlyIfMeasureDim && dim != null && !dim.equals(measDimName)) {
            return ids;
        }
        resolver = Utility.getIDResolver(context);
        if (ids == null) {
            return null;
        }
        Vector<String> retIDs = new Vector<String>();
        String id = null;
        GUIDConverter converter = null;
        if (Utility.getMigrationFlag(context) != null) {
            converter = Utility.getGUIDConverter(context);
        }
        Enumeration idsEnum = ids.elements();
        while (idsEnum.hasMoreElements()) {
            id = (String)idsEnum.nextElement();
            if (id != null) {
                String oldID = id;
                if (converter != null) {
                    try {
                        String tempID = oldID;
                        id = converter.getGUIDForPath(tempID, true, "PSR");
                    }
                    catch (NamingException e) {
                        id = null;
                    }
                } else if (resolver != null) {
                    id = resolver.getDependentID(oldID);
                }
                if (id == null || id.equals("invalid id")) {
                    retIDs.addElement(oldID);
                    continue;
                }
                retIDs.addElement(id);
                continue;
            }
            retIDs.addElement(id);
        }
        return retIDs;
    }

    @Concealed
    public static String getMeasureDimName(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (String)scope.getObject("MeasDimName");
        }
        return null;
    }

    @Concealed
    public static IDResolver getIDResolver(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (IDResolver)scope.getObject("PersistableIDResolver");
        }
        return null;
    }

    @Concealed
    public static Object getMigrationFlag(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return scope.getObject("migration");
        }
        return null;
    }

    @Concealed
    public static GUIDConverter getGUIDConverter(XMLContext context) {
        ObjectScope scope;
        if (context != null && (scope = context.getScope()) != null) {
            return (GUIDConverter)scope.getObject("full_path_to_guid_converter");
        }
        return null;
    }

    public static boolean compareVersionStrings(String version1, String version2) {
        if (version2 == null) {
            return true;
        }
        if (version1 == null) {
            return false;
        }
        int verPos1 = 0;
        int verPos2 = 0;
        do {
            int num2;
            int num1;
            if ((num1 = Utility._getNextVersionNumber(version1, verPos1)) > (num2 = Utility._getNextVersionNumber(version2, verPos2))) {
                return true;
            }
            if (num2 > num1) {
                return false;
            }
            verPos1 = version1.indexOf(".", verPos1) + 1;
            verPos2 = version2.indexOf(".", verPos2) + 1;
        } while (verPos1 > 0 && verPos1 <= version1.length() && verPos2 > 0 && verPos2 <= version2.length());
        return verPos1 > 0 && verPos1 <= version1.length();
    }

    private static int _getNextVersionNumber(String version, int start) {
        if (start >= version.length()) {
            return -1;
        }
        int sepPos = version.indexOf(".", start);
        String num = null;
        num = sepPos == -1 ? version.substring(start) : version.substring(start, sepPos);
        return Integer.parseInt(num);
    }

    @Concealed
    public static Class loadClass(String a_classname) throws ClassNotFoundException {
        Class<?> bClass = null;
        if (a_classname == null) {
            return null;
        }
        try {
            bClass = Class.forName(a_classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (bClass == null) {
            bClass = Class.forName(a_classname);
        }
        return bClass;
    }

    public static char getBooleanAsChar(boolean value) {
        return value ? (char)'1' : '0';
    }

    public static boolean getValueAsBoolean(PropertyNode node) {
        return node.getValueAsCharacter() == '1';
    }

    public static boolean isDateType(Object obj) {
        return obj instanceof DATE || obj instanceof java.util.Date || obj instanceof TIMESTAMP || obj instanceof Timestamp || obj instanceof Date;
    }

    public static boolean isJavaNumberType(Object obj) {
        return obj instanceof Number || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte || obj instanceof Short;
    }

    public static boolean isJavaClassNumberType(Class cl) {
        return cl.equals(Number.class) || cl.equals(Integer.class) || cl.equals(Long.class) || cl.equals(Float.class) || cl.equals(Double.class) || cl.equals(BigDecimal.class) || cl.equals(BigInteger.class) || cl.equals(Byte.class) || cl.equals(Short.class);
    }

    public static boolean isJboNumberType(Object obj) {
        return obj instanceof NUMBER;
    }

    public static boolean isJboClassNumberType(Class cl) {
        return cl.getName().equals("oracle.jbo.domain.Number");
    }

    public static boolean isStringType(Object obj) {
        return obj instanceof String;
    }

    public static Object getJavaValue(Object value) {
        if (value != null) {
            Class javaClass = null;
            if (Utility.isDateType(value)) {
                if (value instanceof DATE) {
                    return ((DATE)value).dateValue();
                }
                if (value instanceof TIMESTAMP) {
                    try {
                        return ((TIMESTAMP)value).dateValue();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                javaClass = java.util.Date.class;
            } else {
                if (Utility.isJavaNumberType(value)) {
                    return value;
                }
                if (Utility.isJboNumberType(value)) {
                    return Utility.getNativeObject((NUMBER)value);
                }
                javaClass = Utility.isStringType(value) ? String.class : String.class;
            }
            if (javaClass != null) {
                try {
                    Method tf = Class.forName("oracle.jbo.domain.TypeFactory").getMethod("getInstance", Class.class, Object.class);
                    Object javaValue = tf.invoke(null, javaClass, value);
                    return javaValue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private static Object getNativeObject(NUMBER n) {
        long l;
        double d = n.doubleValue();
        if (d == (double)(l = Math.round(d))) {
            return l;
        }
        return d;
    }

    public static Object checkAndConvertJBOTimestamp(Object value) {
        if (value instanceof TIMESTAMP) {
            try {
                return ((TIMESTAMP)value).dateValue();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static Object checkAndConvertJBODate(Object value) {
        if (value instanceof DATE) {
            return Utility.getJavaValue(value);
        }
        return null;
    }

    public static Object checkAndConvertJBONumber(Object value) {
        if (Utility.isJboNumberType(value)) {
            return Utility.getNativeObject((NUMBER)value);
        }
        return null;
    }

    @Concealed
    public static class PropertyType {
        protected static final String DATE = "date";
        protected static final String INTEGER = "integer";
        protected static final String LONG = "long";
        protected static final String DOUBLE = "double";
        protected static final String FLOAT = "float";
        protected static final String BOOLEAN = "boolean";
        protected static final String STRING = "string";

        public static void storeData(BaseObjectNode node, Object data, String memberPropertyName, String typePropertyName) {
            String strData = null;
            String type = PropertyType.getType(data);
            if (data instanceof java.util.Date) {
                long longDate = ((java.util.Date)data).getTime();
                data = longDate;
            }
            strData = data.toString();
            node.addProperty(memberPropertyName, strData);
            node.addProperty(typePropertyName, type);
        }

        public static Object retrieveData(BaseObjectNode node, String memberPropertyName, String typePropertyName) throws NoSuchPropertyException {
            String type = node.getPropertyValueAsString(typePropertyName);
            String data = node.getPropertyValueAsString(memberPropertyName);
            return PropertyType.getData(data, type);
        }

        public static Object getData(String data, String type) {
            if (type == null) {
                return data;
            }
            if (type.equals(STRING)) {
                return data;
            }
            if (type.equals(DATE)) {
                return new java.util.Date(Long.parseLong(data));
            }
            if (type.equals(INTEGER)) {
                return Integer.valueOf(data);
            }
            if (type.equals(LONG)) {
                return Long.valueOf(data);
            }
            if (type.equals(FLOAT)) {
                return Float.valueOf(data);
            }
            if (type.equals(DOUBLE)) {
                return Double.valueOf(data);
            }
            if (type.equals(BOOLEAN)) {
                return Boolean.valueOf(data);
            }
            return data;
        }

        public static String getType(Object data) {
            if (data instanceof java.util.Date) {
                return DATE;
            }
            if (data instanceof Integer) {
                return INTEGER;
            }
            if (data instanceof Double) {
                return DOUBLE;
            }
            if (data instanceof Float) {
                return FLOAT;
            }
            if (data instanceof Boolean) {
                return BOOLEAN;
            }
            if (data instanceof Long) {
                return LONG;
            }
            if (data instanceof String) {
                return STRING;
            }
            return null;
        }
    }
}

