/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_logging_off;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;

public class has_logging_off_for_partitions
extends has_logging_off {
    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("TABLE_OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        super.prepare(exeCtx);
        if (!this.isSkipExecution()) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "P.TABLE_OWNER");
            String sqlQuery = "SELECT  P.TABLE_OWNER, P.TABLE_NAME, P.PARTITION_NAME, P.TABLESPACE_NAME  FROM SYS.DBA_TAB_PARTITIONS P, SYS.DBA_TABLESPACES S " + whereClause + "  AND NVL(P.LOGGING,       (CASE S.LOGGING         WHEN 'LOGGING' THEN 'YES'         WHEN 'NOLOGGING' THEN 'NO'         ELSE NULL        END)     ) = 'NO'   AND P.TABLESPACE_NAME = S.TABLESPACE_NAME   AND NOT NVL(S.FORCE_LOGGING, 'NO') = 'YES'  ORDER BY 1,2,3";
            this.setSqlQuery(sqlQuery);
        }
    }
}

