/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.IOException;
import java.util.Arrays;

public class has_java_objects
extends FilterableCheck
implements Fixable {
    public has_java_objects() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeColumn("OBJECT_TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if ("VALID".equalsIgnoreCase(exeCtx.getAnalysisProperty(TargetInstanceProp.JAVAVM_STATUS.getKey(), "NOPE"))) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_JAVA_STATUS_VALID", this.getName()), CheckResult.PASS);
        } else {
            String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
            String hasJavaObjectsSql = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE, STATUS FROM SYS.DBA_OBJECTS " + whereClause + " AND OBJECT_TYPE IN ('JAVA CLASS', 'JAVA RESOURCES', 'JAVA DATA') ORDER BY 1, 2";
            this.setSqlQuery(hasJavaObjectsSql);
        }
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "enable_javavm";
        Fixup.Locus locus = Fixup.Locus.target;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("enable_javavm", locus, parentFolderPath).restartRequired(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

