/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Stack;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.json.JSONParser;
import oracle.dbtools.json.JSONTokenImpl;
import oracle.dbtools.json.Readers;
import oracle.dbtools.plugin.api.json.JSONToken;

final class JSONParserImpl {
    private JSONToken.Type previous = null;
    private final PushbackReader r;
    private final Stack<JSONToken.Type> scope = new Stack();
    private static final char[] PUSH_BACK = new char[1];
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final String TRUE = "true";

    JSONParserImpl(Reader r) {
        this.r = new PushbackReader(r);
    }

    JSONToken next() {
        JSONToken event = null;
        try {
            if (this.previous == null) {
                event = this.objectOrArray(this.r);
            } else if (this.previous == JSONToken.Type.START_OBJECT) {
                event = this.nameOrEndObject(this.r);
            } else if (this.previous == JSONToken.Type.START_ARRAY) {
                event = this.valueOrEndArray(this.r);
            } else if (this.previous == JSONToken.Type.PROPERTY_NAME) {
                int c = this.read(this.r);
                event = this.value(c, this.r);
            } else {
                event = this.valueOrEndArrayOrNameOrEndObjectOrEndDocument(this.r);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.previous = event != null ? event.type() : null;
        if (JSONToken.Type.START_OBJECT == this.previous || JSONToken.Type.START_ARRAY == this.previous) {
            this.scope.push(this.previous);
        } else if (JSONToken.Type.END_OBJECT == this.previous || JSONToken.Type.END_ARRAY == this.previous) {
            this.scope.pop();
        }
        return event;
    }

    private int delimiters(Reader r, int c) throws IOException {
        if (this.previous == JSONToken.Type.STRING_VALUE || this.previous == JSONToken.Type.NUMERIC_VALUE || this.previous == JSONToken.Type.BOOLEAN_VALUE || this.previous == JSONToken.Type.NULL_VALUE || this.previous == JSONToken.Type.END_OBJECT || this.previous == JSONToken.Type.END_ARRAY) {
            if (c != 44) {
                throw JSONParser.error("" + (char)c, ",");
            }
            c = this.read(r);
        } else if (this.previous == JSONToken.Type.PROPERTY_NAME) {
            if (c != 58) {
                throw JSONParser.error("" + (char)c, ":");
            }
            c = this.read(r);
        }
        return c;
    }

    private boolean inArray() {
        if (!this.scope.isEmpty()) {
            return this.scope.peek() == JSONToken.Type.START_ARRAY;
        }
        return false;
    }

    private boolean inObject() {
        if (!this.scope.isEmpty()) {
            return this.scope.peek() == JSONToken.Type.START_OBJECT;
        }
        return false;
    }

    private void literalMatches(CharSequence literal, char first, Reader r) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append(first);
        for (int i = 1; i < literal.length(); ++i) {
            int c = r.read();
            if (c == -1) {
                this.valueError("EOF");
            }
            char ch = (char)c;
            b.append(ch);
            if (ch == literal.charAt(i)) continue;
            this.valueError(b);
        }
    }

    private JSONToken nameOrEndObject(Reader r) throws IOException {
        JSONToken event = null;
        int c = this.read(r);
        while (event == null && c != -1) {
            if (c == 125) {
                event = JSONTokenImpl.endObject();
                continue;
            }
            if ((c = this.delimiters(r, c)) == 34) {
                event = this.readString(JSONToken.Type.PROPERTY_NAME, r);
                continue;
            }
            throw JSONParser.error("" + (char)c, "}", "\"");
        }
        return event;
    }

    private JSONToken objectOrArray(Reader r) throws IOException {
        JSONToken event = null;
        int c = this.read(r);
        while (event == null && c != -1) {
            char ch = (char)c;
            if (ch == '{') {
                event = JSONTokenImpl.startObject();
                continue;
            }
            if (ch == '[') {
                event = JSONTokenImpl.startArray();
                continue;
            }
            throw JSONParser.error("" + ch, "{", "[");
        }
        if (event == null) {
            throw JSONParser.eof("{", "[");
        }
        return event;
    }

    private void push(int c) throws IOException {
        JSONParserImpl.PUSH_BACK[0] = (char)c;
        this.r.unread(PUSH_BACK);
    }

    private int read(Reader r) throws IOException {
        int c = r.read();
        char ch = (char)c;
        while (c != -1 && Character.isWhitespace(ch)) {
            c = r.read();
            ch = (char)c;
        }
        return c;
    }

    private JSONToken readFalse(Reader r) throws IOException {
        this.literalMatches(FALSE, 'f', r);
        return JSONTokenImpl.falseValue();
    }

    private JSONToken readNull(Reader r) throws IOException {
        this.literalMatches(NULL, 'n', r);
        return JSONTokenImpl.nullValue();
    }

    private JSONToken readNumber(char first, Reader r) throws IOException {
        JSONToken event = null;
        StringBuilder b = new StringBuilder();
        b.append(first);
        int c = r.read();
        while (event == null && c != -1) {
            b.append((char)c);
            if (PrimitiveTypes.isNumeric((CharSequence)b)) {
                c = r.read();
                continue;
            }
            this.push(c);
            b.deleteCharAt(b.length() - 1);
            String text = b.toString();
            event = JSONTokenImpl.numericValue(new BigDecimal(text));
        }
        return event;
    }

    private JSONToken readString(JSONToken.Type type, Reader r) throws IOException {
        Object event = null;
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int c = r.read();
        while (event == null && c != -1) {
            char ch = (char)c;
            if (!escaped && ch == '\\') {
                escaped = true;
            } else if (escaped) {
                switch (ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        b.append(ch);
                        break;
                    }
                    case 'b': {
                        b.append('\b');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'u': {
                        char[] hex = new char[4];
                        int n = Readers.read(r, hex);
                        if (n < 4) {
                            throw JSONParser.error("\\u" + new String(hex), "\\unnnn where n is a hexadecimal digit");
                        }
                        int i = Integer.parseInt(new String(hex), 16);
                        b.append((char)i);
                        break;
                    }
                    default: {
                        throw JSONParser.error("\\" + ch, "\\\"", "\\\\", "\\/", "\\b", "\\f", "\\n", "\\r", "\\t", "\\unnnn where n is a hexadecimal digit");
                    }
                }
                escaped = false;
            } else {
                if (ch == '\"') {
                    return type == JSONToken.Type.STRING_VALUE ? JSONTokenImpl.stringValue(b) : JSONTokenImpl.propertyName(b);
                }
                b.append(ch);
            }
            c = r.read();
        }
        throw JSONParser.eof("\"");
    }

    private JSONToken readTrue(Reader r) throws IOException {
        this.literalMatches(TRUE, 't', r);
        return JSONTokenImpl.trueValue();
    }

    private JSONToken value(int first, Reader r) throws IOException {
        JSONToken event = null;
        int c = first;
        if (c != -1) {
            char ch = (char)(c = this.delimiters(r, c));
            if (ch == '{') {
                event = JSONTokenImpl.startObject();
            } else if (ch == '[') {
                event = JSONTokenImpl.startArray();
            } else if (ch == '\"') {
                event = this.readString(JSONToken.Type.STRING_VALUE, r);
            } else if (ch == '-' || Character.isDigit(ch)) {
                event = this.readNumber(ch, r);
            } else if (ch == 't') {
                event = this.readTrue(r);
            } else if (ch == 'f') {
                event = this.readFalse(r);
            } else if (ch == 'n') {
                event = this.readNull(r);
            } else {
                throw this.valueError("" + ch);
            }
        }
        if (event == null) {
            throw this.valueError("EOF");
        }
        return event;
    }

    private IllegalStateException valueError(CharSequence actual) {
        return JSONParser.error(actual, "{", "[", "\"", "number", TRUE, FALSE, NULL);
    }

    private JSONToken valueOrEndArray(Reader r) throws IOException {
        JSONToken event = null;
        int c = this.read(r);
        while (event == null && c != -1) {
            if (c == 93) {
                event = JSONTokenImpl.endArray();
                continue;
            }
            event = this.value(c, r);
        }
        if (event == null) {
            throw JSONParser.eof("]");
        }
        return event;
    }

    private JSONToken valueOrEndArrayOrNameOrEndObjectOrEndDocument(Reader r) throws IOException {
        Object event = null;
        event = this.inArray() ? this.valueOrEndArray(r) : (this.inObject() ? this.nameOrEndObject(r) : null);
        return event;
    }
}

