/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class KeyGenParamsArchOpt
extends PKIArchiveOptionRegControl {
    private byte[] keyGenParams;

    public KeyGenParamsArchOpt() {
    }

    public KeyGenParamsArchOpt(byte[] keyGenParams) {
        this();
        this.keyGenParams = keyGenParams;
    }

    public KeyGenParamsArchOpt(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public byte[] getKeyGenParams() {
        this.decodeValue();
        return this.keyGenParams;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue(ASN1Utils.addImplicitTag((ASN1Object)new ASN1OctetString(this.keyGenParams), (int)1));
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                PushbackInputStream pis = new PushbackInputStream(Utils.toStream((Streamable)this.getValue()));
                int ch = pis.read();
                int tag = ch & 0x1F;
                if (tag != 1) {
                    throw new ASN1FormatException("Unexpected keyGenParameters tag: " + tag);
                }
                pis.unread((ch & 0) + 4);
                this.keyGenParams = ASN1OctetString.inputValue((InputStream)pis);
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

