/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cmp.CertifiedKeyPair;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.cmp.attribute.UTF8PairsRegInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CertResponse
implements ASN1Object {
    private BigInteger certReqID;
    private PKIStatusInfo status;
    private CertifiedKeyPair certKeyPair;
    private UTF8PairsRegInfo rspInfo;
    private transient ASN1Object contents;

    public CertResponse() {
    }

    public CertResponse(PKIStatusInfo status) {
        this.status = status;
    }

    public CertResponse(BigInteger certReqID, PKIStatusInfo status) {
        this.certReqID = certReqID;
        this.status = status;
    }

    public CertResponse(PKIStatusInfo status, CertifiedKeyPair certKeyPair) {
        this.status = status;
        this.certKeyPair = certKeyPair;
    }

    public CertResponse(BigInteger certReqID, PKIStatusInfo status, CertifiedKeyPair certKeyPair) {
        this(certReqID, status);
        this.certKeyPair = certKeyPair;
    }

    public CertResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public BigInteger getCertReqID() {
        return this.certReqID;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.status;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.certKeyPair;
    }

    public void setResponseInfo(UTF8PairsRegInfo rspInfo) {
        this.rspInfo = rspInfo;
        this.update();
    }

    public UTF8PairsRegInfo getResponseInfo() {
        return this.rspInfo;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ certReqID = " + this.certReqID);
        s.append(", status = " + this.status);
        if (this.certKeyPair != null) {
            s.append(", certKeyPair = " + this.certKeyPair);
        }
        if (this.rspInfo != null) {
            s.append(", rspInfo = ");
            Enumeration e = this.rspInfo.names();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                s.append("{ " + name + ", " + this.rspInfo.getValue(name) + " } ");
                if (!e.hasMoreElements()) continue;
                s.append(", ");
            }
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        BigInteger crid = ASN1Integer.inputValue((InputStream)sis);
        this.certReqID = crid.intValue() == -1 ? null : crid;
        this.status = new PKIStatusInfo((InputStream)sis);
        this.certKeyPair = sis.hasMoreData() && sis.getCurrentTag() == 16 ? new CertifiedKeyPair((InputStream)sis) : null;
        this.rspInfo = sis.hasMoreData() && sis.getCurrentTag() == 4 ? new UTF8PairsRegInfo(new ASN1String((InputStream)new UnsyncByteArrayInputStream(ASN1OctetString.inputValue((InputStream)sis)))) : null;
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.certReqID != null) {
                s.addElement((ASN1Object)new ASN1Integer(this.certReqID));
            } else {
                s.addElement((ASN1Object)new ASN1Integer(BigInteger.valueOf(-1L)));
            }
            s.addElement((ASN1Object)this.status);
            if (this.certKeyPair != null) {
                if (this.certKeyPair.getCertificate() != null && (this.status.getStatus() == PKIStatusInfo.Status.REJECTION || this.status.getStatus() == PKIStatusInfo.Status.WAITING || this.status.getFailures() != null)) {
                    throw new StreamableOutputException("Certificate not allowed for status " + this.status);
                }
                s.addElement((ASN1Object)this.certKeyPair);
            }
            if (this.rspInfo != null) {
                if (this.status.getStatus() == PKIStatusInfo.Status.WAITING) {
                    throw new StreamableOutputException("ResponseInfo not allowed for status " + this.status);
                }
                s.addElement((ASN1Object)new ASN1OctetString(Utils.toBytes((Streamable)this.rspInfo.getValue())));
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

