/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericTablePersistentSettings {
    private final Map<String, Object> _map;
    private static final String HIDDEN_COLUMNS = "hiddenColumns";
    private static final int[] DEFAULT_HIDDEN_COLUMNS = new int[0];
    private static final String COLUMN_WIDTHS = "columnWidths";
    private static final int[] DEFAULT_COLUMN_WIDTHS = new int[0];
    private static final String SORTED = "sorted";
    private static final boolean DEFAULT_SORTED = false;
    private static final String SORT_COLUMN = "sortColumn";
    private static final int DEFAULT_SORT_COLUMN = 0;
    private static final String SORT_ASCENDING = "sortAscending";
    private static final boolean DEFAULT_SORT_ASCENDING = true;
    private static final String SORT_COLUMN_POSITIONS = "columnPositions";
    private static final List DEFAULT_COLUMN_POSITIONS = null;

    public GenericTablePersistentSettings() {
        this(new HashMap<String, Object>());
    }

    public GenericTablePersistentSettings(GenericTablePersistentSettings settings) {
        this(new HashMap<String, Object>(settings._map));
    }

    public GenericTablePersistentSettings(Map<String, Object> map) {
        this._map = map;
    }

    public Map<String, Object> toMap() {
        return this._map;
    }

    public int[] getHiddenColumns() {
        return this.getOrDefault(HIDDEN_COLUMNS, DEFAULT_HIDDEN_COLUMNS);
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        this._map.put(HIDDEN_COLUMNS, hiddenColumns);
    }

    public int[] getColumnWidths() {
        return this.getOrDefault(COLUMN_WIDTHS, DEFAULT_COLUMN_WIDTHS);
    }

    public void setColumnWidths(int[] colWidths) {
        this._map.put(COLUMN_WIDTHS, colWidths);
    }

    public boolean isSorted() {
        return this.getOrDefault(SORTED, false);
    }

    public void setSorted(boolean isSorted) {
        this._map.put(SORTED, isSorted);
    }

    public int getSortColumn() {
        return this.getOrDefault(SORT_COLUMN, 0);
    }

    public void setSortColumn(int sortColumn) {
        this._map.put(SORT_COLUMN, sortColumn);
    }

    public boolean isSortAscending() {
        return this.getOrDefault(SORT_ASCENDING, true);
    }

    public void setSortAscending(boolean isAscending) {
        this._map.put(SORT_ASCENDING, isAscending);
    }

    public List getColumnPositions() {
        return this.getOrDefault(SORT_COLUMN_POSITIONS, DEFAULT_COLUMN_POSITIONS);
    }

    public void setColumnPositions(List columnPositions) {
        this._map.put(SORT_COLUMN_POSITIONS, columnPositions);
    }

    private final <T> T getOrDefault(String key, T def) {
        Object o = this._map.get(key);
        return (T)(o != null ? o : def);
    }
}

