/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipRectangle;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ActiveTemplate;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.util.Log;

public class InfoTipHover
implements Hover {
    private final HoverFlavor flavor;
    private final InfoTip infoTip;
    private Rectangle location;
    private final JComponent parent;
    private final List<HoverListener> hoverListeners = new CopyOnWriteArrayList<HoverListener>();
    private boolean showing = false;
    private boolean showRect = false;
    private InfoTipRectangle rectangle = null;
    private final AutoHideMouseListener autoHideMouseListener = new AutoHideMouseListener();
    private HoverTemplate hoverTemplate;
    private boolean enabled = true;
    private final List<JMenu> menus = new ArrayList<JMenu>();
    private static final Log LOG = new Log("hover");
    private boolean isPointOutsideHoverAllowed = false;

    public InfoTipHover(Template template, InfoTipStyles style, JComponent parent, Point location, HoverFlavor flavor) {
        this(template, style, parent, new Rectangle(location), flavor);
    }

    public InfoTipHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location, HoverFlavor flavor) {
        this.flavor = flavor;
        this.location = location;
        this.parent = parent;
        this.infoTip = new InfoTip(null, style);
        this.setContent(template);
    }

    public void setContent(Template template) {
        this.infoTip.setContent(this.wrapActiveTemplate(template));
        this.menus.clear();
        if (template instanceof SingleItemTemplate) {
            this.menus.addAll(((SingleItemTemplate)template).getMenus());
        } else if (template instanceof MultiItemTemplate) {
            for (Template template2 : ((MultiItemTemplate)template).getTemplates()) {
                if (!(template2 instanceof SingleItemTemplate)) continue;
                this.menus.addAll(((SingleItemTemplate)template2).getMenus());
            }
        }
    }

    public InfoTip getInfoTip() {
        return this.infoTip;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.showing && !enabled) {
            this.hideHover();
        }
    }

    public void showHover() {
        if (this.showing || !this.enabled) {
            return;
        }
        HoverEvent he = new HoverEvent((Hover)this, HoverEvent.Type.WILL_SHOW);
        for (HoverListener hl : this.hoverListeners) {
            hl.hoverChange(he);
        }
        this.infoTip.show(this.parent, this.location);
        if (this.showRect) {
            JLayeredPane lp = this.infoTip.getLayeredPane();
            Rectangle layerR = SwingUtilities.convertRectangle(this.parent, this.location, lp);
            this.rectangle = new InfoTipRectangle(lp, layerR);
        }
        this.showing = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.autoHideMouseListener, 32L);
        this.parent.addMouseListener(this.autoHideMouseListener);
        if (this.hoverTemplate != null) {
            this.hoverTemplate.addListener();
        }
    }

    public void hideHover() {
        if (!this.showing) {
            return;
        }
        if (this.rectangle != null) {
            this.rectangle.hide();
        }
        this.infoTip.hide();
        for (JMenu menu : this.menus) {
            menu.getPopupMenu().setVisible(false);
        }
        this.showing = false;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoHideMouseListener);
        this.parent.removeMouseListener(this.autoHideMouseListener);
        if (this.hoverTemplate != null) {
            this.hoverTemplate.removeListener();
        }
        HoverEvent hideEvent = new HoverEvent((Hover)this, HoverEvent.Type.HIDDEN);
        for (HoverListener listener : this.hoverListeners) {
            listener.hoverChange(hideEvent);
        }
    }

    public HoverFlavor getFlavor() {
        return this.flavor;
    }

    public void addHoverListener(HoverListener hoverListener) {
        if (!this.hoverListeners.contains(hoverListener)) {
            this.hoverListeners.add(hoverListener);
        }
    }

    public void removeHoverListener(HoverListener hoverListener) {
        this.hoverListeners.remove(hoverListener);
    }

    public boolean isPointWithinHover(Point p) {
        JComponent tipComponent = this.infoTip.getInfoTipComponent();
        Rectangle tipBounds = tipComponent.getBounds();
        Point tipLocation = tipComponent.getLocation();
        Container tipParent = tipComponent.getParent();
        if (tipParent == null) {
            return false;
        }
        SwingUtilities.convertPointToScreen(tipLocation, tipParent);
        tipBounds.setLocation(tipLocation);
        tipBounds.grow(6, 6);
        Rectangle hoverBounds = new Rectangle(this.location);
        Point hoverLocation = hoverBounds.getLocation();
        SwingUtilities.convertPointToScreen(hoverLocation, this.parent);
        hoverBounds.x = hoverLocation.x;
        hoverBounds.y = hoverLocation.y;
        hoverBounds.grow(3, 3);
        Area area = new Area(tipBounds);
        area.add(new Area(hoverBounds));
        for (JMenu menu : this.menus) {
            if (!menu.isPopupMenuVisible()) continue;
            JPopupMenu popup = menu.getPopupMenu();
            Rectangle popupBounds = popup.getBounds();
            Point popupLocation = popup.getLocation();
            SwingUtilities.convertPointToScreen(popupLocation, popup.getParent());
            popupBounds.setLocation(popupLocation);
            popupBounds.grow(3, 3);
            area.add(new Area(popupBounds));
        }
        if (area.contains(p)) {
            this.isPointOutsideHoverAllowed = false;
            return true;
        }
        return this.isPointOutsideHoverAllowed;
    }

    public boolean shouldHideHover(KeyEvent event) {
        return true;
    }

    public InfoTipOrientation getOrientation() {
        return this.infoTip.getOrientation();
    }

    public void setOrientation(InfoTipOrientation orientation) {
        this.infoTip.setOrientation(orientation);
    }

    public void ensureVisible() {
        this.infoTip.ensureVisible();
        PointerInfo pi = MouseInfo.getPointerInfo();
        if (pi == null) {
            return;
        }
        GraphicsDevice device = pi.getDevice();
        if (device == null) {
            return;
        }
        if (device != this.infoTip.getInfoTipComponent().getGraphicsConfiguration().getDevice()) {
            return;
        }
        Point mouseLoc = pi.getLocation();
        if (mouseLoc == null) {
            return;
        }
        if (!this.isPointWithinHover(mouseLoc)) {
            this.isPointOutsideHoverAllowed = true;
        }
    }

    public void setLocation(Rectangle location) {
        this.location = location;
        if (this.infoTip.isShowing()) {
            this.infoTip.setLocation(location);
        }
    }

    public Rectangle getLocation() {
        return this.location;
    }

    private Template wrapActiveTemplate(Template template) {
        if (template instanceof ActiveTemplate) {
            this.hoverTemplate = new HoverTemplate((ActiveTemplate)template);
            return this.hoverTemplate;
        }
        this.hoverTemplate = null;
        return template;
    }

    public void setShowRectangle(boolean showRect) {
        this.showRect = showRect;
    }

    public boolean getShowRectangle() {
        return this.showRect;
    }

    private class AutoHideMouseListener
    extends MouseAdapter
    implements AWTEventListener {
        private AutoHideMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo == null) {
                    InfoTipHover.this.hideHover();
                    return;
                }
                Point p = pointerInfo.getLocation();
                if (p == null) {
                    InfoTipHover.this.hideHover();
                    return;
                }
                if (InfoTipHover.this.isPointWithinHover(p)) {
                    return;
                }
                InfoTipHover.this.hideHover();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            InfoTipHover.this.hideHover();
        }
    }

    private class HoverTemplate
    implements Template,
    ActionListener {
        private final ActiveTemplate template;

        public HoverTemplate(ActiveTemplate template) {
            this.template = template;
        }

        public void addListener() {
            this.template.addActionListener(this);
        }

        public void removeListener() {
            this.template.removeActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("closeActionCommand".equals(e.getActionCommand())) {
                InfoTipHover.this.hideHover();
            } else if ("closeInfotipCommand".equals(e.getActionCommand())) {
                InfoTipHover.this.hideHover();
            } else if ("sizeChangedCommand".equals(e.getActionCommand())) {
                InfoTipHover.this.ensureVisible();
            }
        }

        @Override
        public JComponent getContent() {
            return this.template.getContent();
        }
    }
}

