/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.completion.CompletionProvider;

public class CompletionPopupHandler {
    private static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("window");
    private List<CompletionProvider> _insightProviders = new ArrayList<CompletionProvider>();
    private boolean _insightActive = false;
    private Timer _timer;
    private JWindow _insightWindow;
    private JList _insightList;
    private JScrollPane _insightScrollPane;
    private Color _insightBackground = DEFAULT_BACKGROUND_COLOR;
    private ListDoubleClickListener _listListener;
    private CompletionProvider _activeProvider;
    private boolean _alignWithField;
    private boolean _widthOfField = true;
    private boolean _widthConstrained;
    private int _visibleRowCount = 8;
    private Window _parentWindow;
    private ComponentListener _parentWindowListener;
    private static final String CANCEL_ACTION = "cancelInsight";
    private static final String COMPLETE_ACTION = "completeInsight";
    private Object[][] _actions = new Object[][]{{"cancelInsight", KeyStroke.getKeyStroke("ESCAPE"), new CancelInsightAction()}, {"completeInsight", KeyStroke.getKeyStroke("ENTER"), new CompleteInsightAction()}};
    private static final int DEFAULT_DELAY = 350;
    private static int _delay = 350;
    public static final String SHOW_INSIGHT_ACTION_NAME = "show_field_insight";
    private boolean _insightLock = false;
    private final JTextComponent _textComponent;
    private Map<Object, Action> _actionMapBackups = new HashMap<Object, Action>();
    private Map<KeyStroke, Object> _inputMapBackups = new HashMap<KeyStroke, Object>();
    private Component _alignComponent;

    public CompletionPopupHandler(JTextComponent textComponent) {
        this._textComponent = textComponent;
        this._alignComponent = this._textComponent;
        DefaultCaret caret = new DefaultCaret();
        caret.setBlinkRate(UIManager.getInt("TextField.caretBlinkRate"));
        this._textComponent.setCaret(caret);
        this._insightList = new JList();
        this._insightList.putClientProperty("DONT_HIDE_COMPONENT_ON_FOCUS_CHANGE", Boolean.TRUE);
        this._insightList.putClientProperty("DONT_SELECT_TEXT_ON_FOCUS_CHANGE", Boolean.TRUE);
        if (_delay >= 0) {
            this._timer = new Timer(_delay, new ActionHandler());
            this._timer.setRepeats(false);
            this._textComponent.addCaretListener(new CaretHandler());
            this._textComponent.getDocument().addDocumentListener(new DocumentHandler());
            this._textComponent.addFocusListener(new FocusHandler());
        }
        this._textComponent.getInputMap(0).put(KeyStroke.getKeyStroke("control pressed SPACE"), SHOW_INSIGHT_ACTION_NAME);
        this._textComponent.getInputMap(0).put(KeyStroke.getKeyStroke("pressed DOWN"), SHOW_INSIGHT_ACTION_NAME);
        this._textComponent.getActionMap().put(SHOW_INSIGHT_ACTION_NAME, new ShowInsightAction());
    }

    public final JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public JComponent getInsightList() {
        return this._insightList;
    }

    public final void acquireInsightLock() {
        this._insightLock = true;
    }

    public final void yieldInsightLock() {
        this._insightLock = false;
    }

    public final Color getCompletionBackground() {
        return this._insightBackground;
    }

    public final void setCompletionBackground(Color insightBackground) {
        this._insightBackground = insightBackground;
    }

    public final void setAlignWithField(boolean isAlignWithField) {
        this._alignWithField = isAlignWithField;
    }

    final void setAlignComponent(Component alignComponent) {
        this._alignComponent = alignComponent;
    }

    public final boolean isAlignWithField() {
        return this._alignWithField;
    }

    public final void setWidthOfField(boolean isWidthOfField) {
        this._widthOfField = isWidthOfField;
    }

    public final boolean isWidthOfField() {
        return this._widthOfField;
    }

    public final void setWidthConstrained(boolean isWidthConstrained) {
        this._widthConstrained = isWidthConstrained;
    }

    public final boolean isWidthConstrained() {
        return this._widthConstrained;
    }

    public final void setVisibleRowCount(int visibleRowCount) {
        if (this._visibleRowCount <= 0) {
            throw new IllegalArgumentException();
        }
        this._visibleRowCount = visibleRowCount;
    }

    public final int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    public final void registerInsightProvider(CompletionProvider provider) {
        this._insightProviders.add(provider);
    }

    public final void unregisterInsightProvider(CompletionProvider provider) {
        this._insightProviders.remove(provider);
    }

    public final boolean isRegisteredInsightProvider(CompletionProvider provider) {
        return this._insightProviders.contains(provider);
    }

    public final void setInsightVisible(boolean isVisible) {
        if (isVisible) {
            this.showInsight();
        } else {
            this.hideInsight();
        }
    }

    public final boolean isInsightVisible() {
        return this._insightActive;
    }

    private CompletionProvider getHandlingProvider() {
        for (CompletionProvider provider : this._insightProviders) {
            if (!provider.handlesInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition())) continue;
            return provider;
        }
        return null;
    }

    private boolean isPopupTriggerChar(char c) {
        for (CompletionProvider provider : this._insightProviders) {
            if (!provider.isAutoPopupChar(c)) continue;
            return true;
        }
        return false;
    }

    private void showInsight() {
        Rectangle caretRect;
        if (this._insightActive || !this._textComponent.isShowing() || !this._textComponent.hasFocus() || !this._alignComponent.isShowing()) {
            return;
        }
        this.stopTimer();
        if (!this._textComponent.isEditable()) {
            return;
        }
        this._parentWindow = SwingUtilities.getWindowAncestor(this._textComponent);
        if (this._parentWindow == null) {
            return;
        }
        int caretOffset = this._textComponent.getCaretPosition();
        try {
            caretRect = this._textComponent.getUI().modelToView(this._textComponent, caretOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        CompletionProvider insightProvider = this.getHandlingProvider();
        if (insightProvider != null) {
            this._insightActive = true;
            Object[] items = insightProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (items == null || items.length == 0) {
                this._insightActive = false;
                return;
            }
            this._activeProvider = insightProvider;
            this._insightList.setModel(new ArrayListModel(items));
            this._insightList.setCellRenderer(insightProvider.getCellRenderer());
            this._insightList.setBackground(this._insightBackground);
            if (items.length < this._visibleRowCount) {
                this._insightList.setVisibleRowCount(items.length);
            } else {
                this._insightList.setVisibleRowCount(this._visibleRowCount);
            }
            this.redirectActions(this._textComponent);
            this._insightScrollPane = new JScrollPane(this._insightList);
            this._insightScrollPane.setBorder(UIManager.getBorder("ToolTip.border"));
            this._insightScrollPane.setHorizontalScrollBarPolicy(31);
            this._insightScrollPane.setMinimumSize(new Dimension(0, 0));
            this._insightWindow = new CompletionWindow(this._parentWindow){};
            JRootPane rootPane = this._insightWindow.getRootPane();
            rootPane.putClientProperty("DONT_HIDE_COMPONENT_ON_FOCUS_CHANGE", Boolean.TRUE);
            rootPane.putClientProperty("DONT_SELECT_TEXT_ON_FOCUS_CHANGE", Boolean.TRUE);
            this._insightWindow.setBackground(this._insightBackground);
            new FocusRedirector(this._insightWindow, this._textComponent);
            if (!CompletionPopupHandler.hasFocusRedirector(this._insightList)) {
                new FocusRedirector(this._insightList, this._textComponent);
            }
            this.setWindowLocation(this._insightWindow, caretRect);
            this._insightScrollPane.validate();
            Dimension d = this.getWindowSize();
            this._insightWindow.setSize(d);
            this._insightWindow.getContentPane().add(this._insightScrollPane);
            this._insightWindow.setVisible(true);
            this._listListener = new ListDoubleClickListener();
            this._insightList.addMouseListener(this._listListener);
            if (this._insightList.getModel().getSize() > 0) {
                this._insightList.setSelectedIndex(0);
            }
            FocusRedirector redirector14Hack = new FocusRedirector(null, this._textComponent);
            SwingUtilities.invokeLater(redirector14Hack);
            this._parentWindowListener = new ComponentListener(){

                private void doit() {
                    CompletionPopupHandler.this._parentWindow.removeComponentListener(this);
                    CompletionPopupHandler.this._parentWindowListener = null;
                    CompletionPopupHandler.this.hideInsight();
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                    this.doit();
                }

                @Override
                public void componentMoved(ComponentEvent ce) {
                    this.doit();
                }

                @Override
                public void componentResized(ComponentEvent ce) {
                    this.doit();
                }

                @Override
                public void componentShown(ComponentEvent ce) {
                }
            };
            this._parentWindow.addComponentListener(this._parentWindowListener);
        }
    }

    private Dimension getWindowSize() {
        if (this._insightScrollPane == null) {
            return null;
        }
        Dimension d = this._insightScrollPane.getPreferredSize();
        if (this._widthOfField) {
            d.width = Math.max(d.width, this._alignComponent.getWidth());
        }
        if (this._widthConstrained) {
            d.width = Math.min(d.width, this._alignComponent.getWidth());
        }
        return d;
    }

    private void setWindowLocation(JWindow window, Rectangle location) {
        int y;
        int x;
        if (this._alignComponent.getParent() instanceof JViewport) {
            this._alignComponent = this._alignComponent.getParent();
        }
        Point comPos = this._alignComponent.getLocationOnScreen();
        if (this._alignWithField) {
            x = comPos.x;
            y = comPos.y + this.getVerticalPopupOffset(this._alignComponent);
        } else {
            location.x += comPos.x;
            location.y += comPos.y;
            x = location.x;
            y = location.y + this.getVerticalPopupOffset(this._alignComponent);
        }
        window.setLocation(x, y);
    }

    protected int getVerticalPopupOffset(Component component) {
        return component.getHeight();
    }

    private void hideInsight() {
        if (this._insightActive) {
            this._activeProvider = null;
            if (this._insightWindow != null) {
                this._insightWindow.dispose();
                this._insightList.removeMouseListener(this._listListener);
                this._listListener = null;
            }
            if (this._parentWindow != null) {
                if (this._parentWindowListener != null) {
                    this._parentWindow.removeComponentListener(this._parentWindowListener);
                    this._parentWindowListener = null;
                }
                this._parentWindow = null;
            }
            this._insightWindow = null;
            this._insightActive = false;
            this.removeActions(this._textComponent);
        }
    }

    private void updateInsight() {
        if (this._insightActive && this._activeProvider != null && this._textComponent.isShowing()) {
            Object[] items = this._activeProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (items != null && items.length > 0) {
                this._insightList.setModel(new ArrayListModel(items));
                if (items.length < this._visibleRowCount) {
                    this._insightList.setVisibleRowCount(items.length);
                } else {
                    this._insightList.setVisibleRowCount(this._visibleRowCount);
                }
                Dimension newSize = this.getWindowSize();
                Dimension oldSize = this._insightWindow.getSize();
                if (!oldSize.equals(newSize)) {
                    int caretOffset = this._textComponent.getCaretPosition();
                    try {
                        Rectangle caretRect = this._textComponent.getUI().modelToView(this._textComponent, caretOffset);
                        this._insightWindow.setSize(newSize);
                        this.setWindowLocation(this._insightWindow, caretRect);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this._insightWindow.validate();
                this._insightList.setSelectedIndex(0);
            } else {
                this.hideInsight();
            }
        }
    }

    private void removeActions(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        for (int i = 0; i < this._actions.length; ++i) {
            Object oldActionId;
            Object actionId = this._actions[i][0];
            KeyStroke keyStroke = (KeyStroke)this._actions[i][1];
            inputMap.remove(keyStroke);
            actionMap.remove(actionId);
            Action oldAction = this._actionMapBackups.get(actionId);
            if (oldAction != null) {
                actionMap.put(actionId, oldAction);
            }
            if ((oldActionId = this._inputMapBackups.get(keyStroke)) == null) continue;
            inputMap.put(keyStroke, oldActionId);
        }
        inputMap.remove(KeyStroke.getKeyStroke("UP"));
        inputMap.remove(KeyStroke.getKeyStroke("DOWN"));
        this._textComponent.getInputMap(0).put(KeyStroke.getKeyStroke("pressed DOWN"), SHOW_INSIGHT_ACTION_NAME);
        this._actionMapBackups.clear();
        this._inputMapBackups.clear();
    }

    private void redirectActions(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        for (int i = 0; i < this._actions.length; ++i) {
            Object actionKey = this._actions[i][0];
            KeyStroke keyStroke = (KeyStroke)this._actions[i][1];
            this._actionMapBackups.put(actionKey, actionMap.get(actionKey));
            this._inputMapBackups.put(keyStroke, inputMap.get(keyStroke));
            inputMap.put(keyStroke, actionKey);
            actionMap.put(actionKey, (Action)this._actions[i][2]);
        }
        inputMap.put(KeyStroke.getKeyStroke("UP"), "selectPreviousRow");
        Action action = this._insightList.getActionMap().get("selectPreviousRow");
        actionMap.put("selectPreviousRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "selectNextRow");
        action = this._insightList.getActionMap().get("selectNextRow");
        actionMap.put("selectNextRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "scrollUp");
        action = this._insightList.getActionMap().get("scrollUp");
        actionMap.put("scrollUp", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "scrollDown");
        action = this._insightList.getActionMap().get("scrollDown");
        actionMap.put("scrollDown", new ActionDelegator(this._insightList, action));
    }

    private void completeInsight() {
        try {
            this._insightLock = true;
            if (this._insightList != null && this._activeProvider != null) {
                this._activeProvider.completeInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition(), this._insightList.getSelectedValue());
            }
        }
        finally {
            this._insightLock = false;
        }
    }

    private void startTimer() {
        this._timer.restart();
    }

    private void stopTimer() {
        this._timer.stop();
    }

    private static boolean hasFocusRedirector(Component c) {
        for (FocusListener l : c.getFocusListeners()) {
            if (!(l instanceof FocusRedirector)) continue;
            return true;
        }
        return false;
    }

    private class CancelInsightAction
    extends AbstractAction {
        private CancelInsightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.this.hideInsight();
        }
    }

    private class CompleteInsightAction
    extends AbstractAction {
        private CompleteInsightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.this.completeInsight();
            CompletionPopupHandler.this.hideInsight();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.this.showInsight();
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            if (CompletionPopupHandler.this._insightActive) {
                CompletionPopupHandler.this.updateInsight();
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (!CompletionPopupHandler.this._insightActive) {
                int offset = de.getOffset();
                if (de.getLength() > 1) {
                    offset += de.getLength() - 1;
                }
                try {
                    char lastChar = de.getDocument().getText(offset, 1).charAt(0);
                    if (CompletionPopupHandler.this.isPopupTriggerChar(lastChar) && !CompletionPopupHandler.this._insightLock) {
                        CompletionPopupHandler.this.startTimer();
                    } else {
                        CompletionPopupHandler.this.stopTimer();
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            CompletionPopupHandler.this.stopTimer();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            CompletionPopupHandler.this.stopTimer();
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent fe) {
        }

        @Override
        public void focusLost(FocusEvent fe) {
            CompletionPopupHandler.this.stopTimer();
            if (!fe.isTemporary()) {
                CompletionPopupHandler.this.hideInsight();
            }
        }
    }

    private class ShowInsightAction
    extends AbstractAction {
        public ShowInsightAction() {
            super(CompletionPopupHandler.SHOW_INSIGHT_ACTION_NAME);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.this.setInsightVisible(true);
        }
    }

    private class ArrayListModel
    extends AbstractListModel {
        Object[] _array;

        public ArrayListModel(Object[] array) {
            this._array = array;
        }

        @Override
        public Object getElementAt(int index) {
            return this._array[index];
        }

        @Override
        public int getSize() {
            return this._array.length;
        }
    }

    private static final class FocusRedirector
    extends FocusAdapter
    implements Runnable {
        private Component component;

        private FocusRedirector(Component window, Component component) {
            this.component = component;
            if (window != null) {
                window.addFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.run();
        }

        @Override
        public void run() {
            this.component.requestFocus();
        }
    }

    private class ListDoubleClickListener
    extends MouseAdapter {
        private ListDoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int index;
            if (me.getButton() == 1 && me.getClickCount() == 2 && (index = CompletionPopupHandler.this._insightList.locationToIndex(me.getPoint())) != -1) {
                CompletionPopupHandler.this.completeInsight();
                CompletionPopupHandler.this.hideInsight();
                CompletionPopupHandler.this._textComponent.requestFocus();
            }
        }
    }

    private class ActionDelegator
    extends AbstractAction {
        private JComponent _component;
        private Action _delegate;

        ActionDelegator(JComponent component, Action delegate) {
            this._component = component;
            this._delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionEvent newEvent = new ActionEvent(this._component, ae.getID(), ae.getActionCommand());
            this._delegate.actionPerformed(newEvent);
        }
    }

    private static class CompletionWindow
    extends JWindow {
        private CompletionWindow(Window _parentWindow) {
            super(_parentWindow);
        }
    }
}

