/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import net.miginfocom.swing.MigLayout;

public final class RoundedBorderComponent {
    public static JComponent createRoundedComponent(JComponent originalComponent) {
        return RoundedBorderComponent.createRoundedComponent(originalComponent, null);
    }

    public static JComponent createRoundedComponent(JComponent originalComponent, Color color) {
        float arc = 8.0f;
        float thickness = 1.0f;
        int i = (int)thickness + (int)arc / 4;
        JLayer<JComponent> layer = new JLayer<JComponent>(originalComponent, new RoundedView(thickness, arc, color));
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.setBorder(BorderFactory.createEmptyBorder(i, i, i, i));
        p.add(layer);
        return p;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setSize(200, 200);
        f.setLocationRelativeTo(null);
        f.getContentPane().setBackground(Color.WHITE);
        f.setDefaultCloseOperation(3);
        f.setLayout((LayoutManager)new MigLayout("ins 20"));
        JComponent c = new JLabel("Label");
        c = RoundedBorderComponent.createRoundedComponent(c);
        f.add((Component)c, "");
        f.setVisible(true);
    }

    private static class RoundedView
    extends LayerUI<JComponent> {
        private Color color = UIManager.getColor("TitledBorder.borderColor");
        private final Stroke stroke;
        private final int arc;
        private final int thickness;

        private RoundedView(float thickness, float arc, Color color) {
            if (color != null) {
                this.color = color;
            }
            this.thickness = (int)thickness;
            this.stroke = new BasicStroke(thickness);
            this.arc = (int)arc;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(this.stroke);
            JComponent view = (JComponent)((JLayer)c).getView();
            int indent = this.thickness / 2;
            if (view.isOpaque()) {
                g2.setColor(view.getBackground());
                g2.fillRoundRect(indent, indent, c.getWidth() - 1 - indent - indent, c.getHeight() - 1 - indent - indent, this.arc, this.arc);
            }
            c.paint(g);
            g2.setColor(this.color);
            g2.drawRoundRect(indent, indent, c.getWidth() - 1 - indent - indent, c.getHeight() - 1 - indent - indent, this.arc, this.arc);
            g2.dispose();
        }
    }
}

