/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.balloon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.balloon.BalloonConstraint;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.templates.BasicTemplate;

@Deprecated
public final class BalloonManager {
    public static final int TTL_ACTION_SUCCESS = 15000;
    public static final int TTL_ACTION_FAILURE = 20000;
    public static final int TTL_OPTIONAL_USER_TASK = 25000;
    private static final Object CP_BALLOON = "oracle.javatools.ui.balloon.balloonClientProperty";
    private static final Object CP_MANAGER = "oracle.javatools.ui.balloon.balloonManager";
    private final JComponent targetComponent;
    private final InfoTip infoTip = new InfoTip();

    private BalloonManager(JComponent targetComponent) {
        this.targetComponent = targetComponent;
    }

    public static BalloonManager forTarget(JComponent target) {
        if (target == null) {
            throw new NullPointerException("targetComponent must not be null");
        }
        BalloonManager mgr = (BalloonManager)target.getClientProperty(CP_MANAGER);
        if (mgr != null) {
            return mgr;
        }
        mgr = new BalloonManager(target);
        target.putClientProperty(CP_MANAGER, mgr);
        return mgr;
    }

    public Balloon balloon() {
        return BalloonManager.balloon(this.targetComponent);
    }

    private static Balloon balloon(JComponent targetComponent) {
        return (Balloon)targetComponent.getClientProperty(CP_BALLOON);
    }

    public void show(final Balloon balloon, int timeToLive) {
        BalloonManager.mustNotBeNull(balloon);
        if (timeToLive < 0) {
            throw new IllegalArgumentException("timeToLive must be >= 0: " + timeToLive);
        }
        if (BalloonManager.timerIsDisabled()) {
            this.show(balloon);
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Timer timer = (Timer)ae.getSource();
                timer.removeActionListener(this);
                timer.stop();
                if (balloon.getParent() == null || BalloonManager.this.targetComponent.getParent() == null) {
                    return;
                }
                BalloonManager.this.hide(balloon);
            }
        };
        Timer t = new Timer(timeToLive, al);
        t.setRepeats(false);
        this.show(balloon);
        t.start();
    }

    private static void mustNotBeNull(Balloon balloon) {
        if (balloon == null) {
            throw new NullPointerException("balloon must not be null");
        }
    }

    private static boolean timerIsDisabled() {
        return Boolean.getBoolean("ide.balloons.disableTimer");
    }

    public void show(Balloon balloon) {
        BalloonManager.mustNotBeNull(balloon);
        if (!this.targetComponent.isVisible()) {
            throw new IllegalStateException("Target must be visible");
        }
        if (this.balloon() != null) {
            throw new IllegalStateException("Balloon is already showing for target component " + this.targetComponent);
        }
        this.targetComponent.putClientProperty(CP_BALLOON, balloon);
        this.maybeInstallCloseButton(balloon);
        this.infoTip.setContent(new BasicTemplate(balloon));
        Rectangle r = new Rectangle(0, 0, this.targetComponent.getWidth(), this.targetComponent.getHeight());
        this.infoTip.show(this.targetComponent, r);
    }

    public void hide(Balloon balloon) {
        this.infoTip.hide();
        this.infoTip.setContent(null);
        this.targetComponent.putClientProperty(CP_BALLOON, null);
    }

    private void maybeInstallCloseButton(Balloon balloon) {
        if (balloon.component(BalloonConstraint.CLOSE_BUTTON) != null) {
            return;
        }
        balloon.add((Component)this.createCloseButton(balloon), (Object)BalloonConstraint.CLOSE_BUTTON);
    }

    private AbstractButton createCloseButton(Balloon balloon) {
        JButton button = new JButton(this.createCloseAction(balloon));
        button.setToolTipText(UIBundle.get("BALLOON_CLOSE"));
        LookAndFeel.installBorder(button, "Balloon.closeButtonBorder");
        button.setIcon(OracleIcons.getIcon((String)"extras/small_close.gif"));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusPainted(false);
        button.setPreferredSize(new Dimension(14, 14));
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        return button;
    }

    private Action createCloseAction(final Balloon balloon) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BalloonManager.this.hide(balloon);
            }
        };
    }
}

