/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public class NotificationDisplayer {
    private static final Icon WARNING_ICON = OracleIcons.getIcon((String)"warning.png");
    private final JToolBar toolBar;
    private final boolean showBalloons;
    private final List<NotificationImpl> notifications = new ArrayList<NotificationImpl>();
    private JButton button;
    private InfoTip balloon;
    private InfoTipHover menu;

    public NotificationDisplayer(JToolBar toolBar, boolean showBalloons) {
        this.toolBar = toolBar;
        this.showBalloons = showBalloons;
    }

    public Notification notify(Priority priority, Icon icon, String title, String description, Action action, boolean showBalloon) {
        return this.notify(priority, icon, title, (JComponent)(showBalloon && this.showBalloons ? new MultiLineLabel(description) : null), (JComponent)new MultiLineLabel(description), action);
    }

    public Notification notify(Priority priority, Icon icon, String title, JComponent balloonDetail, JComponent popupDetail) {
        return this.notify(priority, icon, title, balloonDetail, popupDetail, null);
    }

    private Notification notify(Priority priority, Icon icon, String title, JComponent balloonDetail, JComponent popupDetail, Action action) {
        if (icon == null) {
            icon = WARNING_ICON;
        }
        TemplateFactory balloonTemplate = balloonDetail != null && this.showBalloons ? new TemplateFactory(icon, title, balloonDetail, action) : null;
        TemplateFactory popupTemplate = new TemplateFactory(icon, title, popupDetail, action);
        return this.notify(priority, icon, balloonTemplate, popupTemplate);
    }

    private Notification notify(Priority priority, Icon icon, TemplateFactory balloonTemplate, TemplateFactory popupTemplate) {
        assert (SwingUtilities.isEventDispatchThread());
        NotificationImpl notification = new NotificationImpl(priority, icon, popupTemplate);
        this.notifications.add(notification);
        if (this.button == null) {
            this.button = new JButton();
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationDisplayer.this.showPopupMenu();
                }
            });
            this.toolBar.add(this.button);
            this.toolBar.revalidate();
        }
        this.updateButton();
        if (balloonTemplate != null && !this.isMenuVisible() && !this.isBalloonVisible() && this.isShowing()) {
            this.hideBalloon();
            this.balloon = new InfoTip(balloonTemplate.createTemplate(notification));
            this.balloon.setDisplayTime(25000);
            this.balloon.show(this.button);
        }
        return notification;
    }

    private void updateButton() {
        this.button.setText(String.valueOf(this.notifications.size()));
        this.button.setIcon(Collections.min(this.notifications).icon);
    }

    private void remove(NotificationImpl n) {
        if (this.notifications.remove(n)) {
            this.hideBalloon();
            if (this.notifications.isEmpty()) {
                if (this.button != null) {
                    this.toolBar.remove(this.button);
                    this.toolBar.revalidate();
                    this.button = null;
                }
            } else {
                this.updateButton();
            }
        }
    }

    private void hideBalloon() {
        if (this.balloon != null) {
            this.balloon.hide();
            this.balloon = null;
        }
    }

    private boolean isBalloonVisible() {
        return this.balloon != null && this.balloon.isShowing();
    }

    private boolean isMenuVisible() {
        return this.menu != null && this.menu.getInfoTip().isShowing();
    }

    private boolean isShowing() {
        return this.button != null && this.button.isShowing();
    }

    void showPopupMenu() {
        this.hideBalloon();
        this.hidePopupMenu();
        if (!this.isShowing()) {
            return;
        }
        ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
        for (NotificationImpl n : this.notifications) {
            items.add(n.createTemplate());
        }
        MultiItemTemplate menuTemplate = new MultiItemTemplate(items);
        this.menu = new InfoTipHover((Template)menuTemplate, InfoTipStyles.DEFAULT, (JComponent)this.button, new Rectangle(0, 0, this.button.getWidth(), this.button.getHeight()), HoverFlavor.getFlavor((String)"info"));
        this.menu.showHover();
    }

    void hidePopupMenu() {
        if (this.menu != null) {
            this.menu.hideHover();
            this.menu = null;
        }
    }

    public static enum Priority {
        HIGH,
        NORMAL,
        LOW;

    }

    public static interface Notification {
        public void remove();
    }

    private class TemplateFactory {
        private final Action action;
        private final Icon icon;
        private final String title;
        private final JComponent detail;

        private TemplateFactory(Icon icon, String title, JComponent detail, Action action) {
            this.action = action;
            this.icon = icon;
            this.title = title;
            this.detail = detail;
        }

        private void showDetail(Notification notification) {
            NotificationDisplayer.this.hideBalloon();
            NotificationDisplayer.this.hidePopupMenu();
            notification.remove();
            this.action.actionPerformed(new ActionEvent(notification, 1001, "perform"));
        }

        private ItemTemplate createTemplate(final Notification notification) {
            BalloonTemplate template = new BalloonTemplate();
            template.setTitle(this.icon, this.title);
            template.setContent(this.detail);
            if (this.action != null) {
                final JLabel link = new JLabel();
                link.setText((String)this.action.getValue("Name"));
                link.setIcon((Icon)this.action.getValue("SmallIcon"));
                final Font normal = link.getFont();
                HashMap attributes = new HashMap(normal.getAttributes());
                attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                final Font underlined = normal.deriveFont(attributes);
                link.setBackground(null);
                link.setOpaque(false);
                link.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                link.setForeground(InfoTipStyles.DEFAULT.getHyperLinkTextColor(false));
                link.setEnabled(this.action.isEnabled());
                if (this.action.isEnabled()) {
                    MouseAdapter fixMouseAdapter = new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            link.setFont(underlined);
                            link.setForeground(InfoTipStyles.DEFAULT.getHyperLinkTextColor(true));
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            link.setFont(normal);
                            link.setForeground(InfoTipStyles.DEFAULT.getHyperLinkTextColor(false));
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            TemplateFactory.this.showDetail(notification);
                        }
                    };
                    link.addMouseListener(fixMouseAdapter);
                }
                template.setFooter(link);
                template.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ("closeInfotipCommand".equals(e.getActionCommand())) {
                            notification.remove();
                        } else if ("actionClick".equals(e.getActionCommand())) {
                            TemplateFactory.this.showDetail(notification);
                        }
                    }
                });
            }
            return template;
        }
    }

    private class NotificationImpl
    implements Notification,
    Comparable<NotificationImpl> {
        private final Icon icon;
        private final Priority priority;
        private final TemplateFactory templateFactory;

        private NotificationImpl(Priority priority, Icon icon, TemplateFactory templateFactory) {
            this.priority = priority;
            this.icon = icon;
            this.templateFactory = templateFactory;
        }

        @Override
        public void remove() {
            NotificationDisplayer.this.remove(this);
        }

        @Override
        public int compareTo(NotificationImpl o) {
            return this.priority.compareTo(o.priority);
        }

        private ItemTemplate createTemplate() {
            return this.templateFactory.createTemplate(this);
        }
    }
}

