/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class Attribute
extends XMLElement {
    public Attribute(Element element) throws DOMException {
        super(element);
    }

    public Attribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Attribute(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    protected Element addAttributeValue(Node content, QName type) {
        Document doc = this.getOwnerDocument();
        Element attrVal = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        this.appendChild(attrVal);
        XMLUtils.copyNSPrefix((Element)((Element)this.getNode()), (Element)attrVal);
        Attribute.setXsiType(attrVal, type);
        if (content != null) {
            attrVal.appendChild(content);
        } else {
            String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
            if (prefix == null || prefix.length() < 2) {
                prefix = "xsi";
            }
            attrVal.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", prefix + ":nil", "true");
        }
        return attrVal;
    }

    protected Element addAttributeValue(Node[] content, QName type) {
        Document doc = this.getOwnerDocument();
        Element attrVal = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        this.appendChild(attrVal);
        XMLUtils.copyNSPrefix((Element)((Element)this.getNode()), (Element)attrVal);
        Attribute.setXsiType(attrVal, type);
        if (content != null && content.length != 0) {
            for (int i = 0; i < content.length; ++i) {
                attrVal.appendChild(content[i]);
            }
        } else {
            String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
            if (prefix == null || prefix.length() < 2) {
                prefix = "xsi";
            }
            attrVal.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", prefix + ":nil", "true");
        }
        return attrVal;
    }

    protected String[] getAttributeValuesAsStrings(QName type) {
        List avList = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (avList != null) {
            ArrayList<String> strList = new ArrayList<String>(avList.size());
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName avType = Attribute.getXsiType(av);
                if (type != null && !type.equals((Object)avType)) continue;
                strList.add(XMLUtils.collectText((Node)av));
            }
            if (strList.size() > 0) {
                return strList.toArray(new String[strList.size()]);
            }
        }
        return null;
    }

    protected String[] getAttributeValuesAsStrings(QName type, boolean includeNull) {
        List avList = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (avList != null) {
            ArrayList<String> strList = new ArrayList<String>(avList.size());
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName avType = Attribute.getXsiType(av);
                if ((avType != null || !includeNull) && type != null && !type.equals((Object)avType)) continue;
                strList.add(XMLUtils.collectText((Node)av));
            }
            if (strList.size() > 0) {
                return strList.toArray(new String[strList.size()]);
            }
        }
        return null;
    }

    protected static void setXsiType(Element element, QName type) {
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
        if (prefix == null || prefix.length() < 2) {
            prefix = "xsi";
        }
        XMLElement.addNSPrefixAttr((Element)element, (String)prefix, (String)"http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + type.getPrefix(), type.getNamespace());
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", prefix + ":type", type.toString());
    }

    protected static QName getXsiType(Element element) {
        String attrVal = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (attrVal == null || attrVal.equals("")) {
            return null;
        }
        String nsURI = QName.resolvePrefix((String)attrVal, (Node)element);
        return new QName(QName.getLocalPart((String)attrVal), nsURI, QName.getPrefixPart((String)attrVal));
    }

    public void addAttributeValue(String value) {
        Text node = value != null ? this.getOwnerDocument().createTextNode(value) : null;
        this.addAttributeValue(node, SAML2URI.encoding_xsitype_String);
    }

    public void addAttributeValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addAttributeValue(values[i]);
        }
    }

    public List getAttributeValues() {
        return SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
    }

    public String[] getAttributeValueStrings() {
        return this.getAttributeValuesAsStrings(SAML2URI.encoding_xsitype_String);
    }

    public void setName(String name) {
        this.setAttribute("Name", name);
    }

    public String getName() {
        if (this.hasAttribute("Name")) {
            return this.getAttribute("Name");
        }
        return null;
    }

    protected void setNameFormat(String formatURI) {
        this.setAttribute("NameFormat", formatURI);
    }

    public String getNameFormat() {
        if (this.hasAttribute("NameFormat")) {
            return this.getAttribute("NameFormat");
        }
        return null;
    }

    public void setFriendlyName(String fname) {
        this.setAttribute("FriendlyName", fname);
    }

    public String getFriendlyName() {
        if (this.hasAttribute("FriendlyName")) {
            return this.getAttribute("FriendlyName");
        }
        return null;
    }

    public abstract String getAttributeProfileID();

    static {
        SAML2Initializer.initialize();
    }
}

