/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

@Deprecated
public abstract class AbstractInsight
implements ActionHookInvoker,
ActionListener,
CaretListener,
CharacterTypedListener,
FocusListener,
Insight,
PopupWindowListener {
    public static final int COMPLETION_TYPE = 1;
    public static final int TOOLTIP_TYPE = 2;
    private State insightState = State.INACTIVE;
    private Timer delayTimer = null;
    private Timer matchingTimer = null;
    private boolean dataChanged = false;
    private boolean inComplete = false;
    private PopupWindow insightWindow = null;
    private InsightProvider insightProvider = null;
    private InsightProvider smartInsightProvider = null;
    private boolean insightUseSmart = false;
    private InsightView insightView = null;
    private JComponent displayComponent = null;
    private InsightData insightData = null;
    private BasicEditorPane editorPane = null;
    private boolean insightAutopopup;
    private NavigationHook navigationHook;
    private static final int UP_COMMAND = 1;
    private static final int DOWN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int PAGE_UP_COMMAND = 5;
    private static final int PAGE_DOWN_COMMAND = 6;
    private static final int BEGIN_COMMAND = 7;
    private static final int END_COMMAND = 8;
    private static final int COMPLETE_COMMAND = 9;
    private static final int PARTIAL_COMMAND = 10;
    private static final int CANCEL_COMMAND = 11;
    private static final int COMPLETION_INSIGHT_COMMAND = 12;
    private static final int TOOLTIP_INSIGHT_COMMAND = 13;
    private static final int COMPLETION_SMART_INSIGHT_COMMAND = 14;
    private static final int UNKNOWN_COMMAND = 0;
    private static HashMap commandMap = null;
    private boolean useNavigationHook = false;
    private DoubleClicker doubleClicker = null;
    private boolean completePerformed;
    public static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final int[] COMPLETION_LOCATIONS = new int[]{8, 4};
    protected static final int[] TOOLTIP_LOCATIONS = new int[]{4, 8};

    protected abstract InsightProvider createInsightProvider();

    protected InsightProvider createSmartInsightProvider() {
        return null;
    }

    public abstract boolean isInsightTriggerChar(char var1);

    protected boolean isExactMatchSupported(InsightData data) {
        return true;
    }

    protected boolean isAutomaticPartialComplete(InsightData data) {
        return false;
    }

    protected boolean isExactMatch(InsightData data) {
        return this.insightData.getMatchingDataCount() == 1;
    }

    protected int getInsightType() {
        return 1;
    }

    public final BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    public final BasicDocument getDocument() {
        return (BasicDocument)this.editorPane.getDocument();
    }

    public TextBuffer getTextBuffer() {
        BasicEditorPane editorPane = this.getEditorPane();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer;
    }

    public int getCaretPosition() {
        BasicEditorPane editorPane = this.getEditorPane();
        int caretPosition = editorPane.getCaretPosition();
        return caretPosition;
    }

    public void setAccessibleName(String name) {
        if (name != null && name.length() > 0 && this.insightWindow != null) {
            this.insightWindow.setAccessibleName(name);
        }
    }

    protected boolean usingSmartInsightProvider() {
        return this.insightUseSmart;
    }

    @Override
    public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        if (!this.insightAutopopup) {
            return;
        }
        if (this.insightState == State.INACTIVE) {
            if (this.isInsightTriggerChar(typedChar)) {
                this.restartPopupTimer();
            } else {
                this.clearPopupTimer();
            }
        }
    }

    @Override
    public boolean invokeAction(String actionKey) {
        boolean isCompletionType = this.getInsightType() == 1;
        int command = AbstractInsight.lookupCommand(actionKey);
        if (isCompletionType) {
            return this.invokeCompletionTypeAction(command);
        }
        return this.invokeTooltipTypeAction(command);
    }

    protected boolean invokeCompletionTypeAction(int command) {
        boolean canPerformComplete;
        if (command == 12 || command == 14) {
            boolean useSmart;
            boolean bl = useSmart = command == 14;
            if (this.insightState == State.INACTIVE) {
                this.insightUseSmart = useSmart;
                this.showInsight(false);
                canPerformComplete = this.checkCompleteSingleMatching("insight-manual-complete-single");
                if (canPerformComplete) {
                    command = 10;
                }
            } else if (this.insightState == State.ACTIVE && useSmart != this.insightUseSmart) {
                this.insightUseSmart = useSmart;
                this.updateInsight();
                return true;
            }
        }
        if (this.insightState == State.ACTIVE) {
            BasicEditorPane editor = this.getEditorPane();
            switch (command) {
                case 12: 
                case 14: {
                    canPerformComplete = this.checkCompleteSingleMatching("insight-manual-complete-single");
                    if (canPerformComplete && !editor.isEditable()) {
                        return false;
                    }
                    if (!canPerformComplete) {
                        return false;
                    }
                }
                case 10: {
                    canPerformComplete = this.checkCompleteSingleMatching("insight-partial-complete-single");
                    if (canPerformComplete && !editor.isEditable()) {
                        return false;
                    }
                    if (!canPerformComplete) {
                        return this.insightView.partialComplete();
                    }
                    return this.handleCompleteCommand(editor);
                }
            }
            if (!this.useNavigationHook) {
                return this.handleInsightCommands(editor, command);
            }
        }
        return false;
    }

    protected boolean invokeTooltipTypeAction(int command) {
        if (this.insightState == State.INACTIVE) {
            if (command == 13) {
                this.showInsight(false);
                return true;
            }
        } else {
            switch (command) {
                case 11: {
                    this.hideInsight();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object sourceTimer = event.getSource();
        if (sourceTimer == this.delayTimer) {
            this.showInsight();
        } else if (sourceTimer == this.matchingTimer) {
            boolean completePerformed = false;
            if (this.dataChanged) {
                this.performCompleteSingleMatching("insight-newdata-complete-single");
                this.dataChanged = false;
            }
            if (!completePerformed) {
                this.performCompleteSingleMatching("insight-typed-complete-single");
            }
        }
    }

    @Override
    public void install(BasicEditorPane editor) {
        editor.addCharacterTypedListener(this);
        editor.addActionHookInvoker(this);
        editor.addCaretListener(this);
        editor.addFocusListener(this);
        this.editorPane = editor;
        this.delayTimer = new Timer(1000, this);
        this.delayTimer.setRepeats(false);
        this.matchingTimer = new Timer(100, this);
        this.matchingTimer.setRepeats(false);
        this.checkAutopopupProperty();
        this.checkDelayProperty();
        this.setInsightProvider(this.createInsightProvider());
        if (this.getInsightType() == 1) {
            this.smartInsightProvider = this.createSmartInsightProvider();
        }
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        this.hideInsight();
        this.insightProvider = null;
        this.smartInsightProvider = null;
        this.delayTimer.stop();
        this.delayTimer = null;
        this.matchingTimer.stop();
        this.matchingTimer = null;
        editor.removeCharacterTypedListener(this);
        editor.removeActionHookInvoker(this);
        editor.removeCaretListener(this);
        editor.removeFocusListener(this);
        this.editorPane = null;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        String autopopupProperty = this.getAutopopupPropertyName();
        String delayProperty = this.getDelayPropertyName();
        if (propertyName.equals(autopopupProperty)) {
            this.checkAutopopupProperty();
        } else if (propertyName.equals(delayProperty)) {
            this.checkDelayProperty();
        }
        this.propertyChangeImpl(event);
    }

    protected void propertyChangeImpl(PropertyChangeEvent event) {
    }

    @Override
    public void restartPopupTimer() {
        if (this.insightAutopopup) {
            this.delayTimer.restart();
        }
    }

    @Override
    public void clearPopupTimer() {
        if (this.delayTimer != null) {
            this.delayTimer.stop();
        }
    }

    @Override
    public boolean isInsightVisible() {
        return this.insightWindow != null;
    }

    public Rectangle getShowRectangle() {
        Rectangle caretRect;
        int caretOffset = this.editorPane.getCaretPosition();
        try {
            caretRect = this.editorPane.getUI().modelToView(this.editorPane, caretOffset);
        }
        catch (BadLocationException e) {
            caretRect = null;
        }
        return caretRect;
    }

    @Override
    public void showInsight() {
        this.showInsight(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInsight(boolean wasAutoInvoked) {
        if (this.insightState == State.ACTIVE) {
            return;
        }
        this.clearPopupTimer();
        this.navigationHook = null;
        try {
            Object[] dataList;
            InsightData newData;
            boolean isCompletionType = this.getInsightType() == 1;
            Rectangle caretRect = this.getShowRectangle();
            if (caretRect == null) {
                return;
            }
            InsightProvider providerToUse = this.getInsightProvider();
            if (isCompletionType && this.insightUseSmart && this.smartInsightProvider != null) {
                providerToUse = this.smartInsightProvider;
            }
            BasicDocument document = (BasicDocument)this.editorPane.getDocument();
            this._acquireReadLockIfNeeded(document);
            try {
                newData = providerToUse.getInsightData(this.editorPane);
            }
            finally {
                this._releaseReadLockIfNeeded(document);
            }
            if (newData != null && (dataList = newData.getData()) != null && dataList.length != 0) {
                this.insightState = State.ACTIVE;
                this.insightData = newData;
                this.insightView = this.getInsightProvider().getInsightView();
                this.insightView.setData(this.insightData);
                if (!wasAutoInvoked && this.editorPane.isEditable() && this.performCompleteSingleMatching("insight-manual-complete-single")) {
                    return;
                }
                this.installNavigationActionHook();
                this.displayComponent = this.createPopupContent(isCompletionType);
                this.insightWindow = PopupWindowManager.showPopup((JComponent)this.editorPane, (JComponent)this.displayComponent, (boolean)false, (Rectangle)caretRect, (int[])this.getPreferredLocations(), (boolean)true);
                this.insightWindow.putClientProperty((Object)"popup-key-insight", (Object)Boolean.TRUE);
                this.insightWindow.addPopupWindowListener(new PopupWindowListener(){

                    public void popupClosed(PopupWindow popupWindow, int how) {
                        AbstractInsight.this.insightWindow.removePopupWindowListener((PopupWindowListener)this);
                        AbstractInsight.this.hideInsight();
                    }

                    public void parentFocusGained(PopupWindow popupWindow) {
                    }

                    public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
                    }
                });
                this.insightView.setPopupWindow(this.insightWindow);
                if (isCompletionType) {
                    this.insightView.selectDefault();
                    if (!wasAutoInvoked && this.isAutomaticPartialComplete(this.insightData)) {
                        this.insightView.partialComplete();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            this.hideInsight();
        }
    }

    private JComponent createPopupContent(boolean isCompletionType) {
        JComponent insightComponent = this.insightView.getComponent();
        this.redirectActions(insightComponent);
        JPanel contentPanel = new JPanel(new BorderLayout());
        if (isCompletionType) {
            JScrollPane scrollPane = new JScrollPane(insightComponent);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setBorder(null);
            insightComponent = scrollPane;
            insightComponent.validate();
            contentPanel.setBorder(UIManager.getBorder("ToolTip.border"));
        }
        contentPanel.add((Component)insightComponent, "Center");
        JComponent statusComponent = this.createStatusComponent();
        if (statusComponent != null) {
            contentPanel.add((Component)statusComponent, "South");
        }
        return contentPanel;
    }

    protected JComponent createStatusComponent() {
        return null;
    }

    protected void installNavigationActionHook() {
        boolean isCompletionType;
        boolean bl = isCompletionType = this.getInsightType() == 1;
        if (isCompletionType) {
            this.navigationHook = new NavigationHook();
            this.editorPane.addPreActionInvoker(this.navigationHook, 1.0);
        }
    }

    protected void deinstallNavigationActionHook() {
        boolean isCompletionType;
        boolean bl = isCompletionType = this.getInsightType() == 1;
        if (isCompletionType && this.navigationHook != null) {
            this.editorPane.removePreActionInvoker(this.navigationHook, 1.0);
            this.navigationHook = null;
        }
    }

    @Override
    public void hideInsight() {
        if (this.insightWindow != null) {
            PopupWindowManager.dismissPopup((PopupWindow)this.insightWindow);
        }
        this.unredirectActions();
        this.deinstallNavigationActionHook();
        this.insightWindow = null;
        this.insightData = null;
        this.insightUseSmart = false;
        this.insightView = null;
        this.insightState = State.INACTIVE;
        this.displayComponent = null;
        if (this.matchingTimer != null) {
            this.matchingTimer.stop();
        }
    }

    protected boolean useDefaultReadLock() {
        return true;
    }

    private void _acquireReadLockIfNeeded(BasicDocument document) {
        if (this.useDefaultReadLock()) {
            document.readLock();
        }
    }

    private void _releaseReadLockIfNeeded(BasicDocument document) {
        if (this.useDefaultReadLock()) {
            document.readUnlock();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.clearPopupTimer();
    }

    public void popupClosed(PopupWindow popupWindow, int how) {
        this.insightWindow = null;
        this.hideInsight();
    }

    public void parentFocusGained(PopupWindow popupWindow) {
    }

    public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
        this.hideInsight();
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        if (this.insightState == State.INACTIVE) {
            this.clearPopupTimer();
        } else {
            this.updateInsight();
        }
    }

    protected final boolean wasCompletePerformed() {
        return this.completePerformed;
    }

    public void showFeedback(String feedbackMessage) {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editorPane, feedbackMessage);
        }
    }

    public void showFeedback(String feedbackMessage, int hideDelay) {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editorPane, feedbackMessage, hideDelay);
        }
    }

    public void hideFeedback() {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.hideFeedback(editorPane);
        }
    }

    protected final boolean isActive() {
        return this.insightState == State.ACTIVE;
    }

    private boolean checkCompleteSingleMatching(String propertyName) {
        boolean isCompletionType;
        boolean bl = isCompletionType = this.getInsightType() == 1;
        if (!isCompletionType) {
            return false;
        }
        boolean checkSingleMatching = this.getEditorPane().getBooleanProperty(propertyName);
        if (checkSingleMatching && this.insightData != null) {
            return this.isExactMatchSupported(this.insightData) && this.isExactMatch(this.insightData);
        }
        return false;
    }

    private boolean performCompleteSingleMatching(String propertyName) {
        if (!this.editorPane.isEditable()) {
            return false;
        }
        this.completePerformed = false;
        boolean canComplete = this.checkCompleteSingleMatching(propertyName);
        if (canComplete) {
            this.inComplete = true;
            this.insightView.selectDefault();
            this.completePerformed = this.insightView.complete(this);
            this.inComplete = false;
            if (this.completePerformed) {
                this.hideInsight();
            }
            return this.completePerformed;
        }
        return false;
    }

    private String getAutopopupPropertyName() {
        int insightType = this.getInsightType();
        switch (insightType) {
            case 1: {
                return "completion-enable-autopopup";
            }
            case 2: {
                return "parameter-enable-autopopup";
            }
        }
        throw new IllegalStateException("Unknown type: " + insightType);
    }

    private String getDelayPropertyName() {
        int insightType = this.getInsightType();
        switch (insightType) {
            case 1: {
                return "completion-popup-delay";
            }
            case 2: {
                return "parameter-popup-delay";
            }
        }
        throw new IllegalStateException("Unknown type: " + insightType);
    }

    private void checkAutopopupProperty() {
        BasicEditorPane editor = this.getEditorPane();
        String propertyName = this.getAutopopupPropertyName();
        Boolean autopopup = (Boolean)editor.getProperty(propertyName);
        this.insightAutopopup = autopopup;
    }

    private void checkDelayProperty() {
        BasicEditorPane editor = this.getEditorPane();
        String propertyName = this.getDelayPropertyName();
        int insightDelay = (Integer)editor.getProperty(propertyName);
        this.delayTimer.setInitialDelay(insightDelay);
        this.delayTimer.setDelay(insightDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInsight() {
        if (this.insightState == State.ACTIVE && !this.inComplete) {
            Object[] dataList;
            InsightData newData;
            boolean isCompletionType = this.getInsightType() == 1;
            InsightProvider providerToUse = this.getInsightProvider();
            if (isCompletionType && this.insightUseSmart && this.smartInsightProvider != null) {
                providerToUse = this.smartInsightProvider;
            }
            BasicDocument document = (BasicDocument)this.editorPane.getDocument();
            this._acquireReadLockIfNeeded(document);
            try {
                newData = providerToUse.updateInsightData(this.editorPane, this.insightData);
            }
            finally {
                this._releaseReadLockIfNeeded(document);
            }
            boolean doHideInsight = true;
            if (newData != null && (dataList = newData.getData()) != null && dataList.length != 0) {
                this.matchingTimer.stop();
                Class<?> oldClass = this.insightData.getClass();
                Class<?> newClass = newData.getClass();
                this.insightData = newData;
                this.insightView.setData(this.insightData);
                doHideInsight = false;
                if (!oldClass.equals(newClass) && this.checkCompleteSingleMatching("insight-newdata-complete-single")) {
                    this.dataChanged = true;
                    this.matchingTimer.restart();
                }
                if (this.checkCompleteSingleMatching("insight-typed-complete-single")) {
                    this.matchingTimer.restart();
                }
                this.displayComponent.validate();
                Rectangle caretRect = this.getShowRectangle();
                if (caretRect == null) {
                    caretRect = new Rectangle();
                }
                if (this.insightWindow != null && this.insightWindow.getWindow() != null) {
                    this.insightWindow.updatePopupContent(this.displayComponent, false);
                }
                if (isCompletionType) {
                    this.insightView.selectDefault();
                }
            }
            if (doHideInsight) {
                this.hideInsight();
            }
        }
    }

    protected int[] getPreferredLocations() {
        int type = this.getInsightType();
        return switch (type) {
            case 1 -> COMPLETION_LOCATIONS;
            case 2 -> TOOLTIP_LOCATIONS;
            default -> throw new IllegalStateException("unknown type: " + type);
        };
    }

    private void redirectActions(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        boolean isCompletionType = this.getInsightType() == 1;
        KeyStroke escapeKey = KeyStroke.getKeyStroke("ESCAPE");
        String escapeName = "cancel";
        ActionWrapper escapeAction = new ActionWrapper(this, escapeName);
        inputMap.put(escapeKey, escapeName);
        actionMap.put(escapeName, escapeAction);
        if (isCompletionType) {
            KeyStroke enterKey = KeyStroke.getKeyStroke("ENTER");
            String enterName = "insert-break";
            ActionWrapper enterAction = new ActionWrapper(this, enterName);
            inputMap.put(enterKey, enterName);
            actionMap.put(enterName, enterAction);
            KeyStroke tabKey = KeyStroke.getKeyStroke("TAB");
            String tabName = "insert-tab";
            ActionWrapper tabAction = new ActionWrapper(this, tabName);
            inputMap.put(tabKey, tabName);
            actionMap.put(tabName, tabAction);
            if (this.doubleClicker != null) {
                component.removeMouseListener(this.doubleClicker);
            }
            this.doubleClicker = new DoubleClicker(this.navigationHook, "insert-break");
            component.addMouseListener(this.doubleClicker);
        }
    }

    private void unredirectActions() {
        if (this.insightView != null && this.doubleClicker != null) {
            JComponent component = this.insightView.getComponent();
            component.removeMouseListener(this.doubleClicker);
            this.doubleClicker = null;
        }
    }

    protected static int lookupCommand(String actionKey) {
        Integer command = (Integer)commandMap.get(actionKey);
        return command == null ? 0 : command;
    }

    private static void initializeCommandMap() {
        if (commandMap == null) {
            commandMap = new HashMap(10);
            Integer up = 1;
            commandMap.put("caret-up", up);
            commandMap.put("selection-up", up);
            Integer down = 2;
            commandMap.put("caret-down", down);
            commandMap.put("selection-down", down);
            Integer left = 3;
            commandMap.put("caret-backward", left);
            commandMap.put("selection-backward", left);
            Integer right = 4;
            commandMap.put("caret-forward", right);
            commandMap.put("selection-forward", right);
            Integer pageUp = 5;
            commandMap.put("page-up", pageUp);
            commandMap.put("selection-page-up", pageUp);
            Integer pageDown = 6;
            commandMap.put("page-down", pageDown);
            commandMap.put("selection-page-down", pageDown);
            Integer begin = 7;
            commandMap.put("caret-begin", begin);
            commandMap.put("selection-begin", begin);
            commandMap.put("caret-begin-line", begin);
            commandMap.put("selection-begin-line", begin);
            Integer end = 8;
            commandMap.put("caret-end", end);
            commandMap.put("selection-end", end);
            commandMap.put("caret-end-line", end);
            commandMap.put("selection-end-line", end);
            Integer complete = 9;
            commandMap.put("insert-break", complete);
            Integer partial = 10;
            commandMap.put("insert-tab", partial);
            Integer cancel = 11;
            commandMap.put("cancel", cancel);
            Integer completionInsight = 12;
            commandMap.put("completion-insight", completionInsight);
            Integer smartCompletionInsight = 14;
            commandMap.put("smart-completion-insight", smartCompletionInsight);
            Integer tooltipInsight = 13;
            commandMap.put("tooltip-insight", tooltipInsight);
        }
    }

    private boolean handleInsightCommands(BasicEditorPane editor, int command) {
        switch (command) {
            case 9: {
                return this.handleCompleteCommand(editor);
            }
            case 1: {
                return this.handleUpCommand(editor);
            }
            case 2: {
                return this.handleDownCommand(editor);
            }
            case 3: {
                return this.handleLeftCommand(editor);
            }
            case 4: {
                return this.handleRightCommand(editor);
            }
            case 5: {
                return this.handlePageUpCommand(editor);
            }
            case 6: {
                return this.handlePageDownCommand(editor);
            }
            case 7: {
                return this.handleHomeCommand(editor);
            }
            case 8: {
                return this.handleEndCommand(editor);
            }
            case 11: {
                return this.handleCancelCommand(editor);
            }
            case 12: {
                return this.handleInsightCommand(editor);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCompleteCommand(BasicEditorPane editor) {
        this.inComplete = true;
        boolean returnValue = false;
        try {
            InsightView pinnedInsightView = this.insightView;
            if (pinnedInsightView != null) {
                if (!editor.isEditable() && !editor.makeEditable()) {
                    Toolkit.getDefaultToolkit().beep();
                    boolean bl = returnValue = false;
                    return bl;
                }
                returnValue = pinnedInsightView.complete(this);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, "AbstractInsight - handle completion exception", e);
            this.hideInsight();
        }
        finally {
            this.inComplete = false;
            editor.requestFocus();
        }
        return returnValue;
    }

    protected boolean handleUpCommand(BasicEditorPane editor) {
        return this.insightView.up();
    }

    protected boolean handleDownCommand(BasicEditorPane editor) {
        return this.insightView.down();
    }

    protected boolean handleLeftCommand(BasicEditorPane editor) {
        return this.insightView.left();
    }

    protected boolean handleRightCommand(BasicEditorPane editor) {
        return this.insightView.right();
    }

    protected boolean handlePageUpCommand(BasicEditorPane editor) {
        return this.insightView.pageUp();
    }

    protected boolean handlePageDownCommand(BasicEditorPane editor) {
        return this.insightView.pageDown();
    }

    protected boolean handleHomeCommand(BasicEditorPane editor) {
        return this.insightView.begin();
    }

    protected boolean handleEndCommand(BasicEditorPane editor) {
        return this.insightView.end();
    }

    protected boolean handleCancelCommand(BasicEditorPane editor) {
        this.hideInsight();
        editor.requestFocus();
        return true;
    }

    protected boolean handleInsightCommand(BasicEditorPane editor) {
        return false;
    }

    public void setUseSmartInsight(boolean useSmartInsight) {
        this.insightUseSmart = useSmartInsight;
    }

    public boolean isUseSmartInsight() {
        return this.insightUseSmart;
    }

    protected InsightProvider getInsightProvider() {
        return this.insightProvider;
    }

    protected void setInsightProvider(InsightProvider insightProvider) {
        this.insightProvider = insightProvider;
    }

    static {
        AbstractInsight.initializeCommandMap();
    }

    protected static enum State {
        INACTIVE,
        ACTIVE;

    }

    private static final class DoubleClicker
    extends MouseAdapter {
        private ActionPreInvoker preInvoker;
        private String commandName;

        private DoubleClicker(ActionPreInvoker invoker, String commandName) {
            this.preInvoker = invoker;
            this.commandName = commandName;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if ((event.getModifiers() & 0x10) != 0 && event.getClickCount() == 2) {
                this.preInvoker.invokeAction(this.commandName);
            }
        }
    }

    protected class NavigationHook
    implements ActionPreInvoker {
        protected NavigationHook() {
        }

        @Override
        public boolean invokeAction(String actionKey) {
            AbstractInsight.this.useNavigationHook = true;
            if (AbstractInsight.this.insightState == State.ACTIVE) {
                int command = AbstractInsight.lookupCommand(actionKey);
                BasicEditorPane editor = AbstractInsight.this.getEditorPane();
                return AbstractInsight.this.handleInsightCommands(editor, command);
            }
            return false;
        }
    }

    private static final class ActionWrapper
    extends AbstractAction {
        private ActionHookInvoker invoker;

        private ActionWrapper(ActionHookInvoker invoker, String commandName) {
            super(commandName);
            this.invoker = invoker;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String name = (String)this.getValue("Name");
            this.invoker.invokeAction(name);
        }
    }
}

