/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.find.Find;

public final class Replacement {
    private final Find find;
    private final String foundText;
    private final String replacementText;
    private final TextRange replacementRange;
    private final ReplaceType replaceType;
    private boolean disposed = false;

    Replacement(ReplaceType replaceType, Find find, String foundText, String replacementText, TextRange replacementRange) {
        this.replaceType = replaceType;
        this.find = find;
        this.foundText = foundText;
        this.replacementText = replacementText;
        this.replacementRange = replacementRange;
    }

    public void dispose() {
        this.replacementRange.dispose();
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        assert (this.disposed);
        super.finalize();
    }

    public ReplaceType getReplaceType() {
        return this.replaceType;
    }

    public Find getFind() {
        return this.find;
    }

    public String getFoundText() {
        return this.foundText;
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public TextRange getReplacementRange() {
        return this.replacementRange;
    }

    static enum ReplaceType {
        SKIP,
        REPLACE;

    }
}

