/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;
import oracle.javatools.util.Pair;

public final class Utilities {
    public static int getTextWidth(TextBuffer textBuffer, int startOffset, int endOffset, int tabSize, int startColumn) {
        int bufferEnd = textBuffer.getLength();
        startOffset = Math.min(Math.max(0, startOffset), bufferEnd);
        endOffset = Math.min(Math.max(0, endOffset), bufferEnd);
        int currentOffset = startOffset;
        int currentColumn = startColumn;
        block4: while (currentOffset < endOffset) {
            char c = textBuffer.getChar(currentOffset++);
            switch (c) {
                case '\t': {
                    currentColumn = Utilities.getNextTabStop(tabSize, currentColumn);
                }
                case '\n': 
                case '\r': {
                    continue block4;
                }
            }
            ++currentColumn;
        }
        return currentColumn - startColumn;
    }

    public static int getNextTabStop(int tabSize, int startColumn) {
        if (tabSize <= 0 || startColumn < 0) {
            throw new IllegalArgumentException("bad tab size or column");
        }
        switch (tabSize) {
            case 1: {
                return startColumn + 1;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return (startColumn & ~(tabSize - 1)) + tabSize;
            }
        }
        int tabColumn = startColumn - startColumn % tabSize + tabSize;
        return tabColumn;
    }

    public static int getLineFromOffset(TextBuffer textBuffer, int offset) {
        LineMap lineMap = textBuffer.getLineMap();
        return lineMap.getLineFromOffset(offset);
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int offset, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int line = lineMap.getLineFromOffset(offset);
        return Utilities.getColumnFromOffset(textBuffer, line, offset, tabSize);
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int line, int offset, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        if (lineStart == offset) {
            return 0;
        }
        return Utilities.getTextWidth(textBuffer, lineStart, offset, tabSize, 0);
    }

    public static int getOffsetFromColumn(TextBuffer textBuffer, int line, int column, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        int lineEnd = lineMap.getLineEndOffset(line);
        if (column == 0) {
            return lineStart;
        }
        int currentOffset = lineStart;
        int currentColumn = 0;
        boolean done = false;
        while (!done && currentOffset < lineEnd) {
            char c = textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    ++currentOffset;
                    currentColumn = Utilities.getNextTabStop(tabSize, currentColumn);
                    break;
                }
                case '\n': 
                case '\r': {
                    return currentOffset;
                }
                default: {
                    ++currentOffset;
                    ++currentColumn;
                }
            }
            if (currentColumn < column) continue;
            if (currentColumn <= column) break;
            --currentOffset;
            break;
        }
        return currentOffset;
    }

    public static int getRowStart(BasicDocument document, int offset) {
        offset = Math.max(offset, 0);
        offset = Math.min(offset, document.getLength());
        LineMap lineMap = document.getLineMap();
        int currentLine = lineMap.getLineFromOffset(offset);
        int lineStart = lineMap.getLineStartOffset(currentLine);
        return lineStart;
    }

    public static int getRowEnd(BasicDocument document, int offset) {
        offset = Math.max(offset, 0);
        offset = Math.min(offset, document.getLength());
        LineMap lineMap = document.getLineMap();
        int currentLine = lineMap.getLineFromOffset(offset);
        int lineEnd = lineMap.getLineEndOffset(currentLine);
        int lineCount = lineMap.getLineCount();
        if (lineCount - 1 != currentLine) {
            --lineEnd;
        }
        return lineEnd;
    }

    private static WordLocator getWordLocator(BasicDocument document) {
        LanguageSupport support = document.getLanguageSupport();
        return support.getWordLocator();
    }

    public static int getWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        return locator.getWordStart(offset);
    }

    public static int getWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        return locator.getWordEnd(offset);
    }

    public static int getNextWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordStart = locator.getNextWordStart(offset);
        return wordStart;
    }

    public static int getNextWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordEnd = locator.getNextWordEnd(offset);
        return wordEnd;
    }

    public static int getPreviousWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordStart = locator.getPreviousWordStart(offset);
        return wordStart;
    }

    public static int getPreviousWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordEnd = locator.getPreviousWordEnd(offset);
        return wordEnd;
    }

    public static boolean testBit(int value, int flag) {
        return (value & flag) != 0;
    }

    public static int setBit(int value, int flag) {
        return value | flag;
    }

    public static int clearBit(int value, int flag) {
        return value & ~flag;
    }

    public static String trimCommonWhitespace(String text) {
        int i;
        String line;
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        Object startSeq = "";
        int firstLine = 0;
        while (((String)startSeq).length() == 0) {
            char c;
            if (!st.hasMoreTokens()) {
                return text;
            }
            line = st.nextToken();
            ++firstLine;
            if (line.equals("\n")) continue;
            for (i = 0; i < line.length() && Character.isWhitespace(c = line.charAt(i)); ++i) {
                startSeq = (String)startSeq + c;
            }
        }
        if (((String)startSeq).length() == 0) {
            return text;
        }
        block2: while (st.hasMoreTokens()) {
            line = st.nextToken();
            if (line.equals("\n")) continue;
            int len = Math.min(line.length(), ((String)startSeq).length());
            for (i = 0; i < len; ++i) {
                char cs;
                char cl = line.charAt(i);
                if (cl == (cs = ((String)startSeq).charAt(i))) continue;
                startSeq = line.substring(0, i);
                continue block2;
            }
        }
        StringBuffer sb = new StringBuffer();
        st = new StringTokenizer(text, "\n", true);
        for (i = 0; i < firstLine - 1; ++i) {
            sb.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            String line2 = st.nextToken();
            if (line2.equals("\n")) {
                sb.append("\n");
                continue;
            }
            if (line2.length() >= ((String)startSeq).length()) {
                sb.append(line2.substring(((String)startSeq).length()));
                continue;
            }
            sb.append(line2);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getCurrentWord(BasicEditorPane editor) {
        return (String)Utilities.getCurrentWordAndOffset((BasicEditorPane)editor).first;
    }

    public static Pair<String, Integer> getCurrentWordAndOffset(BasicEditorPane editor) {
        String s = null;
        int start = editor.getSelectionStart();
        int end = editor.getSelectionEnd();
        try {
            if (start == end) {
                int nLine = editor.getLineFromOffset(start);
                int nLineStart = editor.getLineStartOffset(nLine);
                int nLineEnd = editor.getLineEndOffset(nLine);
                int nLineLength = nLineEnd - nLineStart;
                if (nLineStart < nLineEnd) {
                    char c;
                    Document doc = editor.getDocument();
                    String line = doc.getText(nLineStart, nLineEnd - nLineStart);
                    for (start = end = start - nLineStart; start > 0 && (Character.isJavaIdentifierPart(c = line.charAt(start - 1)) || Character.isJavaIdentifierStart(c)); --start) {
                    }
                    while (end < nLineLength && (Character.isJavaIdentifierPart(c = line.charAt(end)) || Character.isJavaIdentifierStart(c))) {
                        ++end;
                    }
                    if (start != end) {
                        s = line.substring(start, end);
                    }
                }
                start += nLineStart;
            } else {
                int nLineEnd;
                int nLineStart = editor.getLineFromOffset(start);
                if (nLineStart == (nLineEnd = editor.getLineFromOffset(end))) {
                    Document doc = editor.getDocument();
                    s = doc.getText(start, end - start);
                }
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (NullPointerException npEx) {
            Logger.getLogger("global").log(Level.SEVERE, npEx.getLocalizedMessage());
        }
        return new Pair<Object, Integer>(s, start);
    }
}

