/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.tools.DbCartTool;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.dbdiff.DBDiffApi;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DbCartRefreshTool
extends DbCartTool {
    public static final String TYPE = "Refresh";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_refresh");
    private static final Logger LOGGER = Logger.getLogger(DBDiffApi.class.getName());
    private JEWTDialog _actionDialog;

    public DbCartRefreshTool() {
        super(TYPE, 1);
    }

    public DbCartRefreshTool(String string, int n) {
        super(string, n);
    }

    @Override
    public void toolWillEnable() {
        this.enableIfCurrentCart();
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("CART_REFRESH_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
            this._action.addController((Controller)this);
            this.setEnabled(false);
        }
        return this._action;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.refreshCart();
            return true;
        }
        return false;
    }

    private void refreshCart() {
        final DbCartTask dbCartTask = new DbCartTask();
        dbCartTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    boolean bl = (Boolean)dbCartTask.getResult();
                    if (!bl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("NOT_EXISTS_ERROR"), (String)DbCartAddinArb.getString("CART_REFRESH_LABEL"), (String)"DBCART_EXISTS_WARNING");
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    LOGGER.log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)dbCartTask);
    }

    @Override
    public void openConfigOptions() {
    }

    @Override
    public void saveConfigOptions() {
    }

    private class DbCartTask
    extends RaptorTask<Boolean> {
        boolean _allExists;

        public DbCartTask() {
            super(DbCartAddinArb.getString("CART_REFRESH_LABEL"), false, IRaptorTaskRunMode.MODAL_OPTIONAL);
        }

        protected Boolean doWork() {
            block3: {
                try {
                    this._allExists = DbCartUtil.getReconciler().reconcileExistence(DbCartUtil.getTableModel().getRowList(), this.getRaptorTaskProgressUpdater());
                }
                catch (ExecutionException executionException) {
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof CancellationException) break block3;
                    LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
            return this._allExists;
        }
    }
}

