/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.report;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorAppEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorListener;

public class Summary
implements FileProcessorListener {
    private int m_totalFiles = 0;
    private ArrayList<Stat> callSummary = new ArrayList();
    private ArrayList<FileStat> fileCallSummary = new ArrayList();
    private ArrayList<String> distinctFileNames;
    private HashMap<String, ArrayList<String>> distinctTypes;
    private ArrayList<Loc> locSummary = new ArrayList();

    public Summary() {
        this.distinctFileNames = new ArrayList();
        this.distinctTypes = new HashMap();
    }

    public ArrayList<Stat> getCallSummary() {
        return this.callSummary;
    }

    public ArrayList<FileStat> getfileCallSummary() {
        return this.fileCallSummary;
    }

    private void addTotalFiles(int n) {
        this.m_totalFiles = n;
    }

    private void addType(String string, String string2) {
        if (this.distinctTypes.keySet().contains(string)) {
            ArrayList<String> arrayList = this.distinctTypes.get(string);
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.distinctTypes.put(string, arrayList);
        }
    }

    public void addCall(String string, String string2) {
        boolean bl = false;
        for (Stat object : this.callSummary) {
            if (!object.getCall().equals(string2)) continue;
            object.add(1);
            bl = true;
        }
        if (!bl) {
            this.callSummary.add(new Stat(string2, 1));
        }
        bl = false;
        for (FileStat fileStat : this.fileCallSummary) {
            if (!fileStat.getFile().equals(string) || !fileStat.getCall().equals(string2)) continue;
            fileStat.add(1);
            bl = true;
        }
        if (!bl) {
            this.fileCallSummary.add(new FileStat(string, string2, 1));
        }
        if (!this.distinctFileNames.contains(string.intern())) {
            this.distinctFileNames.add(string.intern());
        }
    }

    private void addLoc(String string, int n) {
        this.locSummary.add(new Loc(string, n));
    }

    public int getTotalCalls() {
        int n = 0;
        for (Stat stat : this.callSummary) {
            n += stat.getNum().intValue();
        }
        return n;
    }

    public int getDistinctFiles() {
        return this.fileCallSummary.size();
    }

    public String getCallBreakDownCount() {
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(this.callSummary, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Stat)object2).getNum().compareTo(((Stat)object).getNum());
            }
        });
        for (Stat stat : this.callSummary) {
            stringBuilder.append("\t" + stat.getNum() + ":\t" + stat.getCall() + "\n");
        }
        return stringBuilder.toString();
    }

    public String getTypeBreakDownByNumber() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.distinctTypes.keySet()) {
            int n = this.distinctTypes.get(string).size();
            stringBuilder.append(MessageFormat.format("\t {0}\t {1} file{2}\n", string, n, n > 1 ? "s" : ""));
        }
        return stringBuilder.toString();
    }

    public int getTotalLoc() {
        int n = 0;
        for (Loc loc : this.locSummary) {
            n += loc.getLoc();
        }
        return n;
    }

    public int getTotalTypes() {
        return this.distinctTypes.keySet().size();
    }

    public int getTotalFilesInSource() {
        return this.m_totalFiles;
    }

    public String getCallBreakDownCountByFile() {
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(this.fileCallSummary, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                FileStat fileStat = (FileStat)object;
                FileStat fileStat2 = (FileStat)object2;
                if (fileStat.getFile().equals(fileStat2.getFile())) {
                    return fileStat2.getNum().compareTo(fileStat.getNum());
                }
                return fileStat.getFile().compareTo(fileStat2.getFile());
            }
        });
        for (String string : this.distinctFileNames) {
            stringBuilder.append(string + "\n");
            for (FileStat fileStat : this.fileCallSummary) {
                if (!fileStat.getFile().equals(string)) continue;
                stringBuilder.append("\t" + fileStat.getNum() + ":\t" + fileStat.getCall() + "\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void raiseEvent(FileProcessorEvent fileProcessorEvent) {
        FileProcessorAppEvent fileProcessorAppEvent;
        if (fileProcessorEvent instanceof FileProcessorArtifactEvent) {
            FileProcessorArtifactEvent fileProcessorArtifactEvent = (FileProcessorArtifactEvent)fileProcessorEvent;
            this.addCall(fileProcessorArtifactEvent.getFilename(), fileProcessorArtifactEvent.getStringFound());
        } else if (fileProcessorEvent instanceof FileProcessorFileEvent) {
            this.addType(((FileProcessorFileEvent)fileProcessorEvent).getLanguageType(), ((FileProcessorFileEvent)fileProcessorEvent).getFileName());
            this.addLoc(((FileProcessorFileEvent)fileProcessorEvent).getFileName(), ((FileProcessorFileEvent)fileProcessorEvent).getLineCount());
        } else if (fileProcessorEvent instanceof FileProcessorAppEvent && (fileProcessorAppEvent = (FileProcessorAppEvent)fileProcessorEvent).getTotalFiles() > 0) {
            this.addTotalFiles(fileProcessorAppEvent.getTotalFiles());
        }
    }

    @Override
    public void raiseEvent(ArrayList<FileProcessorArtifactEvent> arrayList) {
        for (FileProcessorArtifactEvent fileProcessorArtifactEvent : arrayList) {
            this.raiseEvent(fileProcessorArtifactEvent);
        }
    }

    public int getTotalFiles() {
        return this.distinctFileNames.size();
    }

    public int getDistinctCalls() {
        return this.callSummary.size();
    }

    class Stat {
        private int _num;
        private String _call;

        Stat(String string, int n) {
            this._call = string;
            this._num = n;
        }

        public void add(int n) {
            this._num += n;
        }

        public String getCall() {
            return this._call;
        }

        public Integer getNum() {
            return this._num;
        }
    }

    class FileStat {
        private int _num;
        private String _call;
        private String _file;

        FileStat(String string, String string2, int n) {
            this._call = string2;
            this._num = n;
            this._file = string;
        }

        public void add(int n) {
            this._num += n;
        }

        public String getCall() {
            return this._call;
        }

        public Integer getNum() {
            return this._num;
        }

        public String getFile() {
            return this._file;
        }
    }

    class Loc {
        private String _file;
        private int _loc;

        Loc(String string, int n) {
            this._file = string;
            this._loc = n;
        }

        public void addLoc(int n) {
            this._loc = n;
        }

        public String getFileName() {
            return this._file;
        }

        public int getLoc() {
            return this._loc;
        }
    }
}

