/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.number;

import java.math.BigDecimal;
import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.number.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.number.Messages;

public class BigDecimalTransformer
implements Transformer<String, BigDecimal> {
    @Override
    public BigDecimal transform(String rawValue, TransformContext context, Environment environment) {
        BigDecimal value = null;
        try {
            value = BigDecimal.valueOf(Long.valueOf(rawValue));
        }
        catch (NumberFormatException ex) {
            context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
        }
        return value;
    }

    @Override
    public String getFormat(Locale locale) {
        return HelpMessages.getString(HelpMessages.Key.INTEGER, locale);
    }
}

