/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class Accept
extends CommandListener {
    private ScriptRunnerContext m_ctx = null;
    private Connection m_conn = null;
    public static String[][] driver = new String[][]{{null, "NUM", "NUMB", "NUMBE", "NUMBER", "CHAR", "DATE", "BINARY_FLOAT", "BINARY_DOUBLE"}, {"true", "FOR", "FORM", "FORMA", "FORMAT"}, {"true", "DEF", "DEFA", "DEFAU", "DEFAUL", "DEFAULT"}, {"true", "PROMPT"}, {null, "NOPROMPT"}, {null, "HIDE"}};
    private static int TYPE = 0;
    private static int FORMAT = 1;
    private static int DEFAULT = 2;
    private static int PROMPT = 3;
    private static int NOPROMPT = 4;
    private static int HIDE = 5;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.m_ctx = ctx;
        this.m_conn = conn;
        try {
            this.runAccept(ctx, cmd);
        }
        catch (NoConnectionException e) {
            ctx.write(Messages.getString("ACCEPTNOCONNECTION"));
            ScriptUtils.doWhenever(ctx, cmd, conn, true);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private String stripIfNumber(String type, String val) {
        if (type != null && val != null && (type.equals("NUMBER") || type.equals("BINARY_FLOAT") || type.equals("BINARY_DOUBLE"))) {
            val = val.trim();
        }
        return val;
    }

    private String zeroIfNumber(String type, String val) {
        if (type != null && (val == null || val.equals("")) && (type.equals("NUMBER") || type.equals("BINARY_FLOAT") || type.equals("BINARY_DOUBLE"))) {
            val = "0";
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAccept(ScriptRunnerContext ctx, ISQLCommand cmd) throws NoConnectionException {
        boolean hide = false;
        String[] args = cmd.getSQLOrig().trim().split("\\s+");
        if (args.length == 1 && args[0].toLowerCase().equals("accept")) {
            Accept.write(Messages.getString("Accept.2"), this.m_ctx);
            ctx.errorLog(ctx.getSourceRef(), Messages.getString("Accept.2"), cmd.getSql());
            return;
        }
        cmd.setSql(SQLPLUSUtil.removeDashNewline(cmd, cmd.getSql()));
        String localVarName = null;
        List src = Lexer.parse((String)cmd.getSql(), (boolean)false);
        if (src.size() > 1 && !((LexerToken)src.get((int)1)).content.trim().equals("")) {
            localVarName = ((LexerToken)src.get((int)1)).content.trim();
            String[][] firstPass = Accept.parse(ctx, cmd, src, cmd.getSql());
            if (firstPass == null) {
                return;
            }
            if (firstPass[HIDE][0] != null) {
                hide = true;
            }
            String promptText = "";
            boolean errorOut = false;
            if (firstPass[PROMPT][0] != null) {
                promptText = firstPass[PROMPT][1];
            }
            String defaultText = "";
            if (!errorOut && firstPass[DEFAULT][0] != null) {
                defaultText = firstPass[DEFAULT][1];
            }
            String formatString = null;
            if (!errorOut && firstPass[FORMAT][0] != null) {
                formatString = firstPass[FORMAT][1];
            }
            String requiredType = null;
            if (!errorOut && firstPass[TYPE][0] != null) {
                String possibleType = firstPass[TYPE][0];
                if (possibleType.equals("NUM") || possibleType.equals("NUMB") || possibleType.equals("NUMBE") || possibleType.equals("NUMBER")) {
                    requiredType = "NUMBER";
                } else if (possibleType.equals("DATE") || possibleType.equals("BINARY_FLOAT") || possibleType.equals("BINARY_DOUBLE")) {
                    requiredType = possibleType;
                }
            }
            if (!errorOut) {
                if (requiredType != null && requiredType.equals("DATE") && (formatString == null || formatString.equals(""))) {
                    formatString = ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)) != false ? "DD-MON-RR" : DBUtil.getInstance(ctx.getCurrentConnection()).executeReturnOneCol("SELECT value FROM   nls_session_parameters WHERE  parameter = 'NLS_DATE_FORMAT'");
                }
                String retVal = null;
                boolean validated = false;
                Object lastError = null;
                defaultText = this.stripIfNumber(requiredType, defaultText);
                defaultText = this.zeroIfNumber(requiredType, defaultText);
                boolean skipDefaultCheck = false;
                if (requiredType != null && requiredType.toUpperCase().startsWith("DATE") && (ctx == null || ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue())) {
                    DBUtil dbUtil = DBUtil.getInstance(ctx.getCurrentConnection());
                    ArrayList<String> bindL = new ArrayList<String>();
                    bindL.add(formatString);
                    dbUtil.getLastException();
                    if (ctx == null || ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                        String notUsed = dbUtil.executeReturnOneCol("SELECT to_char(sysdate,:1) from Dual", bindL);
                        SQLException e = dbUtil.getLastException();
                        if (e != null) {
                            Accept.errorWrap(ctx, cmd, ScriptRunnerDbArb.format("ACCEPT_BAD_DATE_MASK", formatString) + "\n");
                            return;
                        }
                    }
                    if (defaultText == null || defaultText.equals("")) {
                        skipDefaultCheck = true;
                    }
                }
                if (!skipDefaultCheck && !this.validateDefaultAndFormat(defaultText, formatString, requiredType, ctx, cmd)) {
                    return;
                }
                while (!validated) {
                    String errorAndPrompt = null;
                    errorAndPrompt = promptText;
                    retVal = this.m_ctx.getPromptedFieldProvider().getPromptedField(this.m_ctx, errorAndPrompt, hide);
                    if (retVal == null && hide) {
                        retVal = "";
                    }
                    if (retVal == null) {
                        String wasCalled = "Commit";
                        if (this.m_conn != null && LockManager.lock(this.m_conn)) {
                            try {
                                if (this.m_ctx.getProperty("script.runner.exitcommit") != null && this.m_ctx.getProperty("script.runner.exitcommit").equals("OFF")) {
                                    wasCalled = "Rollback";
                                    this.m_conn.rollback();
                                } else {
                                    this.m_conn.commit();
                                }
                            }
                            catch (SQLException e) {
                                Accept.write(ScriptRunnerDbArb.format("ERROR_ON", wasCalled), this.m_ctx);
                            }
                            finally {
                                LockManager.unlock(this.m_conn);
                            }
                        }
                        this.m_ctx.setExited(true);
                        return;
                    }
                    if (retVal.equals("")) {
                        retVal = defaultText;
                    }
                    if (retVal == null && formatString != null && !formatString.equals("")) {
                        Accept.write(MessageFormat.format("SP2-0598:\"\" does not match input format \"{0}\"\n", formatString), this.m_ctx);
                        ctx.errorLog(ctx.getSourceRef(), MessageFormat.format("SP2-0598:\"\" does not match input format \"{0}\"\n", formatString), cmd.getSql());
                        continue;
                    }
                    int errorNumber = 0;
                    errorNumber = this.acceptValidate(retVal = this.stripIfNumber(requiredType, retVal), requiredType, formatString);
                    validated = errorNumber == 0;
                    lastError = null;
                    String maybeMaskedInput = retVal;
                    if (hide) {
                        maybeMaskedInput = "*********";
                    }
                    if (!validated && requiredType != null && requiredType.equals("DATE")) {
                        Accept.errorWrap(ctx, cmd, ScriptRunnerDbArb.format("ACCEPT_DATE_ERROR", maybeMaskedInput, formatString) + "\n");
                    } else if (errorNumber == 1722 && formatString != null && !formatString.equals("")) {
                        if (ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
                            Accept.writeAndFlush(MessageFormat.format("SP2-0598: \"{0}\" does not match input format \"{1}\"\n", retVal, formatString), this.m_ctx);
                            ctx.errorLog(ctx.getSourceRef(), MessageFormat.format("SP2-0598:\"\" does not match input format \"{0}\"\n", formatString), cmd.getSql());
                        } else {
                            Accept.writeAndFlush(MessageFormat.format("SP2-0598: \"{0}\" does not match input format \"{1}\"\n", maybeMaskedInput, formatString), this.m_ctx);
                            ctx.errorLog(ctx.getSourceRef(), MessageFormat.format("SP2-0598:\"\" does not match input format \"{0}\"\n", formatString), cmd.getSql());
                        }
                    } else if (errorNumber == -1 || errorNumber > 0) {
                        if (errorNumber == 1722) {
                            Accept.errorWrap(ctx, cmd, MessageFormat.format(Messages.getString("Accept.19_gen"), retVal, requiredType.toUpperCase(Locale.US)));
                            ctx.errorLog(ctx.getSourceRef(), MessageFormat.format(Messages.getString("Accept.19_gen"), retVal, requiredType.toUpperCase(Locale.US)), cmd.getSql());
                        } else {
                            Accept.errorWrap(ctx, cmd, ScriptRunnerDbArb.getString("ACCEPT_STATEMENT_MUST_SPECIFY") + "\n");
                            ctx.errorLog(ctx.getSourceRef(), ScriptRunnerDbArb.getString("ACCEPT_STATEMENT_MUST_SPECIFY") + "\n", cmd.getSql());
                        }
                    }
                    if (!validated) continue;
                    Map<String, String> m = this.m_ctx.getMap();
                    m.put(localVarName.toUpperCase(Locale.US), retVal);
                }
            }
        } else {
            Accept.write(ScriptRunnerContext.lineErr(new Integer(cmd.getStartLine() + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.getString("ACCEPT_STATEMENT_MUST_SPECIFY") + "\n", this.m_ctx), this.m_ctx);
            Accept.writeAndFlush("\n", this.m_ctx);
        }
    }

    private static void writeAndFlush(String string, ScriptRunnerContext ctx) {
        Accept.write(string, ctx);
        try {
            ctx.getOutputStream().flush();
        }
        catch (IOException e) {
            Logger.getLogger(new Accept().getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private boolean validateDefaultAndFormat(String defaultText, String formatString, String dataType, ScriptRunnerContext ctx, ISQLCommand cmd) throws NoConnectionException {
        if ((defaultText == null || defaultText.equals("")) && (formatString == null || formatString.equals(""))) {
            return true;
        }
        int errorNumber = 0;
        String value = defaultText;
        if (value == null || value.equals("")) {
            value = dataType != null && dataType.toUpperCase().startsWith("DATE") ? "" : "0";
        }
        if ((errorNumber = this.acceptValidate(value, dataType, formatString)) > 0) {
            if (errorNumber == 1722) {
                if (formatString == null || formatString.equals("")) {
                    Accept.writeAndFlush(MessageFormat.format(Messages.getString("Accept.19"), value), this.m_ctx);
                    ctx.errorLog(ctx.getSourceRef(), MessageFormat.format(Messages.getString("Accept.19"), value), cmd.getSql());
                } else {
                    Accept.writeAndFlush(MessageFormat.format(Messages.getString("Accept.20"), value, formatString), this.m_ctx);
                    ctx.errorLog(ctx.getSourceRef(), MessageFormat.format(Messages.getString("Accept.20"), value), cmd.getSql());
                }
            } else {
                Accept.writeAndFlush(MessageFormat.format(Messages.getString("Accept.21"), formatString, dataType), this.m_ctx);
                ctx.errorLog(ctx.getSourceRef(), MessageFormat.format(Messages.getString("Accept.21"), value), cmd.getSql());
            }
        } else if (errorNumber == -1 && formatString != null && !formatString.equals("")) {
            Accept.writeAndFlush(MessageFormat.format(Messages.getString("Accept.ValueFormat"), value, formatString), this.m_ctx);
            ctx.errorLog(ctx.getSourceRef(), MessageFormat.format(Messages.getString("Accept.ValueFormat"), value), cmd.getSql());
        }
        return errorNumber == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int acceptValidate(String promptResult, String requiredType, String formatString) throws NoConnectionException {
        int ACCEPTED = 0;
        int INVALID = -1;
        int BAD = -2;
        try {
            if (requiredType == null) {
                if (formatString != null && formatString.matches("^[aA][0-9]*$")) {
                    String formatNumber = formatString.replaceAll("^[aA]([0-9]*)$", "$1");
                    Integer formatInt = null;
                    try {
                        formatInt = Integer.parseInt(formatNumber);
                    }
                    catch (NumberFormatException nfe) {
                        return INVALID;
                    }
                    if (!promptResult.matches(".{0," + formatInt + "}")) return 1722;
                    return ACCEPTED;
                }
                if (formatString == null) return 0;
                if (formatString.matches("^[aA][0-9]*$")) return 0;
                return INVALID;
            }
            if (requiredType != null && requiredType.equals("DATE")) {
                if (promptResult == null) return 1722;
                if (promptResult.equals("")) {
                    return 1722;
                }
            }
            if (this.m_ctx.getCurrentConnection() == null) throw new NoConnectionException();
            if (this.m_ctx.getProperty("script.runner.sqlplus.nolog") != null && this.m_ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)) {
                throw new NoConnectionException();
            }
            ResultSet rs = null;
            Statement s = null;
            boolean amILocked = false;
            String succeeded = null;
            try {
                amILocked = LockManager.lock(this.m_ctx.getCurrentConnection());
                if (!amILocked) {
                    int n = INVALID;
                    return n;
                }
                if (formatString != null && !formatString.equals("")) {
                    s = this.m_ctx.getCurrentConnection().prepareStatement("select TO_CHAR(TO_" + requiredType + "(:v,:f)) from dual");
                    s.setString(1, promptResult);
                    s.setString(2, formatString);
                } else {
                    s = this.m_ctx.getCurrentConnection().prepareStatement("select TO_CHAR(TO_" + requiredType + "(:v)) from dual");
                    s.setString(1, promptResult);
                }
                rs = s.executeQuery();
                if (!rs.next()) return ACCEPTED;
                succeeded = rs.getString(1);
                if (succeeded != null && !succeeded.equals(null)) {
                    if (!succeeded.equals("")) return ACCEPTED;
                }
                if (promptResult == null) return ACCEPTED;
                if (promptResult.equals("")) return ACCEPTED;
                int n = BAD;
                return n;
            }
            catch (SQLException e) {
                String cause = e.getMessage();
                if (cause == null) {
                    int n = INVALID;
                    return n;
                }
                int hasReturn = cause.indexOf(10);
                if (hasReturn != -1) {
                    cause = cause.substring(0, hasReturn);
                }
                if (!cause.matches("^[oO][rR][aA]-[0-9]*.*")) {
                    int n = INVALID;
                    return n;
                }
                Integer causeNumber = null;
                try {
                    causeNumber = Integer.parseInt(cause.replaceAll("^[oO][rR][aA]-([0-9]*).*", "$1"));
                }
                catch (NumberFormatException e2) {
                    int n = INVALID;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!amILocked) return n;
                    try {
                        LockManager.unlock(this.m_ctx.getCurrentConnection());
                        return n;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n;
                }
                if (causeNumber == 1481 || causeNumber > 1809 && causeNumber < 1830) {
                    int n = causeNumber;
                    return n;
                }
                if (causeNumber != null && causeNumber == 1722) {
                    int n = causeNumber;
                    return n;
                }
                int n = INVALID;
                return n;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                if (amILocked) {
                    try {
                        LockManager.unlock(this.m_ctx.getCurrentConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof NoConnectionException)) return INVALID;
            throw e;
        }
    }

    private String[] nextWordAndRest(String in) {
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        int i = 0;
        boolean inQuote = false;
        boolean found = false;
        String rest = "";
        String firstWord = "";
        for (i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '\"') {
                inQuote = !inQuote;
            }
            if (!Character.isWhitespace(in.charAt(i)) || inQuote) continue;
            found = true;
            break;
        }
        if (found) {
            rest = in.substring(i).trim();
            firstWord = in.substring(0, i);
        } else {
            firstWord = in;
        }
        String[] stringArray = new String[]{firstWord, rest};
        return stringArray;
    }

    public static void write(String str, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream out = ctx.getOutputStream();
        try {
            ((FilterOutputStream)out).write(ctx.stringToByteArrayForScriptRunnerNonStatic(str));
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            Logger.getLogger(new Accept().getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public static String[][] parse(ScriptRunnerContext ctx, ISQLCommand cmd, List<LexerToken> src, String in) {
        String[][] retVal = new String[][]{{null}, {null}, {null}, {null}, {null}, {null}};
        for (int i = 2; i < src.size(); ++i) {
            LexerToken t = src.get(i);
            boolean matchFound = false;
            boolean skipTwo = false;
            String tUpper = t.content.toUpperCase(Locale.US);
            for (int di = 0; di < driver.length; ++di) {
                String[] checkThese = driver[di];
                for (int ii = 1; ii < checkThese.length; ++ii) {
                    String[] subParse;
                    if (!tUpper.equals(checkThese[ii])) continue;
                    if (checkThese[0] != null) {
                        if (i + 1 < src.size()) {
                            skipTwo = true;
                            matchFound = true;
                            subParse = new String[]{tUpper, Accept.fixMe(src.get((int)(i + 1)).content)};
                            retVal[di] = subParse;
                            break;
                        }
                        Accept.errorWrap(ctx, cmd, Messages.getString("ACCEPTEOL"));
                        return null;
                    }
                    subParse = new String[]{tUpper, null};
                    retVal[di] = subParse;
                    matchFound = true;
                    break;
                }
                if (matchFound) break;
            }
            if (matchFound) {
                if (skipTwo) {
                    ++i;
                }
            } else {
                Accept.report(ctx, cmd, i, t, src, in);
                return null;
            }
            skipTwo = false;
            matchFound = false;
        }
        return retVal;
    }

    public static void report(ScriptRunnerContext ctx, ISQLCommand cmd, int i, LexerToken t, List<LexerToken> src, String in) {
        Accept.errorWrap(ctx, cmd, MessageFormat.format(Messages.getString("ACCEPTNOMATCH"), in.substring(t.begin)));
    }

    public static String fixMe(String in) {
        if (in.startsWith("'") && in.endsWith("'") && in.length() > 1) {
            return in.substring(1, in.length() - 1).replaceAll("''", "'");
        }
        if (in.startsWith("\"") && in.endsWith("\"") && in.length() > 1) {
            return in.substring(1, in.length() - 1).replaceAll("\"\"", "\"");
        }
        return in;
    }

    public static void errorWrap(ScriptRunnerContext ctx, ISQLCommand cmd, String theValue) {
        if (ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            Accept.writeAndFlush(theValue, ctx);
        } else {
            Accept.writeAndFlush(ScriptRunnerContext.lineErr(new Integer(cmd.getStartLine() + 1), cmd.getSQLOrig(), theValue, ctx), ctx);
        }
    }

    public static class NoConnectionException
    extends Exception {
    }
}

