/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.newscriptrunner.BufferedReaderStack;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptParser;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;

public class MySQLScriptParser
extends ScriptParser
implements IScriptParser {
    static final String DELIMITER = "DELIMITER";
    static final String DEFAULT_DELIMITER = ";";
    String current_delimiter = ";";

    public MySQLScriptParser(Reader rdr) {
        super(rdr);
    }

    @Override
    public ISQLCommand next() throws IOException {
        ISQLCommand cmd = null;
        boolean custom_parsing = false;
        if (this.current_delimiter.equals(DEFAULT_DELIMITER)) {
            custom_parsing = false;
            this.customParsing(false);
            cmd = super.next();
        } else {
            custom_parsing = true;
            this.customParsing(true);
            cmd = super.next();
        }
        if (cmd == null) {
            return null;
        }
        if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQL && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) {
            cmd.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
            cmd.setStmtSubType(SQLCommand.StmtSubType.G_S_CALL);
        } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_DELIMITER && !custom_parsing) {
            String delimiter = this.getDelimiter(cmd.getSQLOrig());
            if (delimiter != null && delimiter.length() > 0) {
                this.current_delimiter = delimiter;
            }
        } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_USE) {
            cmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
        }
        return cmd;
    }

    @Override
    public StringBuffer customFindEndOfStatement(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        if (stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_DELIMITER) {
            String delimiter = this.getDelimiter(line);
            if (delimiter != null && delimiter.length() > 0) {
                this.current_delimiter = delimiter;
            }
            searching = false;
            currentStatement.append(line + "\n");
        }
        while (searching) {
            int indexOfDelimiter = line.indexOf(this.current_delimiter);
            if (indexOfDelimiter == -1) {
                searching = true;
                currentStatement.append(line + "\n");
                line = reader.readline(true, false, null, true, this.stateInitial());
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                continue;
            }
            searching = false;
            currentStatement.append(line.substring(0, indexOfDelimiter) + "\n");
            this.setLeftOver(line.substring(indexOfDelimiter + this.current_delimiter.length()));
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        if (currentStatement.toString().trim().endsWith(this.current_delimiter) && currentStatement.length() > 1) {
            String s = currentStatement.substring(0, currentStatement.lastIndexOf(this.current_delimiter));
            currentStatement = new StringBuffer(s);
            stmtProperties.setStatementTerminator(this.current_delimiter);
        }
        return currentStatement;
    }

    private String getDelimiter(String line) {
        return line.trim().substring(DELIMITER.length()).trim();
    }

    public static boolean isMySQL(Connection conn) {
        try {
            if (conn != null && conn.getMetaData().getDriverName().startsWith("MySQL")) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }
}

