/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionReference;
import oracle.dbtools.raptor.datatypes.PropertyChanger;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionLockableImpl;

public class DataTypeConnectionReferenceImpl<C extends Connection>
extends DataTypeConnectionLockableImpl<C>
implements DataTypeConnectionReference<C>,
PropertyChanger {
    protected static final Object _UNKNOWN_ = new Object();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile Object connection;

    public DataTypeConnectionReferenceImpl(Class<C> connectionClass) {
        this(connectionClass, null);
    }

    public DataTypeConnectionReferenceImpl(Class<C> connectionClass, C connection) {
        super(connectionClass);
        this.connection = _UNKNOWN_;
        this.connection = this.wrap(connection);
    }

    protected DataTypeConnectionReferenceImpl(Class<C> connectionClass, Object connection) {
        super(connectionClass);
        this.connection = connection;
        this.peekConnection();
    }

    protected Object wrap(C connection) {
        return new WeakReference<C>(connection);
    }

    protected C unwrap(Object connection) {
        return (C)((Connection)this.getConnectionClass().cast(((WeakReference)connection).get()));
    }

    protected C nullify() {
        C ret = this.unwrap(this.connection);
        ((WeakReference)this.connection).clear();
        return ret;
    }

    @Override
    public final synchronized C releaseConnection() {
        return (C)this.setConnection((C)null);
    }

    protected final C setConnection(Object connection) throws DataTypeConnectionException {
        C ret = this.unwrap(this.connection);
        this.unwrap(connection);
        this.connection = connection;
        return ret;
    }

    protected C setConnection(C connection) throws DataTypeConnectionException {
        C oldConnection;
        Object object = oldConnection = connection == null ? this.nullify() : this.setConnection((C)this.wrap(connection));
        if (oldConnection != connection) {
            this.firePropertyChange("connection", oldConnection, connection);
        }
        return oldConnection;
    }

    @Override
    public C getConnection() {
        return this.peekConnection();
    }

    @Override
    public final C peekConnection() {
        return this.unwrap(this.connection);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

